/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel.datatype;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import uk.ac.manchester.cs.jfact.dep.DepSet;
import uk.ac.manchester.cs.jfact.dep.DepSetFactory;
import uk.ac.manchester.cs.jfact.helpers.DLVertex;
import uk.ac.manchester.cs.jfact.helpers.LeveLogger;
import uk.ac.manchester.cs.jfact.helpers.Reference;
import uk.ac.manchester.cs.jfact.helpers.UnreachableSituationException;
import uk.ac.manchester.cs.jfact.kernel.DLDag;
import uk.ac.manchester.cs.jfact.kernel.NamedEntry;
import uk.ac.manchester.cs.jfact.kernel.datatype.DataEntry;
import uk.ac.manchester.cs.jfact.kernel.datatype.DataInterval;
import uk.ac.manchester.cs.jfact.kernel.datatype.DataTypeAppearance;
import uk.ac.manchester.cs.jfact.kernel.datatype.Datatyped;
import uk.ac.manchester.cs.jfact.kernel.datatype.Datatypes;

public final class DataTypeReasoner {
    private final Map<Datatypes, DataTypeAppearance<?>> map = new HashMap();
    private final DLDag dlHeap;
    private final Reference<DepSet> clashDep = new Reference();

    private <O> boolean processDataValue(boolean pos, DataEntry<O> c, DepSet dep) {
        DataTypeAppearance<?> type = this.map.get((Object)c.getDatatype());
        if (pos) {
            type.setPType(new DataTypeAppearance.DepDTE(c, dep));
        }
        DataInterval<O> constraints = new DataInterval<O>();
        constraints.updateMin(false, c.getComp());
        constraints.updateMax(false, c.getComp());
        return type.addInterval(pos, constraints, dep);
    }

    private <O> boolean processDataExpr(boolean pos, DataEntry<O> c, DepSet dep) {
        DataInterval<O> constraints = c.getFacet();
        if (constraints.isEmpty()) {
            return false;
        }
        DataTypeAppearance<?> type = this.map.get((Object)c.getDatatype());
        if (pos) {
            type.setPType(new DataTypeAppearance.DepDTE(c, dep));
        }
        return type.addInterval(pos, constraints, dep);
    }

    private NamedEntry getDataEntry(int p) {
        return this.dlHeap.get(p).getConcept();
    }

    private DataTypeAppearance.DepDTE getDTE(int p, DepSet dep) {
        return new DataTypeAppearance.DepDTE(this.getDataEntry(p), dep);
    }

    public DataTypeReasoner(DLDag dag) {
        this.dlHeap = dag;
    }

    protected void registerDataType(Datatypes p) {
        this.map.put(p, new DataTypeAppearance(this.clashDep));
    }

    public void clear() {
        for (DataTypeAppearance<?> p : this.map.values()) {
            p.clear();
        }
    }

    public DepSet getClashSet() {
        return this.clashDep.getReference();
    }

    public boolean addDataEntry(int p, DepSet dep) {
        DLVertex v = this.dlHeap.get(p);
        NamedEntry dataEntry = this.getDataEntry(p);
        switch (v.getType()) {
            case dtDataType: {
                Datatypes t = ((Datatyped)((Object)dataEntry)).getDatatype();
                DataTypeAppearance<?> type = this.map.get((Object)t);
                LeveLogger.logger.print(LeveLogger.Templates.INTERVAL, p > 0 ? "+" : "-", dataEntry.getName());
                if (p > 0) {
                    type.setPType(this.getDTE(p, dep));
                } else {
                    type.setNType(this.getDTE(p, dep));
                }
                return false;
            }
            case dtDataValue: {
                return this.processDataValue(p > 0, (DataEntry)dataEntry, dep);
            }
            case dtDataExpr: {
                return this.processDataExpr(p > 0, (DataEntry)dataEntry, dep);
            }
            case dtAnd: {
                return false;
            }
        }
        throw new UnreachableSituationException(v.toString());
    }

    public boolean checkClash() {
        ArrayList types = new ArrayList();
        for (Map.Entry<Datatypes, DataTypeAppearance<?>> k : this.map.entrySet()) {
            if (!k.getValue().hasPType() && !k.getValue().hasNType()) continue;
            types.add(k);
        }
        int size = types.size();
        if (size == 0) {
            return false;
        }
        if (size == 1) {
            return ((DataTypeAppearance)((Map.Entry)types.get(0)).getValue()).checkPNTypeClash();
        }
        if (size > 1) {
            int i;
            for (i = 0; i < size; ++i) {
                Map.Entry p = (Map.Entry)types.get(i);
                if (!((DataTypeAppearance)p.getValue()).checkPNTypeClash()) continue;
                LeveLogger.logger.print(LeveLogger.Templates.CHECKCLASH, new Object[0]);
                this.clashDep.setReference(((DataTypeAppearance)p.getValue()).getPType().second);
                return true;
            }
            for (i = 0; i < size; ++i) {
                Map.Entry p1 = (Map.Entry)types.get(i);
                for (int j = i + 1; j < size; ++j) {
                    Map.Entry p2 = (Map.Entry)types.get(j);
                    if (((Datatypes)((Object)p1.getKey())).compatible((Datatypes)((Object)p2.getKey())) && ((DataTypeAppearance)p1.getValue()).hasNType() && ((DataTypeAppearance)p2.getValue()).hasPType()) {
                        LeveLogger.logger.print(LeveLogger.Templates.CHECKCLASH, new Object[0]);
                        this.clashDep.setReference(DepSetFactory.plus(((DataTypeAppearance)p1.getValue()).hasPType() ? ((DataTypeAppearance)p1.getValue()).getPType().second : ((DataTypeAppearance)p1.getValue()).getNType().second, ((DataTypeAppearance)p2.getValue()).hasPType() ? ((DataTypeAppearance)p2.getValue()).getPType().second : ((DataTypeAppearance)p2.getValue()).getNType().second));
                        return true;
                    }
                    if (((Datatypes)((Object)p2.getKey())).compatible((Datatypes)((Object)p1.getKey())) && ((DataTypeAppearance)p2.getValue()).hasNType() && ((DataTypeAppearance)p1.getValue()).hasPType()) {
                        LeveLogger.logger.print(LeveLogger.Templates.CHECKCLASH, new Object[0]);
                        this.clashDep.setReference(DepSetFactory.plus(((DataTypeAppearance)p1.getValue()).hasPType() ? ((DataTypeAppearance)p1.getValue()).getPType().second : ((DataTypeAppearance)p1.getValue()).getNType().second, ((DataTypeAppearance)p2.getValue()).hasPType() ? ((DataTypeAppearance)p2.getValue()).getPType().second : ((DataTypeAppearance)p2.getValue()).getNType().second));
                        return true;
                    }
                    if (((Datatypes)((Object)p1.getKey())).compatible((Datatypes)((Object)p2.getKey())) || ((Datatypes)((Object)p2.getKey())).compatible((Datatypes)((Object)p1.getKey())) || !((DataTypeAppearance)p1.getValue()).hasPType() || !((DataTypeAppearance)p2.getValue()).hasPType() || ((DataTypeAppearance)p1.getValue()).checkCompatibleValue((DataTypeAppearance)p2.getValue(), (Datatypes)((Object)p1.getKey()), (Datatypes)((Object)p2.getKey()))) continue;
                    LeveLogger.logger.print(LeveLogger.Templates.CHECKCLASH, new Object[0]);
                    this.clashDep.setReference(DepSetFactory.plus(((DataTypeAppearance)p1.getValue()).getPType().second, ((DataTypeAppearance)p2.getValue()).getPType().second));
                    return true;
                }
            }
            return false;
        }
        return false;
    }
}

