/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel.datatype;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.semanticweb.owlapi.reasoner.ReasonerInternalException;
import uk.ac.manchester.cs.jfact.kernel.datatype.BoolRep;
import uk.ac.manchester.cs.jfact.kernel.datatype.ByteRep;
import uk.ac.manchester.cs.jfact.kernel.datatype.DatatypeRepresentation;
import uk.ac.manchester.cs.jfact.kernel.datatype.DateTimeRep;
import uk.ac.manchester.cs.jfact.kernel.datatype.DecimalRep;
import uk.ac.manchester.cs.jfact.kernel.datatype.DoubleRep;
import uk.ac.manchester.cs.jfact.kernel.datatype.FloatRep;
import uk.ac.manchester.cs.jfact.kernel.datatype.IntRep;
import uk.ac.manchester.cs.jfact.kernel.datatype.IntegerRep;
import uk.ac.manchester.cs.jfact.kernel.datatype.NegIntRep;
import uk.ac.manchester.cs.jfact.kernel.datatype.NonNegIntRep;
import uk.ac.manchester.cs.jfact.kernel.datatype.NonPosIntRep;
import uk.ac.manchester.cs.jfact.kernel.datatype.PosIntRep;
import uk.ac.manchester.cs.jfact.kernel.datatype.RationalRep;
import uk.ac.manchester.cs.jfact.kernel.datatype.RealRep;
import uk.ac.manchester.cs.jfact.kernel.datatype.ShortRep;
import uk.ac.manchester.cs.jfact.kernel.datatype.StringRep;
import uk.ac.manchester.cs.jfact.kernel.datatype.UnsignedByteRep;
import uk.ac.manchester.cs.jfact.kernel.datatype.UnsignedShortRep;

public enum Datatypes {
    INT{

        public DatatypeRepresentation<Integer> parse(String s) {
            return new IntRep(Integer.valueOf(s));
        }

        public DatatypeRepresentation<Integer> build(Object s) {
            return new IntRep((Integer)s);
        }

        @Override
        public boolean compatible(Datatypes d) {
            return super.compatible(d) || EnumSet.of(NEGINT, POSINT, NONNEGINT, NONPOSINT).contains((Object)d);
        }
    }
    ,
    DECIMAL{

        public DatatypeRepresentation<BigDecimal> parse(String s) {
            return new DecimalRep(new BigDecimal(s));
        }

        public DatatypeRepresentation<BigDecimal> build(Object s) {
            return new DecimalRep((BigDecimal)s);
        }

        @Override
        public boolean compatible(Datatypes d) {
            return super.compatible(d) || EnumSet.of(INT, NEGINT, POSINT, NONNEGINT, NONPOSINT).contains((Object)d);
        }
    }
    ,
    SHORT{

        public DatatypeRepresentation<Short> parse(String s) {
            return new ShortRep(Short.valueOf(s));
        }

        public DatatypeRepresentation<Short> build(Object s) {
            return new ShortRep((Short)s);
        }

        @Override
        public boolean compatible(Datatypes d) {
            return super.compatible(d) || d == UNSIGNEDSHORT;
        }
    }
    ,
    UNSIGNEDSHORT{

        public DatatypeRepresentation<Short> parse(String s) {
            return new UnsignedShortRep(Short.valueOf(s));
        }

        public DatatypeRepresentation<Short> build(Object s) {
            return new UnsignedShortRep((Short)s);
        }
    }
    ,
    BYTE{

        public DatatypeRepresentation<Byte> parse(String s) {
            return new ByteRep(Byte.valueOf(s));
        }

        public DatatypeRepresentation<Byte> build(Object s) {
            return new ByteRep((Byte)s);
        }

        @Override
        public boolean compatible(Datatypes d) {
            return super.compatible(d) || d == SHORT || d == UNSIGNEDBYTE || d == UNSIGNEDSHORT;
        }
    }
    ,
    UNSIGNEDBYTE{

        public DatatypeRepresentation<Byte> parse(String s) {
            return new UnsignedByteRep(Byte.valueOf(s));
        }

        public DatatypeRepresentation<Byte> build(Object s) {
            return new UnsignedByteRep((Byte)s);
        }

        @Override
        public boolean compatible(Datatypes d) {
            return super.compatible(d) || d == UNSIGNEDSHORT;
        }
    }
    ,
    BOOLEAN{

        public DatatypeRepresentation<Boolean> parse(String s) {
            return new BoolRep(Boolean.valueOf(s));
        }

        public DatatypeRepresentation<Boolean> build(Object s) {
            return new BoolRep((Boolean)s);
        }
    }
    ,
    DOUBLE{

        public DatatypeRepresentation<Double> parse(String s) {
            return new DoubleRep(8.parseDouble(s));
        }

        public DatatypeRepresentation<Double> build(Object s) {
            return new DoubleRep((Double)s);
        }
    }
    ,
    FLOAT{

        public DatatypeRepresentation<Float> parse(String s) {
            return new FloatRep(Float.valueOf(s.replace("inf", "Infinity").replace("INF", "Infinity")));
        }

        public DatatypeRepresentation<Float> build(Object s) {
            return new FloatRep((Float)s);
        }
    }
    ,
    STRING{

        public DatatypeRepresentation<String> parse(String s) {
            return new StringRep(s);
        }

        public DatatypeRepresentation<String> build(Object s) {
            return new StringRep((String)s);
        }
    }
    ,
    LITERAL{

        public DatatypeRepresentation<Object> parse(String s) {
            return null;
        }

        public DatatypeRepresentation<Object> build(Object s) {
            return null;
        }

        @Override
        public boolean compatible(Datatypes d) {
            return true;
        }
    }
    ,
    DATETIME{

        public DatatypeRepresentation<XMLGregorianCalendar> parse(String s) {
            XMLGregorianCalendar cal;
            try {
                cal = DatatypeFactory.newInstance().newXMLGregorianCalendar(s);
            }
            catch (DatatypeConfigurationException e) {
                throw new ReasonerInternalException((Throwable)e);
            }
            catch (IllegalArgumentException e) {
                throw new ReasonerInternalException("Error parsing " + s, (Throwable)e);
            }
            return new DateTimeRep(cal);
        }

        public DatatypeRepresentation<XMLGregorianCalendar> build(Object s) {
            return new DateTimeRep((XMLGregorianCalendar)s);
        }
    }
    ,
    POSINT{

        public DatatypeRepresentation<Integer> parse(String s) {
            return new PosIntRep(Integer.valueOf(s));
        }

        public DatatypeRepresentation<Integer> build(Object s) {
            return new PosIntRep((Integer)s);
        }
    }
    ,
    NEGINT{

        public DatatypeRepresentation<Integer> parse(String s) {
            return new NegIntRep(Integer.valueOf(s));
        }

        public DatatypeRepresentation<Integer> build(Object s) {
            return new NegIntRep((Integer)s);
        }
    }
    ,
    NONPOSINT{

        public DatatypeRepresentation<Integer> parse(String s) {
            return new NonPosIntRep(Integer.valueOf(s));
        }

        public DatatypeRepresentation<Integer> build(Object s) {
            return new NonPosIntRep((Integer)s);
        }

        @Override
        public boolean compatible(Datatypes d) {
            return super.compatible(d) || d == NEGINT;
        }

        @Override
        public boolean compatible(Datatypes d, Object o) {
            if (d == NONNEGINT) {
                if (o == null) {
                    return true;
                }
                if (o instanceof Integer) {
                    return (Integer)o == 0;
                }
            }
            return super.compatible(d, o);
        }
    }
    ,
    NONNEGINT{

        public DatatypeRepresentation<Integer> parse(String s) {
            return new NonNegIntRep(Integer.valueOf(s));
        }

        public DatatypeRepresentation<Integer> build(Object s) {
            return new NonNegIntRep((Integer)s);
        }

        @Override
        public boolean compatible(Datatypes d) {
            return super.compatible(d) || d == POSINT;
        }

        @Override
        public boolean compatible(Datatypes d, Object o) {
            if (d == NONPOSINT) {
                if (o == null) {
                    return true;
                }
                if (o instanceof Integer) {
                    return (Integer)o == 0;
                }
            }
            return super.compatible(d, o);
        }
    }
    ,
    REAL{

        public DatatypeRepresentation<BigDecimal> parse(String s) {
            return new RealRep(new BigDecimal(s));
        }

        public DatatypeRepresentation<BigDecimal> build(Object s) {
            return new RealRep((BigDecimal)s);
        }

        @Override
        public boolean compatible(Datatypes d) {
            return super.compatible(d) || EnumSet.complementOf(EnumSet.of(STRING, DATETIME, DOUBLE, FLOAT)).contains((Object)d);
        }
    }
    ,
    RATIONAL{

        public DatatypeRepresentation<BigDecimal> parse(String s) {
            return new RationalRep(new BigDecimal(18.parseDouble(s)));
        }

        public DatatypeRepresentation<BigDecimal> build(Object s) {
            return new RationalRep((BigDecimal)s);
        }

        @Override
        public boolean compatible(Datatypes d) {
            return d != DECIMAL && REAL.compatible(d);
        }
    }
    ,
    INTEGER{

        public DatatypeRepresentation<BigInteger> parse(String s) {
            return new IntegerRep(new BigInteger(s));
        }

        public DatatypeRepresentation<BigInteger> build(Object s) {
            return new IntegerRep((BigInteger)s);
        }

        @Override
        public boolean compatible(Datatypes d) {
            return d != DECIMAL && REAL.compatible(d);
        }
    }
    ,
    FRESH{

        @Override
        public boolean compatible(Datatypes d) {
            return true;
        }

        public DatatypeRepresentation<Object> build(Object s) {
            return null;
        }

        public DatatypeRepresentation<Object> parse(String s) {
            return null;
        }
    };

    static final String pattern = "\\-?[0-9]+(\\.[0-9]+)?([eE]\\-?[0-9]+)?";
    static final String fractionPattern = "(\\-?)([0-9]+)/([0-9]+)";
    static final Pattern regularFloat;
    static final Pattern fraction;
    private static final Map<String, Datatypes> datatypeMap;

    public abstract <O> DatatypeRepresentation<O> parse(String var1);

    public abstract <O> DatatypeRepresentation<O> build(O var1);

    public boolean compatible(Datatypes d) {
        return d == this;
    }

    public boolean compatible(Datatypes d, Object o) {
        return this.compatible(d);
    }

    public static final Float parseFloat(String s) {
        Matcher m = regularFloat.matcher(s);
        if (m.matches()) {
            return Float.valueOf(s);
        }
        if (s.contains("inf") || s.contains("INF") || s.contains("Inf")) {
            return Float.valueOf(s.replace("inf", "Infinity").replace("INF", "Infinity"));
        }
        Pattern p = Pattern.compile(fractionPattern);
        m = p.matcher(s);
        if (m.matches()) {
            return Float.valueOf((float)(m.group(1).length() == 0 ? 1 : -1) * Float.parseFloat(m.group(2)) / Float.parseFloat(m.group(3)));
        }
        throw new NumberFormatException("Unparsable float: " + s);
    }

    public static final Double parseDouble(String s) {
        Matcher m = regularFloat.matcher(s);
        if (m.matches()) {
            return Double.valueOf(s);
        }
        if (s.contains("inf") || s.contains("INF") || s.contains("Inf")) {
            return Double.valueOf(s.replace("inf", "Infinity").replace("INF", "Infinity"));
        }
        Pattern p = Pattern.compile(fractionPattern);
        m = p.matcher(s);
        if (m.matches()) {
            return (double)(m.group(1).length() == 0 ? 1 : -1) * Double.parseDouble(m.group(2)) / Double.parseDouble(m.group(3));
        }
        throw new NumberFormatException("Unparsable double: " + s);
    }

    public static Datatypes getBuiltInDataType(String DTName) {
        if (datatypeMap.containsKey(DTName)) {
            return datatypeMap.get(DTName);
        }
        throw new ReasonerInternalException("Unsupported datatype " + DTName);
    }

    private static Map<String, Datatypes> buildDatatypeMap() {
        HashMap<String, Datatypes> toReturn = new HashMap<String, Datatypes>();
        toReturn.put("http://www.w3.org/2000/01/rdf-schema#Literal", LITERAL);
        toReturn.put("http://www.w3.org/2000/01/rdf-schema#anySimpleType", LITERAL);
        toReturn.put("http://www.w3.org/2001/XMLSchema#anyType", LITERAL);
        toReturn.put("http://www.w3.org/2001/XMLSchema#anySimpleType", LITERAL);
        toReturn.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#PlainLiteral", STRING);
        toReturn.put("http://www.w3.org/1999/02/22-rdf-syntax-ns#XMLLiteral", STRING);
        toReturn.put("http://www.w3.org/2001/XMLSchema#string", STRING);
        toReturn.put("http://www.w3.org/2001/XMLSchema#anyURI", STRING);
        toReturn.put("http://www.w3.org/2001/XMLSchema#integer", INTEGER);
        toReturn.put("http://www.w3.org/2001/XMLSchema#int", INT);
        toReturn.put("http://www.w3.org/2001/XMLSchema#nonNegativeInteger", NONNEGINT);
        toReturn.put("http://www.w3.org/2001/XMLSchema#positiveInteger", POSINT);
        toReturn.put("http://www.w3.org/2001/XMLSchema#negativeInteger", NEGINT);
        toReturn.put("http://www.w3.org/2001/XMLSchema#short", SHORT);
        toReturn.put("http://www.w3.org/2001/XMLSchema#byte", BYTE);
        toReturn.put("http://www.w3.org/2001/XMLSchema#unsignedByte", UNSIGNEDBYTE);
        toReturn.put("http://www.w3.org/2001/XMLSchema#unsignedInt", INT);
        toReturn.put("http://www.w3.org/2001/XMLSchema#unsignedShort", UNSIGNEDSHORT);
        toReturn.put("http://www.w3.org/2001/XMLSchema#nonPositiveInteger", NONPOSINT);
        toReturn.put("http://www.w3.org/2001/XMLSchema#float", FLOAT);
        toReturn.put("http://www.w3.org/2001/XMLSchema#double", DOUBLE);
        toReturn.put("http://www.w3.org/2002/07/owl#real", REAL);
        toReturn.put("http://www.w3.org/2002/07/owl#rational", RATIONAL);
        toReturn.put("http://www.w3.org/2001/XMLSchema#decimal", DECIMAL);
        toReturn.put("http://www.w3.org/2001/XMLSchema#boolean", BOOLEAN);
        toReturn.put("http://www.w3.org/2001/XMLSchema#dateTime", DATETIME);
        toReturn.put("http://www.w3.org/2001/XMLSchema#date", DATETIME);
        toReturn.put("http://www.w3.org/2001/XMLSchema#unsignedLong", INT);
        toReturn.put("http://www.w3.org/2001/XMLSchema#long", INT);
        return toReturn;
    }

    static {
        regularFloat = Pattern.compile(pattern);
        fraction = Pattern.compile(fractionPattern);
        datatypeMap = Datatypes.buildDatatypeMap();
    }
}

