/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel.datatype;

import java.math.BigDecimal;
import uk.ac.manchester.cs.jfact.kernel.datatype.DatatypeRepresentation;
import uk.ac.manchester.cs.jfact.kernel.datatype.Datatypes;

class DecimalRep
implements DatatypeRepresentation<BigDecimal> {
    protected BigDecimal value;

    @Override
    public Datatypes getDatatype() {
        return Datatypes.DECIMAL;
    }

    public DecimalRep(BigDecimal v) {
        this.value = v;
    }

    @Override
    public int compareTo(DatatypeRepresentation<BigDecimal> o) {
        return this.value.compareTo(o.getValue());
    }

    @Override
    public BigDecimal getValue() {
        return this.value;
    }

    @Override
    public boolean correctMin(boolean excl) {
        if (excl) {
            this.value = this.value.add(BigDecimal.ONE);
            return false;
        }
        return excl;
    }

    @Override
    public boolean correctMax(boolean excl) {
        if (excl) {
            this.value = this.value.subtract(BigDecimal.ONE);
            return false;
        }
        return excl;
    }

    @Override
    public boolean lesser(DatatypeRepresentation<BigDecimal> other) {
        return this.compareTo(other) < 0;
    }

    public String toString() {
        return " " + this.value.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj.getClass().equals(DecimalRep.class)) {
            return this.value.equals(((DecimalRep)obj).getValue());
        }
        return false;
    }

    public final int hashCode() {
        return this.value.hashCode();
    }
}

