/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel.datatype;

import java.math.BigInteger;
import uk.ac.manchester.cs.jfact.kernel.datatype.DatatypeRepresentation;
import uk.ac.manchester.cs.jfact.kernel.datatype.Datatypes;

class IntegerRep
implements DatatypeRepresentation<BigInteger> {
    protected BigInteger value;

    @Override
    public Datatypes getDatatype() {
        return Datatypes.INTEGER;
    }

    @Override
    public int compareTo(DatatypeRepresentation<BigInteger> val) {
        return this.value.compareTo(val.getValue());
    }

    public IntegerRep(BigInteger d) {
        this.value = d;
    }

    public IntegerRep(String d) {
        this(IntegerRep.parse(d));
    }

    private static BigInteger parse(String s) {
        int i = s.indexOf(47);
        if (i == -1) {
            throw new IllegalArgumentException("invalid string used: no '/' character separating longs: " + s);
        }
        return new BigInteger(s);
    }

    @Override
    public BigInteger getValue() {
        return this.value;
    }

    @Override
    public boolean correctMin(boolean excl) {
        return excl;
    }

    @Override
    public boolean correctMax(boolean excl) {
        return excl;
    }

    @Override
    public boolean lesser(DatatypeRepresentation<BigInteger> other) {
        return this.compareTo(other) < 0;
    }

    public String toString() {
        return " " + this.value.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof IntegerRep) {
            return this.value.equals(((IntegerRep)obj).getValue());
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

