/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel.datatype;

import java.math.BigDecimal;
import uk.ac.manchester.cs.jfact.kernel.datatype.DatatypeRepresentation;
import uk.ac.manchester.cs.jfact.kernel.datatype.Datatypes;

class RationalRep
implements DatatypeRepresentation<BigDecimal> {
    protected BigDecimal value;

    @Override
    public Datatypes getDatatype() {
        return Datatypes.RATIONAL;
    }

    @Override
    public int compareTo(DatatypeRepresentation<BigDecimal> val) {
        return this.value.compareTo(val.getValue());
    }

    public RationalRep(BigDecimal d) {
        this.value = d;
    }

    public RationalRep(String d) {
        this(RationalRep.parse(d));
    }

    private static BigDecimal parse(String s) {
        int i = s.indexOf(47);
        if (i == -1) {
            throw new IllegalArgumentException("invalid string used: no '/' character separating longs: " + s);
        }
        double n = Long.parseLong(s.substring(0, i));
        double d = Long.parseLong(s.substring(i + 1));
        BigDecimal b = new BigDecimal(n / d);
        return b;
    }

    @Override
    public BigDecimal getValue() {
        return this.value;
    }

    @Override
    public boolean correctMin(boolean excl) {
        return excl;
    }

    @Override
    public boolean correctMax(boolean excl) {
        return excl;
    }

    @Override
    public boolean lesser(DatatypeRepresentation<BigDecimal> other) {
        return this.compareTo(other) < 0;
    }

    public String toString() {
        return " " + this.value.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof RationalRep) {
            return this.value.equals(((RationalRep)obj).getValue());
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

