/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel.datatype;

import uk.ac.manchester.cs.jfact.kernel.datatype.DatatypeRepresentation;
import uk.ac.manchester.cs.jfact.kernel.datatype.Datatypes;

class UnsignedByteRep
implements DatatypeRepresentation<Byte> {
    protected Byte value;

    @Override
    public Datatypes getDatatype() {
        return Datatypes.UNSIGNEDBYTE;
    }

    public UnsignedByteRep(Byte v) {
        if (v < 0) {
            throw new IllegalArgumentException("v cannot be negative! v: " + v);
        }
        this.value = v;
    }

    @Override
    public int compareTo(DatatypeRepresentation<Byte> o) {
        return this.value.compareTo(o.getValue());
    }

    @Override
    public Byte getValue() {
        return this.value;
    }

    @Override
    public boolean correctMin(boolean excl) {
        if (excl) {
            Byte by = this.value;
            Byte by2 = this.value = Byte.valueOf((byte)(this.value + 1));
            return false;
        }
        return excl;
    }

    @Override
    public boolean correctMax(boolean excl) {
        if (excl) {
            Byte by = this.value;
            Byte by2 = this.value = Byte.valueOf((byte)(this.value - 1));
            return false;
        }
        return excl;
    }

    @Override
    public boolean lesser(DatatypeRepresentation<Byte> other) {
        return this.compareTo(other) < 0;
    }

    public String toString() {
        return " " + this.value.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof UnsignedByteRep) {
            return this.value.equals(((UnsignedByteRep)obj).getValue());
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

