/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel.datatype;

import uk.ac.manchester.cs.jfact.kernel.datatype.DatatypeRepresentation;
import uk.ac.manchester.cs.jfact.kernel.datatype.Datatypes;

class UnsignedShortRep
implements DatatypeRepresentation<Short> {
    protected Short value;

    @Override
    public Datatypes getDatatype() {
        return Datatypes.SHORT;
    }

    public UnsignedShortRep(Short v) {
        if (v < 0) {
            throw new IllegalArgumentException("v cannot be negative! v: " + v);
        }
        this.value = v;
    }

    @Override
    public int compareTo(DatatypeRepresentation<Short> o) {
        return this.value.compareTo(o.getValue());
    }

    @Override
    public Short getValue() {
        return this.value;
    }

    @Override
    public boolean correctMin(boolean excl) {
        if (excl) {
            Short s = this.value;
            Short s2 = this.value = Short.valueOf((short)(this.value + 1));
            return false;
        }
        return excl;
    }

    @Override
    public boolean correctMax(boolean excl) {
        if (excl) {
            Short s = this.value;
            Short s2 = this.value = Short.valueOf((short)(this.value - 1));
            return false;
        }
        return excl;
    }

    @Override
    public boolean lesser(DatatypeRepresentation<Short> other) {
        return this.compareTo(other) < 0;
    }

    public String toString() {
        return " " + this.value.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (obj instanceof UnsignedShortRep) {
            return this.value.equals(((UnsignedShortRep)obj).getValue());
        }
        return false;
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

