/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel.modelcaches;

import uk.ac.manchester.cs.jfact.helpers.LeveLogger;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheInterface;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheState;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheType;

public final class ModelCacheConst
extends ModelCacheInterface {
    private final boolean isTop;

    public ModelCacheConst(boolean top) {
        super(false);
        this.isTop = top;
    }

    @Override
    public ModelCacheState getState() {
        return this.isTop ? ModelCacheState.csValid : ModelCacheState.csInvalid;
    }

    public boolean getConst() {
        return this.isTop;
    }

    @Override
    public ModelCacheState canMerge(ModelCacheInterface p) {
        if (p.getCacheType() == ModelCacheType.mctConst) {
            return this.isTop && ((ModelCacheConst)p).isTop ? ModelCacheState.csValid : ModelCacheState.csInvalid;
        }
        return p.canMerge(this);
    }

    @Override
    public ModelCacheType getCacheType() {
        return ModelCacheType.mctConst;
    }

    @Override
    public void logCacheEntry(int level) {
        LeveLogger.logger.print(LeveLogger.Templates.LOGCACHEENTRY, this.isTop ? "TOP" : "BOTTOM");
    }

    public static ModelCacheConst createConstCache(int bp) {
        assert (bp == 1 || bp == -1);
        return new ModelCacheConst(bp == 1);
    }
}

