/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel.modelcaches;

import java.util.BitSet;
import java.util.List;
import uk.ac.manchester.cs.jfact.helpers.DLVertex;
import uk.ac.manchester.cs.jfact.helpers.FastSet;
import uk.ac.manchester.cs.jfact.helpers.FastSetFactory;
import uk.ac.manchester.cs.jfact.helpers.LeveLogger;
import uk.ac.manchester.cs.jfact.helpers.UnreachableSituationException;
import uk.ac.manchester.cs.jfact.kernel.ClassifiableEntry;
import uk.ac.manchester.cs.jfact.kernel.ConceptWDep;
import uk.ac.manchester.cs.jfact.kernel.DLDag;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTree;
import uk.ac.manchester.cs.jfact.kernel.DlCompletionTreeArc;
import uk.ac.manchester.cs.jfact.kernel.RAStateTransitions;
import uk.ac.manchester.cs.jfact.kernel.RATransition;
import uk.ac.manchester.cs.jfact.kernel.Role;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheInterface;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheSingleton;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheState;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheType;

public final class ModelCacheIan
extends ModelCacheInterface {
    public final BitSet posDConcepts = new BitSet();
    public final BitSet posNConcepts = new BitSet();
    public final BitSet negDConcepts = new BitSet();
    public final BitSet negNConcepts = new BitSet();
    public final FastSet extraDConcepts = FastSetFactory.create();
    public final FastSet extraNConcepts = FastSetFactory.create();
    public final FastSet existsRoles = FastSetFactory.create();
    public final FastSet forallRoles = FastSetFactory.create();
    public final FastSet funcRoles = FastSetFactory.create();
    public ModelCacheState curState;
    public final int nC;
    public final int nR;

    private void processLabelInterval(DLDag DLHeap, List<ConceptWDep> start) {
        for (int i = 0; i < start.size(); ++i) {
            ConceptWDep p = start.get(i);
            int bp = p.getConcept();
            this.processConcept(DLHeap.get(bp), bp > 0, p.getDep().isEmpty());
        }
    }

    private void initCacheByLabel(DLDag DLHeap, DlCompletionTree pCT) {
        this.processLabelInterval(DLHeap, pCT.beginl_sc());
        this.processLabelInterval(DLHeap, pCT.beginl_cc());
    }

    public ModelCacheIan(DLDag heap, DlCompletionTree p, boolean flagNominals, int nC, int nR) {
        super(flagNominals);
        this.initCacheByLabel(heap, p);
        this.initRolesFromArcs(p);
        this.nC = nC;
        this.nR = nR;
    }

    public ModelCacheIan(boolean flagNominals, int nC, int nR) {
        super(flagNominals);
        this.curState = ModelCacheState.csValid;
        this.nC = nC;
        this.nR = nR;
    }

    @Override
    public ModelCacheState getState() {
        return this.curState;
    }

    private BitSet getDConcepts(boolean pos) {
        return pos ? this.posDConcepts : this.negDConcepts;
    }

    private BitSet getNConcepts(boolean pos) {
        return pos ? this.posNConcepts : this.negNConcepts;
    }

    private FastSet getExtra(boolean det) {
        return det ? this.extraDConcepts : this.extraNConcepts;
    }

    public void initRolesFromArcs(DlCompletionTree pCT) {
        List<DlCompletionTreeArc> list = pCT.getNeighbour();
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i).isIBlocked()) continue;
            this.addExistsRole(list.get(i).getRole());
        }
        this.curState = ModelCacheState.csValid;
    }

    @Override
    public ModelCacheType getCacheType() {
        return ModelCacheType.mctIan;
    }

    @Override
    public boolean shallowCache() {
        return this.existsRoles.isEmpty();
    }

    public void clear() {
        this.posDConcepts.clear();
        this.posNConcepts.clear();
        this.negDConcepts.clear();
        this.negNConcepts.clear();
        this.existsRoles.clear();
        this.forallRoles.clear();
        this.funcRoles.clear();
        this.curState = ModelCacheState.csValid;
    }

    public void processConcept(DLVertex cur, boolean pos, boolean det) {
        switch (cur.getType()) {
            case dtTop: 
            case dtDataType: 
            case dtDataValue: 
            case dtDataExpr: {
                throw new UnreachableSituationException(cur.toString() + " Top datatype property, datatype, data value or data expression used in an unexpected position");
            }
            case dtNConcept: 
            case dtPConcept: 
            case dtNSingleton: 
            case dtPSingleton: {
                int toAdd = ((ClassifiableEntry)cur.getConcept()).index();
                (det ? this.getDConcepts(pos) : this.getNConcepts(pos)).set(toAdd);
                break;
            }
            case dtIrr: 
            case dtForall: 
            case dtLE: {
                if (cur.getRole().isTop()) {
                    (pos ? this.forallRoles : this.existsRoles).completeSet(this.nR);
                    break;
                }
                if (!pos) break;
                if (cur.getRole().isSimple()) {
                    this.forallRoles.add(cur.getRole().index());
                    break;
                }
                this.processAutomaton(cur);
                break;
            }
        }
    }

    public void processAutomaton(DLVertex cur) {
        RAStateTransitions RST = cur.getRole().getAutomaton().getBase().get(cur.getState());
        List<RATransition> begin = RST.begin();
        for (int i = 0; i < begin.size(); ++i) {
            for (Role r : begin.get(i).begin()) {
                this.forallRoles.add(r.index());
            }
        }
    }

    private void addRoleToCache(Role R) {
        this.existsRoles.add(R.index());
        if (R.isTopFunc()) {
            this.funcRoles.add(R.index());
        }
    }

    private void addExistsRole(Role R) {
        this.addRoleToCache(R);
        List<Role> list = R.getAncestor();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            this.addRoleToCache(list.get(i));
        }
    }

    @Override
    public ModelCacheState canMerge(ModelCacheInterface p) {
        if (this.hasNominalClash(p)) {
            return ModelCacheState.csFailed;
        }
        if (p.getState() != ModelCacheState.csValid || this.curState != ModelCacheState.csValid) {
            return this.mergeStatus(p.getState(), this.curState);
        }
        switch (p.getCacheType()) {
            case mctConst: {
                return ModelCacheState.csValid;
            }
            case mctSingleton: {
                int Singleton = ((ModelCacheSingleton)p).getValue();
                return this.isMergableSingleton(Math.abs(Singleton), Singleton > 0);
            }
            case mctIan: {
                return this.isMergableIan((ModelCacheIan)p);
            }
        }
        return ModelCacheState.csUnknown;
    }

    public ModelCacheState isMergableSingleton(int Singleton, boolean pos) {
        assert (Singleton != 0);
        if (this.getDConcepts(!pos).get(Singleton)) {
            return ModelCacheState.csInvalid;
        }
        if (this.getNConcepts(!pos).get(Singleton)) {
            return ModelCacheState.csFailed;
        }
        return ModelCacheState.csValid;
    }

    public ModelCacheState isMergableIan(ModelCacheIan q) {
        if (this.posDConcepts.intersects(q.negDConcepts) || q.posDConcepts.intersects(this.negDConcepts)) {
            return ModelCacheState.csInvalid;
        }
        if (this.existsRoles.intersect(q.forallRoles) || q.existsRoles.intersect(this.forallRoles) || this.funcRoles.intersect(q.funcRoles) || this.posDConcepts.intersects(q.negNConcepts) || this.posNConcepts.intersects(q.negDConcepts) || this.posNConcepts.intersects(q.negNConcepts) || q.posDConcepts.intersects(this.negNConcepts) || q.posNConcepts.intersects(this.negDConcepts) || q.posNConcepts.intersects(this.negNConcepts)) {
            return ModelCacheState.csFailed;
        }
        return ModelCacheState.csValid;
    }

    public ModelCacheState merge(ModelCacheInterface p) {
        assert (p != null);
        if (this.hasNominalClash(p)) {
            this.curState = ModelCacheState.csFailed;
            return this.curState;
        }
        switch (p.getCacheType()) {
            case mctConst: {
                this.curState = this.mergeStatus(this.curState, p.getState());
                break;
            }
            case mctSingleton: {
                int Singleton = ((ModelCacheSingleton)p).getValue();
                this.mergeSingleton(Math.abs(Singleton), Singleton > 0);
                break;
            }
            case mctIan: {
                this.mergeIan((ModelCacheIan)p);
                break;
            }
            default: {
                throw new UnreachableSituationException();
            }
        }
        this.updateNominalStatus(p);
        return this.curState;
    }

    private void mergeSingleton(int Singleton, boolean pos) {
        ModelCacheState newState = this.isMergableSingleton(Singleton, pos);
        if (newState != ModelCacheState.csValid) {
            this.curState = this.mergeStatus(this.curState, newState);
        } else {
            this.getDConcepts(pos).set(Singleton);
        }
    }

    private void mergeIan(ModelCacheIan p) {
        this.curState = this.isMergableIan(p);
        this.posDConcepts.or(p.posDConcepts);
        this.posNConcepts.or(p.posNConcepts);
        this.negDConcepts.or(p.negDConcepts);
        this.negNConcepts.or(p.negNConcepts);
        this.existsRoles.addAll(p.existsRoles);
        this.forallRoles.addAll(p.forallRoles);
        this.funcRoles.addAll(p.funcRoles);
    }

    @Override
    public void logCacheEntry(int level) {
        LeveLogger.logger.print("\nIan cache: posDConcepts = ");
        this.logCacheSet(this.posDConcepts.toString());
        LeveLogger.logger.print(", posNConcepts = ");
        this.logCacheSet(this.posNConcepts.toString());
        LeveLogger.logger.print(", negDConcepts = ");
        this.logCacheSet(this.negDConcepts.toString());
        LeveLogger.logger.print(", negNConcepts = ");
        this.logCacheSet(this.negNConcepts.toString());
        LeveLogger.logger.print(", existsRoles = ");
        this.logCacheSet(this.existsRoles.toString());
        LeveLogger.logger.print(", forallRoles = ");
        this.logCacheSet(this.forallRoles.toString());
        LeveLogger.logger.print(", funcRoles = ");
        this.logCacheSet(this.funcRoles.toString());
    }

    private void logCacheSet(String s) {
        LeveLogger.logger.print("{");
        LeveLogger.logger.print(s);
        LeveLogger.logger.print("}");
    }

    private ModelCacheState mergeStatus(ModelCacheState s1, ModelCacheState s2) {
        if (s1 == ModelCacheState.csInvalid || s2 == ModelCacheState.csInvalid) {
            return ModelCacheState.csInvalid;
        }
        if (s1 == ModelCacheState.csFailed || s2 == ModelCacheState.csFailed) {
            return ModelCacheState.csFailed;
        }
        if (s1 == ModelCacheState.csUnknown || s2 == ModelCacheState.csUnknown) {
            return ModelCacheState.csUnknown;
        }
        return ModelCacheState.csValid;
    }
}

