/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.kernel.modelcaches;

import uk.ac.manchester.cs.jfact.helpers.LeveLogger;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheInterface;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheState;
import uk.ac.manchester.cs.jfact.kernel.modelcaches.ModelCacheType;

public final class ModelCacheSingleton
extends ModelCacheInterface {
    private final int singleton;

    public ModelCacheSingleton(int bp) {
        super(false);
        this.singleton = bp;
    }

    @Override
    public ModelCacheState getState() {
        return ModelCacheState.csValid;
    }

    public int getValue() {
        return this.singleton;
    }

    @Override
    public ModelCacheState canMerge(ModelCacheInterface p) {
        switch (p.getCacheType()) {
            case mctConst: {
                return p.getState();
            }
            case mctSingleton: {
                return ((ModelCacheSingleton)p).singleton == -this.singleton ? ModelCacheState.csInvalid : ModelCacheState.csValid;
            }
            case mctIan: {
                return p.canMerge(this);
            }
        }
        return ModelCacheState.csUnknown;
    }

    @Override
    public ModelCacheType getCacheType() {
        return ModelCacheType.mctSingleton;
    }

    @Override
    public void logCacheEntry(int level) {
        LeveLogger.logger.print("\nSingleton cache: element ");
        LeveLogger.logger.print(this.singleton);
    }
}

