/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.split;

import java.util.List;
import uk.ac.manchester.cs.jfact.kernel.Ontology;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomConceptInclusion;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDRoleDomain;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDRoleFunctional;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDRoleRange;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDRoleSubsumption;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDeclaration;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDifferentIndividuals;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDisjointConcepts;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDisjointDRoles;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDisjointORoles;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomDisjointUnion;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomEquivalentConcepts;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomEquivalentDRoles;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomEquivalentORoles;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomFairnessConstraint;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomInstanceOf;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomORoleDomain;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomORoleFunctional;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomORoleRange;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomORoleSubsumption;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRelatedTo;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRelatedToNot;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleAsymmetric;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleInverse;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleInverseFunctional;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleIrreflexive;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleReflexive;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleSymmetric;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomRoleTransitive;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomSameIndividuals;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomValueOf;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomValueOfNot;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.Axiom;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ConceptExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.DataRoleExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.Expression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ObjectRoleExpression;
import uk.ac.manchester.cs.jfact.split.BotEquivalenceEvaluator;
import uk.ac.manchester.cs.jfact.split.SigAccessor;
import uk.ac.manchester.cs.jfact.split.TSignature;
import uk.ac.manchester.cs.jfact.split.TopEquivalenceEvaluator;
import uk.ac.manchester.cs.jfact.visitors.DLAxiomVisitor;

class SyntacticLocalityChecker
extends SigAccessor
implements DLAxiomVisitor {
    TopEquivalenceEvaluator TopEval;
    BotEquivalenceEvaluator BotEval;
    boolean isLocal;

    boolean isTopEquivalent(Expression expr) {
        return this.TopEval.isTopEquivalent(expr);
    }

    boolean isBotEquivalent(Expression expr) {
        return this.BotEval.isBotEquivalent(expr);
    }

    boolean isREquivalent(Expression expr) {
        return this.sig.topRLocal() ? this.isTopEquivalent(expr) : this.isBotEquivalent(expr);
    }

    SyntacticLocalityChecker(TSignature s) {
        super(s);
        this.TopEval = new TopEquivalenceEvaluator(s);
        this.BotEval = new BotEquivalenceEvaluator(s);
        this.TopEval.setBotEval(this.BotEval);
        this.BotEval.setTopEval(this.TopEval);
    }

    boolean local(Axiom axiom) {
        axiom.accept(this);
        return this.isLocal;
    }

    @Override
    public void visitOntology(Ontology ontology) {
        for (Axiom p : ontology.begin()) {
            if (!p.isUsed()) continue;
            p.accept(this);
        }
    }

    @Override
    public void visit(AxiomDeclaration axiom) {
        this.isLocal = true;
    }

    @Override
    public void visit(AxiomEquivalentConcepts axiom) {
        if (axiom.size() == 1) {
            this.isLocal = true;
            return;
        }
        this.isLocal = false;
        List<ConceptExpression> args = axiom.getArguments();
        if (args.size() > 0) {
            if (this.isBotEquivalent(args.get(0))) {
                for (int i = 1; i < args.size(); ++i) {
                    if (this.isBotEquivalent(args.get(i))) continue;
                    return;
                }
            } else {
                if (!this.isTopEquivalent(args.get(0))) {
                    return;
                }
                for (int i = 1; i < args.size(); ++i) {
                    if (this.isTopEquivalent(args.get(i))) continue;
                    return;
                }
            }
        }
        this.isLocal = true;
    }

    @Override
    public void visit(AxiomDisjointConcepts axiom) {
        boolean hasNBE = false;
        this.isLocal = true;
        for (ConceptExpression p : axiom.getArguments()) {
            if (this.isBotEquivalent(p)) continue;
            if (hasNBE) {
                this.isLocal = false;
                break;
            }
            hasNBE = true;
        }
    }

    @Override
    public void visit(AxiomDisjointUnion axiom) {
        this.isLocal = false;
        boolean topLoc = this.sig.topCLocal();
        if (!(!topLoc ? this.isBotEquivalent(axiom.getC()) : this.isTopEquivalent(axiom.getC()))) {
            return;
        }
        boolean topEqDesc = false;
        for (ConceptExpression p : axiom.getArguments()) {
            if (this.isBotEquivalent(p)) continue;
            if (!topLoc) {
                return;
            }
            if (this.isTopEquivalent(p)) {
                if (topEqDesc) {
                    return;
                }
                topEqDesc = true;
                continue;
            }
            return;
        }
        this.isLocal = true;
    }

    @Override
    public void visit(AxiomEquivalentORoles axiom) {
        this.isLocal = true;
        if (axiom.size() <= 1) {
            return;
        }
        for (ObjectRoleExpression p : axiom.getArguments()) {
            if (this.isREquivalent(p)) continue;
            this.isLocal = false;
            break;
        }
    }

    @Override
    public void visit(AxiomEquivalentDRoles axiom) {
        this.isLocal = true;
        if (axiom.size() <= 1) {
            return;
        }
        for (DataRoleExpression p : axiom.getArguments()) {
            if (this.isREquivalent(p)) continue;
            this.isLocal = false;
            break;
        }
    }

    @Override
    public void visit(AxiomDisjointORoles axiom) {
        this.isLocal = false;
        if (this.sig.topRLocal()) {
            return;
        }
        boolean hasNBE = false;
        for (ObjectRoleExpression p : axiom.getArguments()) {
            if (this.isREquivalent(p)) continue;
            if (hasNBE) {
                return;
            }
            hasNBE = true;
        }
        this.isLocal = true;
    }

    @Override
    public void visit(AxiomDisjointDRoles axiom) {
        this.isLocal = false;
        if (this.sig.topRLocal()) {
            return;
        }
        boolean hasNBE = false;
        for (DataRoleExpression p : axiom.getArguments()) {
            if (this.isREquivalent(p)) continue;
            if (hasNBE) {
                return;
            }
            hasNBE = true;
        }
        this.isLocal = true;
    }

    @Override
    public void visit(AxiomSameIndividuals axiom) {
        this.isLocal = true;
    }

    @Override
    public void visit(AxiomDifferentIndividuals axiom) {
        this.isLocal = true;
    }

    @Override
    public void visit(AxiomFairnessConstraint axiom) {
        this.isLocal = true;
    }

    @Override
    public void visit(AxiomRoleInverse axiom) {
        this.isLocal = this.isREquivalent(axiom.getRole()) && this.isREquivalent(axiom.getInvRole());
    }

    @Override
    public void visit(AxiomORoleSubsumption axiom) {
        this.isLocal = this.isREquivalent(this.sig.topRLocal() ? axiom.getRole() : axiom.getSubRole());
    }

    @Override
    public void visit(AxiomDRoleSubsumption axiom) {
        this.isLocal = this.isREquivalent(this.sig.topRLocal() ? axiom.getRole() : axiom.getSubRole());
    }

    @Override
    public void visit(AxiomORoleDomain axiom) {
        this.isLocal = this.isTopEquivalent(axiom.getDomain());
        if (!this.sig.topRLocal()) {
            this.isLocal |= this.isBotEquivalent(axiom.getRole());
        }
    }

    @Override
    public void visit(AxiomDRoleDomain axiom) {
        this.isLocal = this.isTopEquivalent(axiom.getDomain());
        if (!this.sig.topRLocal()) {
            this.isLocal |= this.isBotEquivalent(axiom.getRole());
        }
    }

    @Override
    public void visit(AxiomORoleRange axiom) {
        this.isLocal = this.isTopEquivalent(axiom.getRange());
        if (!this.sig.topRLocal()) {
            this.isLocal |= this.isBotEquivalent(axiom.getRole());
        }
    }

    @Override
    public void visit(AxiomDRoleRange axiom) {
        this.isLocal = SyntacticLocalityChecker.isTopDT(axiom.getRange());
        if (!this.sig.topRLocal()) {
            this.isLocal |= this.isBotEquivalent(axiom.getRole());
        }
    }

    @Override
    public void visit(AxiomRoleTransitive axiom) {
        this.isLocal = this.isREquivalent(axiom.getRole());
    }

    @Override
    public void visit(AxiomRoleReflexive axiom) {
        this.isLocal = this.isREquivalent(axiom.getRole());
    }

    @Override
    public void visit(AxiomRoleIrreflexive axiom) {
        this.isLocal = !this.sig.topRLocal();
    }

    @Override
    public void visit(AxiomRoleSymmetric axiom) {
        this.isLocal = this.isREquivalent(axiom.getRole());
    }

    @Override
    public void visit(AxiomRoleAsymmetric axiom) {
        this.isLocal = !this.sig.topRLocal();
    }

    @Override
    public void visit(AxiomORoleFunctional axiom) {
        this.isLocal = !this.sig.topRLocal() && this.isBotEquivalent(axiom.getRole());
    }

    @Override
    public void visit(AxiomDRoleFunctional axiom) {
        this.isLocal = !this.sig.topRLocal() && this.isBotEquivalent(axiom.getRole());
    }

    @Override
    public void visit(AxiomRoleInverseFunctional axiom) {
        this.isLocal = !this.sig.topRLocal() && this.isBotEquivalent(axiom.getRole());
    }

    @Override
    public void visit(AxiomConceptInclusion axiom) {
        this.isLocal = this.isBotEquivalent(axiom.getSubConcept()) || this.isTopEquivalent(axiom.getSupConcept());
    }

    @Override
    public void visit(AxiomInstanceOf axiom) {
        this.isLocal = this.isTopEquivalent(axiom.getC());
    }

    @Override
    public void visit(AxiomRelatedTo axiom) {
        this.isLocal = this.sig.topRLocal() && this.isTopEquivalent(axiom.getRelation());
    }

    @Override
    public void visit(AxiomRelatedToNot axiom) {
        this.isLocal = !this.sig.topRLocal() && this.isBotEquivalent(axiom.getRelation());
    }

    @Override
    public void visit(AxiomValueOf axiom) {
        this.isLocal = this.sig.topRLocal() && this.isTopEquivalent(axiom.getAttribute());
    }

    @Override
    public void visit(AxiomValueOfNot axiom) {
        this.isLocal = !this.sig.topRLocal() && this.isBotEquivalent(axiom.getAttribute());
    }
}

