/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.split;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import uk.ac.manchester.cs.jfact.kernel.Ontology;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptName;
import uk.ac.manchester.cs.jfact.kernel.dl.ConceptTop;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomConceptInclusion;
import uk.ac.manchester.cs.jfact.kernel.dl.axioms.AxiomEquivalentConcepts;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.Axiom;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.ConceptExpression;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.Expression;
import uk.ac.manchester.cs.jfact.split.ModuleType;
import uk.ac.manchester.cs.jfact.split.TModularizer;
import uk.ac.manchester.cs.jfact.split.TSignature;
import uk.ac.manchester.cs.jfact.split.TSignatureUpdater;
import uk.ac.manchester.cs.jfact.split.TSplitVar;

public class TAxiomSplitter {
    protected final Set<ConceptName> SubNames = new HashSet<ConceptName>();
    protected final Set<ConceptName> Rejects = new HashSet<ConceptName>();
    protected final List<TRecord> Renames = new ArrayList<TRecord>();
    protected final List<TRecord> R2 = new ArrayList<TRecord>();
    protected final Map<ConceptName, TRecord> ImpRens = new HashMap<ConceptName, TRecord>();
    protected final Map<ConceptName, Set<AxiomConceptInclusion>> ImplNames = new HashMap<ConceptName, Set<AxiomConceptInclusion>>();
    private int newNameId = 0;
    protected final TModularizer mod = new TModularizer();
    protected final TSignature sig = new TSignature();
    protected final TSignatureUpdater Updater;
    protected final Set<TSplitVar> RejSplits = new HashSet<TSplitVar>();
    protected final Ontology O;

    protected ConceptName rename(ConceptName oldName) {
        ConceptExpression c = this.O.getExpressionManager().concept(oldName.getName() + "+" + ++this.newNameId);
        if (c instanceof ConceptName) {
            return (ConceptName)c;
        }
        return null;
    }

    protected void buildSig(TRecord rec) {
        this.sig.clear();
        rec.newAxiom.accept(this.Updater);
        this.mod.extract(this.O, this.sig, ModuleType.M_STAR, rec.Module);
        rec.newAxSig = this.mod.getSignature();
    }

    protected void addSingleCI(AxiomConceptInclusion ci) {
        if (ci != null && !(ci.getSupConcept() instanceof ConceptTop) && ci.getSubConcept() instanceof ConceptName) {
            ConceptName name = (ConceptName)ci.getSubConcept();
            this.SubNames.add(name);
            if (!this.ImplNames.containsKey(name)) {
                this.ImplNames.put(name, new HashSet());
            }
            this.ImplNames.get(name).add(ci);
        }
    }

    protected void registerCIs() {
        for (Axiom p : this.O.begin()) {
            if (!p.isUsed() || !(p instanceof AxiomConceptInclusion)) continue;
            this.addSingleCI((AxiomConceptInclusion)p);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ConceptName getEqSplit(AxiomEquivalentConcepts ce) {
        ConceptName splitName = null;
        ConceptName name = null;
        int size = ce.size();
        for (ConceptExpression q : ce.getArguments()) {
            if (q instanceof ConceptName) {
                name = (ConceptName)q;
                continue;
            }
            name = null;
        }
        if (name != null) {
            if (this.SubNames.contains(name)) {
                if (splitName != null) return splitName;
                splitName = name;
            } else {
                --size;
            }
        }
        if (size <= 1) return null;
        ConceptName conceptName = splitName;
        return conceptName;
    }

    protected void makeEqSplit(AxiomEquivalentConcepts ce) {
        if (ce == null) {
            return;
        }
        ConceptName splitName = this.getEqSplit(ce);
        if (splitName == null) {
            return;
        }
        TRecord rec = new TRecord();
        rec.oldName = splitName;
        rec.newName = this.rename(splitName);
        rec.setEqAx(ce);
        rec.Register(this.O);
        this.Renames.add(rec);
    }

    protected void registerEQ() {
        for (int i = 0; i < this.O.size(); ++i) {
            if (!this.O.get(i).isUsed() || !(this.O.get(i) instanceof AxiomEquivalentConcepts)) continue;
            this.makeEqSplit((AxiomEquivalentConcepts)this.O.get(i));
        }
    }

    protected TRecord makeImpSplit(ConceptName oldName) {
        ConceptName newName = this.rename(oldName);
        TRecord rec = new TRecord();
        rec.oldName = oldName;
        rec.newName = newName;
        ArrayList<Expression> args = new ArrayList<Expression>();
        for (AxiomConceptInclusion s : this.ImplNames.get(oldName)) {
            rec.oldAxioms.add(s);
            args.add(s.getSupConcept());
        }
        rec.setImpAx(this.O.getExpressionManager().and(args));
        rec.Register(this.O);
        return rec;
    }

    protected TRecord getImpRec(ConceptName oldName) {
        if (!this.ImpRens.containsKey(oldName)) {
            this.ImpRens.put(oldName, this.makeImpSplit(oldName));
        }
        return this.ImpRens.get(oldName);
    }

    protected void createAllImplications() {
        for (TRecord r : this.Renames) {
            this.getImpRec(r.oldName);
        }
    }

    protected void clearModules() {
        for (Map.Entry<ConceptName, TRecord> p : this.ImpRens.entrySet()) {
            p.getValue().newAxSig.clear();
        }
        for (TRecord r : this.Renames) {
            r.newAxSig.clear();
        }
    }

    protected boolean checkSplitCorrectness(TRecord rec) {
        if (this.Rejects.contains(rec.oldName)) {
            rec.Unregister();
            return true;
        }
        TRecord imp = this.getImpRec(rec.oldName);
        if (imp.newAxSig.size() == 0) {
            this.buildSig(imp);
        }
        this.buildSig(rec);
        if (rec.newAxSig.containsNamedEntity(rec.oldName) || !rec.newAxSig.intersect(imp.newAxSig).isEmpty()) {
            this.Rejects.add(rec.oldName);
            imp.Unregister();
            rec.Unregister();
            return true;
        }
        this.R2.add(rec);
        return false;
    }

    protected void keepIndependentSplits() {
        boolean change;
        int oSize = this.Renames.size();
        do {
            change = false;
            System.out.print("Check correctness...\n");
            this.clearModules();
            for (TRecord r : this.Renames) {
                change |= this.checkSplitCorrectness(r);
            }
            this.Renames.clear();
            this.Renames.addAll(this.R2);
            this.R2.clear();
        } while (change);
        System.out.print("There were made " + this.Renames.size() + " splits out of " + oSize + " tries\n");
    }

    protected TSplitVar splitImplicationsFor(ConceptName oldName) {
        if (this.O.Splits.hasCN(oldName)) {
            return this.O.Splits.get(oldName);
        }
        TRecord rec = this.getImpRec(oldName);
        TSplitVar split = new TSplitVar();
        split.oldName = oldName;
        split.addEntry(rec.newName, rec.newAxSig, rec.Module);
        this.O.Splits.set(oldName, split);
        return split;
    }

    protected void splitImplications() {
        for (TRecord r : this.Renames) {
            if (!this.Rejects.contains(r.oldName)) {
                TSplitVar split = this.splitImplicationsFor(r.oldName);
                split.addEntry(r.newName, r.newAxSig, r.Module);
                continue;
            }
            r.Unregister();
        }
    }

    public TAxiomSplitter(Ontology o) {
        this.Updater = new TSignatureUpdater(this.sig);
        this.O = o;
    }

    public void buildSplit() {
        this.registerCIs();
        this.registerEQ();
        if (this.Renames.size() == 0) {
            return;
        }
        this.createAllImplications();
        this.keepIndependentSplits();
        this.splitImplications();
    }

    protected class TRecord {
        ConceptName oldName;
        ConceptName newName;
        final List<Axiom> oldAxioms = new ArrayList<Axiom>();
        Axiom newAxiom;
        TSignature newAxSig;
        final Set<Axiom> Module = new HashSet<Axiom>();

        protected TRecord() {
        }

        void setEqAx(AxiomEquivalentConcepts ax) {
            this.oldAxioms.add(ax);
            ArrayList<Expression> copy = new ArrayList<Expression>();
            for (ConceptExpression p : ax.getArguments()) {
                if (p.equals(this.oldName)) {
                    copy.add(this.newName);
                    continue;
                }
                copy.add(p);
            }
            this.newAxiom = new AxiomEquivalentConcepts(copy);
        }

        void setImpAx(ConceptExpression Desc) {
            this.newAxiom = new AxiomConceptInclusion(this.newName, Desc);
        }

        void Register(Ontology ontology) {
            for (Axiom p : this.oldAxioms) {
                ontology.retract(p);
            }
            ontology.add(this.newAxiom);
        }

        void Unregister() {
            for (Axiom p : this.oldAxioms) {
                p.setUsed(true);
            }
            this.newAxiom.setUsed(false);
        }
    }
}

