/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.jfact.split;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import uk.ac.manchester.cs.jfact.kernel.Ontology;
import uk.ac.manchester.cs.jfact.kernel.dl.interfaces.Axiom;
import uk.ac.manchester.cs.jfact.split.ModuleType;
import uk.ac.manchester.cs.jfact.split.SyntacticLocalityChecker;
import uk.ac.manchester.cs.jfact.split.TSignature;
import uk.ac.manchester.cs.jfact.split.TSignatureUpdater;

public class TModularizer {
    TSignature sig = new TSignature();
    SyntacticLocalityChecker Checker;
    TSignatureUpdater Updater;
    List<Axiom> Module = new ArrayList<Axiom>();

    void addAxiomToModule(Axiom axiom) {
        axiom.setInModule(true);
        this.Module.add(axiom);
        axiom.accept(this.Updater);
    }

    void extractModule(Collection<Axiom> args) {
        int sigSize;
        this.Module.clear();
        for (Axiom p : args) {
            p.setInModule(false);
        }
        do {
            sigSize = this.sig.size();
            for (Axiom p : args) {
                if (p.isInModule() || !p.isUsed() || this.Checker.local(p)) continue;
                this.addAxiomToModule(p);
            }
        } while (sigSize != this.sig.size());
    }

    public TModularizer() {
        this.Checker = new SyntacticLocalityChecker(this.sig);
        this.Updater = new TSignatureUpdater(this.sig);
    }

    void extract(Collection<Axiom> begin, TSignature signature, ModuleType type) {
        int size;
        boolean topLocality = type == ModuleType.M_TOP;
        this.sig = signature;
        this.sig.setLocality(topLocality);
        this.extractModule(begin);
        if (type != ModuleType.M_STAR) {
            return;
        }
        ArrayList<Axiom> oldModule = new ArrayList<Axiom>();
        do {
            size = this.Module.size();
            oldModule.clear();
            oldModule.addAll(this.Module);
            topLocality = !topLocality;
            this.sig = signature;
            this.sig.setLocality(topLocality);
            this.extractModule(oldModule);
        } while (size != this.Module.size());
    }

    public void extract(Collection<Axiom> begin, TSignature signature, ModuleType type, Set<Axiom> Set2) {
        this.extract(begin, signature, type);
        Set2.clear();
        Set2.addAll(this.Module);
    }

    public void extract(Ontology O, TSignature signature, ModuleType type) {
        this.extract(O.begin(), signature, type);
    }

    public void extract(Ontology O, TSignature signature, ModuleType type, Set<Axiom> Set2) {
        this.extract(O.begin(), signature, type, Set2);
    }

    public TSignature getSignature() {
        return this.sig;
    }
}

