/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.component.cd.impl;

import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easycommons.research.util.esb.QueryParam;
import com.ebmwebsourcing.easyesb.component.cd.api.CDComponentBehaviour;
import com.ebmwebsourcing.easyesb.component.cd.api.CDProviderEndpointBehaviour;
import com.ebmwebsourcing.easyesb.component.cd.impl.CoordinationDelegatePrimitives;
import com.ebmwebsourcing.easyesb.component.cd.impl.JBITripletAddress;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.exchange10.api.type.RoleType;
import com.ebmwebsourcing.easyesb.soa.api.component.Component;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.AbstractEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.soa10.api.type.EndpointType;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import java.net.URI;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.petalslink.abslayer.service.api.BindingOperation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CDProviderEndpointBehaviourImpl
extends AbstractEndpointBehaviourImpl
implements CDProviderEndpointBehaviour {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(CDProviderEndpointBehaviourImpl.class.getName());
    private static Integer currentIndReceiver = 0;

    public CDProviderEndpointBehaviourImpl(Endpoint<? extends EndpointType> arg0) {
        super(arg0);
    }

    public void execute(Exchange exchange) throws TransportException {
        assert (this.getBinding() != null);
        try {
            boolean found = false;
            for (BindingOperation bop : this.getBinding().getOperations()) {
                if (!bop.inferQName().equals(QName.valueOf(exchange.getOperation()))) continue;
                found = true;
                break;
            }
            if (found) {
                String destinationEndpoint = ESBUtil.analyzeURI((URI)exchange.getDestinationReference()).getEndpointname();
                QName destinationService = exchange.getServiceName();
                QName destinationInterface = exchange.getInterfaceName();
                JBITripletAddress key = new JBITripletAddress(destinationInterface, destinationService, destinationEndpoint);
                ProviderEndpoint pe = (ProviderEndpoint)this.endpoint;
                org.objectweb.fractal.api.Component component = pe.getServiceProvider().getComponent();
                QName componentName = new QName(this.getEndpoint().getNode().getQName().getNamespaceURI(), "CDEngine");
                EndpointAddress ea = new EndpointAddress(componentName, null, new QueryParam[0]);
                URI uri = ESBUtil.generateURI((EndpointAddress)ea);
                System.out.println("URI of searched component : " + uri);
                System.out.println("References : ");
                for (Component c : ((NodeBehaviour)((ProviderEndpoint)this.endpoint).getNode().findBehaviour(NodeBehaviour.class)).getComponents()) {
                    System.out.println("ref : " + c.getReference());
                }
                Component cd = ((NodeBehaviour)((ProviderEndpoint)this.endpoint).getNode().findBehaviour(NodeBehaviour.class)).getComponent(uri);
                CoordinationDelegatePrimitives primitives = ((CDComponentBehaviour)cd.findBehaviour(CDComponentBehaviour.class)).getPrimitives();
                JBITripletAddress value = primitives.getCdToServiceMap().get(key);
                if (value != null) {
                    Exchange newExchange = ((ClientEndpoint)this.endpoint).createExchange();
                    MessageUtil.getInstance().createInMessageStructure(newExchange);
                    newExchange.setDestinationReference(ESBUtil.generateURI((EndpointAddress)new EndpointAddress(value.service, value.endpoint, new QueryParam[0])));
                    newExchange.setServiceName(value.service);
                    newExchange.setInterfaceName(value.interf);
                    newExchange.setOperation(exchange.getOperation());
                    newExchange.setPattern(exchange.getPattern());
                    newExchange.setRole(RoleType.CONSUMER);
                    newExchange.setSourceReference(exchange.getSourceReference());
                    newExchange.setStatus(exchange.getStatus());
                    newExchange.setUuid(newExchange.getUuid() + "CD");
                    newExchange.getMessageIn().getBody().setPayload(exchange.getMessageIn().getBody().getPayload());
                    primitives.unblock(exchange, newExchange, (ClientEndpoint)this.endpoint);
                    exchange.getMessageIn().getHeader().addProperty(MessageUtil.getInstance().createHeaderProperty(MessageUtil.EXCHANGE_ACCEPTED_BY_PROVIDER_PROPERTY, "true"));
                } else {
                    MessageUtil.getInstance().createErrorMessageStructure(exchange);
                    Document errorDom = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                    Element error = errorDom.createElement("error");
                    error.setTextContent("This exchange was not accepted by the CD component.");
                    errorDom.appendChild(error);
                    exchange.getMessageError().getBody().setPayload(errorDom);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new TransportException((Throwable)e);
        }
    }
}

