/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easyesb.component.cd.impl;

import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easycommons.research.util.esb.QueryParam;
import com.ebmwebsourcing.easyesb.component.cd.impl.JBITripletAddress;
import com.ebmwebsourcing.easyesb.exchange10.api.ExchangeException;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.exchange10.api.type.PatternType;
import com.ebmwebsourcing.easyesb.exchange10.api.type.RoleType;
import com.ebmwebsourcing.easyesb.exchange10.api.type.StatusType;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import it.univaq.di.choreos.coordinationprotocol.algorithm.CoordinationChannelManager;
import it.univaq.di.choreos.coordinationprotocol.algorithm.model.AdditionalMessage;
import java.net.URI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EasyESBCoordinationChannelManagerImpl
implements CoordinationChannelManager {
    private ClientEndpoint endpoint;

    public EasyESBCoordinationChannelManagerImpl(ClientEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    private void sendMessage(JBITripletAddress value, String operation, PatternType pattern, URI sourceRef, StatusType status, Document payload) throws ExchangeException, TransportException {
        Exchange newExchange = this.endpoint.createExchange();
        MessageUtil.getInstance().createInMessageStructure(newExchange);
        newExchange.setDestinationReference(ESBUtil.generateURI((EndpointAddress)new EndpointAddress(value.service, value.endpoint, new QueryParam[0])));
        newExchange.setServiceName(value.service);
        newExchange.setInterfaceName(value.interf);
        newExchange.setOperation(operation);
        newExchange.setPattern(pattern);
        newExchange.setRole(RoleType.CONSUMER);
        newExchange.setSourceReference(sourceRef);
        newExchange.setStatus(status);
        newExchange.setUuid(String.valueOf(newExchange.getUuid()) + operation);
        newExchange.getMessageIn().getBody().setPayload(payload);
        if (newExchange.getPattern().equals((Object)PatternType.IN_OUT)) {
            this.endpoint.sendSync(newExchange, 0L);
        } else {
            this.endpoint.send(newExchange);
        }
    }

    public void sendAck(AdditionalMessage mess) {
        try {
            String choreId = mess.getChoreographyID();
            String cdEndpointName = mess.getCoordinatedServiceEndpointName();
            String from = mess.getCoordinationDelegateFrom();
            String to = mess.getCoordinationDelegateTo();
            String request = mess.getRequest();
            String state = mess.getState();
            int timestamp = mess.getTimestamp();
            JBITripletAddress value = new JBITripletAddress();
            String operation = "";
            PatternType pattern = PatternType.IN_ONLY;
            URI sourceRef = URI.create(from);
            StatusType status = StatusType.ACTIVE;
            Document payload = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
            Element test = payload.createElement("test");
            payload.adoptNode(test);
            this.sendMessage(value, operation, pattern, sourceRef, status, payload);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendBlock(AdditionalMessage arg0) {
    }

    public void sendUnBlock(AdditionalMessage arg0) {
    }
}

