/*
 * Decompiled with CFR 0.152.
 */
package eu.play_project.play_eventadapter;

import com.ebmwebsourcing.easycommons.xml.XMLHelper;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.api.implementor.WsrfbfModelFactory;
import com.ebmwebsourcing.wsstar.basefaults.datatypes.impl.impl.WsrfbfModelFactoryImpl;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.implementor.WsnbModelFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl.WsnbModelFactoryImpl;
import com.ebmwebsourcing.wsstar.resource.datatypes.api.implementor.WsrfrModelFactory;
import com.ebmwebsourcing.wsstar.resource.datatypes.impl.impl.WsrfrModelFactoryImpl;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.api.implementor.WsrfrlModelFactory;
import com.ebmwebsourcing.wsstar.resourcelifetime.datatypes.impl.impl.WsrfrlModelFactoryImpl;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.api.implementor.WsrfrpModelFactory;
import com.ebmwebsourcing.wsstar.resourceproperties.datatypes.impl.impl.WsrfrpModelFactoryImpl;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.WstopConstants;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.implementor.WstopModelFactory;
import com.ebmwebsourcing.wsstar.topics.datatypes.impl.impl.WstopModelFactoryImpl;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import eu.play_project.play_commons.constants.Constants;
import eu.play_project.play_commons.eventtypes.EventHelpers;
import java.io.IOException;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.event_processing.events.types.Event;
import org.ontoware.rdf2go.model.Model;
import org.petalslink.dsb.notification.client.http.HTTPNotificationConsumerClient;
import org.petalslink.dsb.notification.commons.NotificationHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class AbstractSender {
    private String dsbNotify = Constants.getProperties().getProperty("dsb.notify.endpoint");
    private Logger logger = Logger.getAnonymousLogger();
    private QName defaultTopic;
    private String producerAddress = "http://localhost:9998/foo/" + AbstractSender.class.getSimpleName();
    private String endpointAddress = "http://localhost:9998/foo/Endpoint";
    private Boolean online = true;

    public AbstractSender(QName defaultTopic) {
        this.defaultTopic = defaultTopic;
    }

    public void notify(Event event) {
        this.notify(event, this.defaultTopic);
    }

    public void notify(Event event, QName topicUsed) {
        this.notify(event.getModel(), topicUsed);
    }

    public void notify(Model model) {
        this.notify(model, this.defaultTopic);
    }

    public void notify(Model model, QName topicUsed) {
        Element element = EventHelpers.serializeAsDom((Model)model);
        try {
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            doc.appendChild(doc.adoptNode(element.cloneNode(true)));
            this.notify(doc, topicUsed);
        }
        catch (ParserConfigurationException e) {
            this.logger.log(Level.SEVERE, "No event was notified because of: ", e);
        }
    }

    public void notify(String notifPayload) {
        this.notify(notifPayload, this.defaultTopic);
    }

    public void notify(String notifPayload, QName topicUsed) {
        try {
            Document notifPayloadDoc = XMLHelper.createDocumentFromString((String)notifPayload);
            this.notify(notifPayloadDoc, topicUsed);
        }
        catch (SAXException e) {
            this.logger.log(Level.SEVERE, "No event was notified because of: ", e);
        }
        catch (IOException e) {
            this.logger.log(Level.SEVERE, "No event was notified because of: ", e);
        }
    }

    public void notify(Document notifPayload) {
        this.notify(notifPayload, this.defaultTopic);
    }

    public void notify(Document notifPayload, QName topicUsed) {
        String uuid = UUID.randomUUID().toString();
        String dialect = WstopConstants.CONCRETE_TOPIC_EXPRESSION_DIALECT_URI.toString();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            Notify notify = NotificationHelper.createNotification((String)this.producerAddress, (String)this.endpointAddress, (String)uuid, (QName)topicUsed, (String)dialect, (Document)notifPayload);
            Document dom = Wsnb4ServUtils.getWsnbWriter().writeNotifyAsDOM(notify);
            HTTPNotificationConsumerClient consumerClient = new HTTPNotificationConsumerClient(this.dsbNotify);
            if (this.online.booleanValue()) {
                consumerClient.notify(notify);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "No event was notified because of: ", e);
        }
    }

    public void setDsbNotify(String dsbNotify) {
        this.dsbNotify = dsbNotify;
    }

    public String getDsbNotify() {
        return this.dsbNotify;
    }

    public void setDefaultTopic(QName defaultTopic) {
        if (defaultTopic == null) {
            throw new NullPointerException("defaultTopic may not be null");
        }
        this.defaultTopic = defaultTopic;
    }

    public String getProducerAddress() {
        return this.producerAddress;
    }

    public void setProducerAddress(String producerAddress) {
        this.producerAddress = producerAddress;
    }

    public String getEndpointAddress() {
        return this.endpointAddress;
    }

    public void setEndpointAddress(String endpointAddress) {
        this.endpointAddress = endpointAddress;
    }

    public void setNoNetworking(Boolean offline) {
        this.online = offline == false;
    }

    static {
        Wsnb4ServUtils.initModelFactories((WsrfbfModelFactory)new WsrfbfModelFactoryImpl(), (WsrfrModelFactory)new WsrfrModelFactoryImpl(), (WsrfrlModelFactory)new WsrfrlModelFactoryImpl(), (WsrfrpModelFactory)new WsrfrpModelFactoryImpl(), (WstopModelFactory)new WstopModelFactoryImpl(), (WsnbModelFactory)new WsnbModelFactoryImpl());
    }
}

