/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.viper.behaviour.notification.impl;

import java.net.URL;
import java.util.logging.Logger;

import org.jdom.input.DOMBuilder;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;
import org.w3c.dom.Document;

import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPHandler;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.constant.EasyESBFramework;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.soa.api.component.Component;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.soa.impl.component.ComponentBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.ComponentType;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easyesb.viper.behaviour.notification.api.BPELComponentNotificationBehaviour;
import com.ebmwebsourcing.easyviper.core.api.Core;
import com.ebmwebsourcing.easyviper.core.api.CoreException;
import com.ebmwebsourcing.easyviper.core.api.engine.Engine;
import com.ebmwebsourcing.easyviper.extended.service.notification.api.ExtendedServiceNotification;
import com.ebmwebsourcing.easyviper.extended.service.notification.impl.ExtendedServiceNotificationImpl;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.GetCurrentMessage;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.GetCurrentMessageResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Renew;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.RenewResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.SubscribeResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Unsubscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.UnsubscribeResponse;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.wsrfbf.services.faults.AbsWSStarFault;


public class ViperComponentNotificationBehaviourImpl extends ComponentBehaviourImpl implements BPELComponentNotificationBehaviour {

    /**
     * 
     */
    private static final long serialVersionUID = 1L;

    private static Logger log = Logger.getLogger(ViperComponentNotificationBehaviourImpl.class.getName());

    private ExtendedServiceNotification notification = null;

    //	private static com.ebmwebsourcing.easyviper.extended.service.administration.impl.ObjectFactory admfactory = null;

    static {
        try {

            // ADD ADMIN JAXB FACTORY
            SOAJAXBContext.getInstance().addOtherObjectFactory(com.ebmwebsourcing.easyviper.administration.ObjectFactory.class);
            //SOAJAXBContext.getInstance().addOtherObjectFactory(com.ebmwebsourcing.wsstar.jaxb.notification.base.ObjectFactory.class);
            //admfactory = new com.ebmwebsourcing.easyviper.extended.service.administration.impl.ObjectFactory();

        } catch (SOAException e) {
            e.printStackTrace();
        }
    }

    public ViperComponentNotificationBehaviourImpl(Component<? extends ComponentType> ep) {
        super(ep);
        try {
            URL url = Thread.currentThread().getContextClassLoader().getResource(BPELComponentNotificationBehaviour.DESCRIPTION_URL);
            Description desc = (Description) Factory.getInstance().wrap(SOAUtil.getInstance().getReader(EasyESBFramework.getInstance()).get().readDocument(url, Definitions.class));
            this.setBinding(desc.getBindings().iterator().next());

            Engine engine = ((Core)((Component)getEndpoint()).getContext()).getEngine();
            notification = new ExtendedServiceNotificationImpl(engine);
        } catch (XmlObjectReadException e) {
            e.printStackTrace();
            throw new RuntimeException();
        } catch (CoreException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }



    public void execute(Exchange exchange) throws TransportException {

        try {
            if(exchange.getMessageIn().getBody().getPayload() == null) {
                throw new TransportException("the message in cannot be null");
            }

            // convert dom to jdom
            Document docDom = exchange.getMessageIn().getBody().getPayload();
            DOMBuilder builder = new DOMBuilder();
            org.jdom.Document doc = builder.build(exchange.getMessageIn().getBody().getPayload());

            if(doc.getRootElement() != null){
                String opName = doc.getRootElement().getName();
                log.finest("invoked operation : "+opName);
                if(opName.equals("Subscribe")){
                    Subscribe subscribe;
                    try {
                        subscribe = RefinedWsnbFactory.getInstance().getWsnbReader().readSubscribe(docDom);
                        SubscribeResponse res = this.subscribe(subscribe);
                        Document subscribeResponseAsDom = RefinedWsnbFactory.getInstance().getWsnbWriter().writeSubscribeResponseAsDOM(res);


                        MessageUtil.getInstance().createOutMessageStructure(exchange);
                        exchange.getMessageOut().getBody().setPayload(subscribeResponseAsDom);

                    } catch (WsnbException e) {
                        try {
                            Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e);

                            Document faultSoap = SOAPHandler.createSoapFault(docEx);
                            MessageUtil.getInstance().createErrorMessageStructure(exchange);
                            exchange.getMessageError().getBody().setPayload(faultSoap);
                            log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
                        } catch (SOAException ex) {
                            throw new TransportException(ex);
                        } catch (SOAPException ex) {
                            throw new TransportException(ex);
                        }
                    }catch (AbsWSStarFault e) {
                        try {
                            Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e);

                            Document faultSoap = SOAPHandler.createSoapFault(docEx);
                            MessageUtil.getInstance().createErrorMessageStructure(exchange);
                            exchange.getMessageError().getBody().setPayload(faultSoap);
                            log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
                        } catch (SOAException ex) {
                            throw new TransportException(ex);
                        } catch (SOAPException ex) {
                            throw new TransportException(ex);
                        }
                    } 
                }else if(opName.equals("UnSubscribe")){
                    try {
                        Unsubscribe unsubscribe = RefinedWsnbFactory.getInstance().getWsnbReader().readUnsubscribe(docDom);
                        UnsubscribeResponse unsubscriberes = this.unsubscribe(unsubscribe);
                        Document res = RefinedWsnbFactory.getInstance().getWsnbWriter().writeUnsubscribeResponseAsDOM(unsubscriberes);
                        MessageUtil.getInstance().createOutMessageStructure(exchange);
                        exchange.getMessageOut().getBody().setPayload(res);


                    } catch (WsnbException e) {
                        try {
                            Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e);

                            Document faultSoap = SOAPHandler.createSoapFault(docEx);
                            MessageUtil.getInstance().createErrorMessageStructure(exchange);
                            exchange.getMessageError().getBody().setPayload(faultSoap);
                            log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
                        } catch (SOAException ex) {
                            throw new TransportException(ex);
                        } catch (SOAPException ex) {
                            throw new TransportException(ex);
                        }
                    }catch (AbsWSStarFault e) {
                        try {
                            Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e);

                            Document faultSoap = SOAPHandler.createSoapFault(docEx);
                            MessageUtil.getInstance().createErrorMessageStructure(exchange);
                            exchange.getMessageError().getBody().setPayload(faultSoap);
                            log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
                        } catch (SOAException ex) {
                            throw new TransportException(ex);
                        } catch (SOAPException ex) {
                            throw new TransportException(ex);
                        }
                    } 
                    
                }
            }
        }catch (TransportException e) {
            e.printStackTrace();

        }
    }



    @Override
    public SubscribeResponse subscribe(Subscribe request) throws WsnbException, AbsWSStarFault {
        return this.notification.subscribe(request);
    }



    @Override
    public GetCurrentMessageResponse getCurrentMessage(GetCurrentMessage request)
    throws WsnbException, AbsWSStarFault {
        return this.notification.getCurrentMessage(request);
    }



    @Override
    public RenewResponse renew(Renew request) throws WsnbException, AbsWSStarFault {
        return this.notification.renew(request);
    }



    @Override
    public UnsubscribeResponse unsubscribe(Unsubscribe request) throws WsnbException,
    AbsWSStarFault {
        return this.notification.unsubscribe(request);
    }




}

