/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easierbsm;

import java.util.logging.Logger;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easierbsm.sla.manager.AgreementManagerComponentCreationFactory;
import com.ebmwebsourcing.easierbsm.sla.manager.api.AgreementManagerComponent;
import com.ebmwebsourcing.easierbsm.sla.manager.api.AgreementManagerComponentBehaviour;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.WSDMComponentCreationFactory;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMMonitoringEngine;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMMonitoringEngineBehaviour;
import com.ebmwebsourcing.easyesb.esb.api.ESBFactory;
import com.ebmwebsourcing.easyesb.esb.impl.ESBFactoryImpl;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.endpoint.AdminEndpoint;
import com.ebmwebsourcing.easyesb.technical.service.admin.impl.AdminServiceCreationFactory;
import com.ebmwebsourcing.easyesb.technical.service.admin.impl.BSMAdminServiceCreationFactory;

import easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg;

public class BSMFactoryImpl extends ESBFactoryImpl implements
ESBFactory {

	private static Logger log = Logger
			.getLogger(BSMFactoryImpl.class.getName());

	
	public BSMFactoryImpl(String... factoryToExclude) {
		super(factoryToExclude);
	}


	@Override
	public Node createNode(QName name,
			Configuration conf) throws ESBException {

		final Node node = super.createNode(name, conf);


		try {
			// connect wsdm manager to data collector
			WSDMMonitoringEngine wsdmMonitoringEngine = (WSDMMonitoringEngine) ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).getComponent(WSDMComponentCreationFactory.WSDM_MONITORING_COMPONENT_NAME);
			((WSDMMonitoringEngineBehaviour)wsdmMonitoringEngine.findBehaviour(WSDMMonitoringEngineBehaviour.class)).connectToDataCollector();

			// connect sla manager to data collector
			AgreementManagerComponent slaManagerComponent = (AgreementManagerComponent) ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).getComponent(new QName(AgreementManagerComponentCreationFactory.SLA_NAMESPACE, AgreementManagerComponentCreationFactory.SLA_MANAGER_COMPONENT_NAME));
			((AgreementManagerComponentBehaviour)slaManagerComponent.findBehaviour(AgreementManagerComponentBehaviour.class)).connectToDataCollector();


			// Get and Expose Admin service
			BSMAdminServiceCreationFactory adminFactory = (BSMAdminServiceCreationFactory) this.servicesFactory.get("bsm-admin-service-factory");
			adminFactory.exposeAdminService(node);
		} catch (AdminExceptionMsg e) {
			throw new ESBException(e);
		} catch (easierbsm.petalslink.com.service.slamanager._1_0.AdminExceptionMsg e) {
			throw new ESBException(e);
		}

		return node;
	}

	
	@Override
	public AdminEndpoint<?> getAdminEndpoint() {
		if(this.adminEndpoint == null) {
			AdminServiceCreationFactory adminFactory = (AdminServiceCreationFactory) this.servicesFactory.get("bsm-admin-service-factory");
			this.adminEndpoint = adminFactory.getAdminEndpoint();
		}
		return this.adminEndpoint;
	}
	
}
