/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easierbsm.datacollector.impl;

import java.net.URL;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;

import com.ebmwebsourcing.easierbsm.contant.EasierBSMFramework;
import com.ebmwebsourcing.easierbsm.datacollector.ESBDataCollectorFactoryImpl;
import com.ebmwebsourcing.easierbsm.datacollector.api.DataCollectorEngine;
import com.ebmwebsourcing.easierbsm.datacollector.api.DataCollectorEngineBehaviour;
import com.ebmwebsourcing.easierbsm.datacollector.api.DispatcherProviderEndpointBehaviour;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.AbstractEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.NotificationConsumerEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WSNHelper;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;

import easyevent.petalslink.com.service.proxyeventmanager.admin._1_0.AdminProxyEventManager;


public class DispatcherProviderEndpointBehaviourImpl extends AbstractEndpointBehaviourImpl implements
DispatcherProviderEndpointBehaviour {
	
	private static final String SLA_MANAGER_COMPONENT_NAME = "SLAManager";
	private static final String SLA_MANAGER_ENDPOINT_NAME = "slaManagerEndpoint";
	private static final String SLA_MANAGER_SERVICE_NAME = "slaManagerService";
	private static final String SLA_NAMESPACE = "http://petals.ow2.org";
	
	private static final String WSDM_MONITORING_SUFFIXE = "_WSDMMonitoring";


	private static Logger log = Logger
	.getLogger(DispatcherProviderEndpointBehaviourImpl.class.getName());

	private AdminProxyEventManager pem = null;

	public DispatcherProviderEndpointBehaviourImpl(final ProviderEndpoint ep) throws ESBException {
		super(ep);
		try {
			URL url = Thread.currentThread().getContextClassLoader().getResource(NotificationConsumerEndpointBehaviour.DESCRIPTION_URL);
			Description desc = (Description) Factory.getInstance().wrap(SOAUtil.getInstance().getReader(EasierBSMFramework.getInstance()).get().readDocument(url, Definitions.class));
			this.setBinding(desc.getBindings().iterator().next());
			
			
			DataCollectorEngine dataCollectorEngine = (DataCollectorEngine) ((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).getComponent(new QName(ESBDataCollectorFactoryImpl.DATA_COLLECTOR_NAMESPACE, ESBDataCollectorFactoryImpl.DATA_COLLECTOR_COMPONENT_NAME));
			
			// connect
			this.pem = ((DataCollectorEngineBehaviour)dataCollectorEngine.findBehaviour(DataCollectorEngineBehaviour.class)).getProxyEventManager();
			if(this.pem == null) {
				throw new ESBException("Proxy event manager cannot be null!!!");
			}
			
		} catch (XmlObjectReadException e) {
			throw new ESBException(e);
		} 
	}



	public void execute(final Exchange exchange) throws TransportException  {
		try {
			log.info("DispatcherProviderEndpointBehaviourImpl BEHAVIOUR FOUND: " + exchange.getOperation());
			if (QName.valueOf(exchange.getOperation()).getLocalPart()
					.equals("Notify")) {

				log.info("NOTIFY");

				System.out.println("NOTIFY IN BASE ADMIN:" + XMLPrettyPrinter.prettyPrint(exchange.getMessageIn().getBody().getPayload()));
				Notify notify =  Wsnb4ServUtils.getWsnbReader().readNotify(exchange.getMessageIn().getBody().getPayload());
				this.notify(notify);

			} 
		} catch (final Exception e) {
			log.severe("ERROR IN DATA COLLECTOR PROVIDER ENDPOINT BEHAVIOUR: " + e.getMessage());
			throw new TransportException(e);
		}  
	}


	@Override
	public void notify(Notify notify) throws WsnbException {
		System.out.println("TROP LA CLASSE!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!");
		System.out.println("Dispatcher Notify: \n" + XMLPrettyPrinter.prettyPrint(Wsnb4ServUtils.getWsnbWriter().writeNotifyAsDOM(notify)));
		this.pem.notify(WSNHelper.convert2JaxbElement(notify));
		
	}


}
