/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
/**
 * MonitoringEngine-Core - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.easierbsm.datacollector.impl;

import java.util.logging.Logger;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;

import com.ebmwebsourcing.easierbsm.contant.EasierBSMFramework;
import com.ebmwebsourcing.easierbsm.datacollector.Constants;
import com.ebmwebsourcing.easierbsm.datacollector.api.DataCollectorException;
import com.ebmwebsourcing.easierbsm.datacollector.api.DispatcherProviderEndpoint;
import com.ebmwebsourcing.easierbsm.datacollector.api.DispatcherService;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.service.ServiceBehaviour;
import com.ebmwebsourcing.easyesb.soa.impl.service.TechnicalServiceImpl;
import com.ebmwebsourcing.easyesb.soa10.api.element.EndpointInitialContext;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@Scope("COMPOSITE")
@Service(value=DispatcherService.class, names="service")
@PolicySets("frascati:scaEasyCompositeWithContent")
public class DispatcherServiceImpl extends TechnicalServiceImpl<com.ebmwebsourcing.easyesb.soa10.api.type.TechnicalServiceType> implements DispatcherService {


	/**
	 *
	 */
	private static final long serialVersionUID = 1L;
	
	private static Logger log = Logger.getLogger(DispatcherServiceImpl.class
			.getName());
	
	
	public DispatcherServiceImpl() throws ESBException {
		super();
	}

	public DispatcherProviderEndpoint createDispatcherProviderEndpoint(
			final String endpointName)
	throws DataCollectorException {
		DispatcherProviderEndpoint dispatcherProviderEndpoint = null;
		try {
			
			dispatcherProviderEndpoint = ((ServiceBehaviour)this.findBehaviour(ServiceBehaviour.class)).createProviderEndpoint(
					endpointName, 
					DispatcherProviderEndpointImpl.class,
					DispatcherProviderEndpointBehaviourImpl.class,
					null);
			
			assert dispatcherProviderEndpoint.getDescription() != null;
			
		} catch (final ESBException e) {
			throw new DataCollectorException(e);
		} catch (final IllegalArgumentException e) {
			throw new DataCollectorException(e);
		} 
		return dispatcherProviderEndpoint;
	}

}
