/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easierbsm.sla.manager;

import java.util.logging.Logger;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easierbsm.datacollector.ESBDataCollectorFactoryImpl;
import com.ebmwebsourcing.easierbsm.sla.manager.api.SLACheckingProviderEndpoint;
import com.ebmwebsourcing.easierbsm.sla.manager.api.SLACheckingService;
import com.ebmwebsourcing.easierbsm.sla.manager.api.SLAException;
import com.ebmwebsourcing.easierbsm.sla.manager.api.SLAManagerComponent;
import com.ebmwebsourcing.easierbsm.sla.manager.impl.SLAManagerComponentBehaviourImpl;
import com.ebmwebsourcing.easierbsm.sla.manager.impl.SLAManagerComponentImpl;
import com.ebmwebsourcing.easyesb.esb.api.ESBFactory;
import com.ebmwebsourcing.easyesb.esb.impl.ESBFactoryImpl;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.endpoint.AdminEndpoint;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.endpoint.behaviour.BaseAdminEndpointBehaviour;

import easyesb.petalslink.com.service.admin._1_0.AdminExceptionMsg;

public class ESBSLAManagerFactoryImpl implements
		ESBFactory {
	
	public static final String SLA_MANAGER_COMPONENT_NAME = "SLAManager";
	public static final String SLA_MANAGER_ENDPOINT_NAME = "slaChekingEndpoint";
	public static final String SLA_MANAGER_SERVICE_NAME = "slaCheckingService";
	public static final String SLA_NAMESPACE = "http://petals.ow2.org";
	
	private static Logger log = Logger
	.getLogger(ESBSLAManagerFactoryImpl.class.getName());

	private ESBFactoryImpl parentFactory = new ESBFactoryImpl();
	
	@Override
	public Node createNode(QName name,
			Configuration conf) throws ESBException {
		
		
		final Node node = parentFactory.createDefaultNode(name, conf);
		
		Endpoint<?> dispatcher = ((RegistryEndpointBehaviour)node.getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoint(new QName(ESBDataCollectorFactoryImpl.DATA_COLLECTOR_NAMESPACE, ESBDataCollectorFactoryImpl.DISPATCHER_PROVIDER_ENDPOINT_NAME));
		if(dispatcher == null) {
			ESBDataCollectorFactoryImpl.createDataCollector(node, this, conf);
		}

		createSLAManager(node, this);
		
		return node;
	}



	public static void createSLAManager(final Node node, final ESBFactory factory) throws ESBException {
		try {
			final SLAManagerComponent slaManager = ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).createComponent(
					new QName(SLA_NAMESPACE, SLA_MANAGER_COMPONENT_NAME), SLAManagerComponentImpl.class);
			slaManager.addBehaviourClass(SLAManagerComponentBehaviourImpl.class);

			// create technical provider sla service
			final QName serviceName = new QName(SLA_NAMESPACE,
					SLA_MANAGER_SERVICE_NAME);
			final String endpointName = SLA_MANAGER_ENDPOINT_NAME;
			final SLACheckingService slaCheckingService = slaManager
					.createSLACheckingService(serviceName);
			final SLACheckingProviderEndpoint slaCheckingProviderEndpoint = slaCheckingService
					.createSLACheckingEndpoint(endpointName);
			
		} catch (final SLAException e) {
			throw new ESBException(e);
		} 
	}

	@Override
	public Configuration getDefaultConfiguration() throws ESBException {
		return parentFactory.getDefaultConfiguration();
	}

	@Override
	public void addSpecificElements(QName arg0, Node arg1, Configuration arg2)
			throws ESBException {
		// do nothing
	}

	@Override
	public AdminEndpoint<?> getAdminEndpoint() {
		return parentFactory.getAdminEndpoint();
	}
}
