/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easierbsm.sla.manager;

import com.ebmwebsourcing.easierbsm.datacollector.ESBDataCollectorFactoryImpl;
import com.ebmwebsourcing.easierbsm.sla.manager.api.SLACheckingProviderEndpoint;
import com.ebmwebsourcing.easierbsm.sla.manager.api.SLACheckingService;
import com.ebmwebsourcing.easierbsm.sla.manager.api.SLAException;
import com.ebmwebsourcing.easierbsm.sla.manager.api.SLAManagerComponent;
import com.ebmwebsourcing.easierbsm.sla.manager.impl.SLAManagerComponentBehaviourImpl;
import com.ebmwebsourcing.easierbsm.sla.manager.impl.SLAManagerComponentImpl;
import com.ebmwebsourcing.easyesb.esb.api.ESBFactory;
import com.ebmwebsourcing.easyesb.esb.impl.ESBFactoryImpl;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.endpoint.AdminEndpoint;
import java.util.logging.Logger;
import javax.xml.namespace.QName;

public class ESBSLAManagerFactoryImpl
implements ESBFactory {
    public static final String SLA_MANAGER_COMPONENT_NAME = "SLAManager";
    public static final String SLA_MANAGER_ENDPOINT_NAME = "slaChekingEndpoint";
    public static final String SLA_MANAGER_SERVICE_NAME = "slaCheckingService";
    public static final String SLA_NAMESPACE = "http://petals.ow2.org";
    private static Logger log = Logger.getLogger(ESBSLAManagerFactoryImpl.class.getName());
    private ESBFactoryImpl parentFactory = new ESBFactoryImpl();

    public Node createNode(QName name, Configuration conf) throws ESBException {
        Node node = this.parentFactory.createDefaultNode(name, conf);
        Endpoint dispatcher = ((RegistryEndpointBehaviour)node.getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoint(new QName(SLA_NAMESPACE, "DispatcherProviderEndpoint"));
        if (dispatcher == null) {
            ESBDataCollectorFactoryImpl.createDataCollector((Node)node, (ESBFactory)this, (Configuration)conf);
        }
        ESBSLAManagerFactoryImpl.createSLAManager(node, this);
        return node;
    }

    public static void createSLAManager(Node node, ESBFactory factory) throws ESBException {
        try {
            SLAManagerComponent slaManager = (SLAManagerComponent)((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).createComponent(new QName(SLA_NAMESPACE, SLA_MANAGER_COMPONENT_NAME), SLAManagerComponentImpl.class);
            slaManager.addBehaviourClass(SLAManagerComponentBehaviourImpl.class);
            QName serviceName = new QName(SLA_NAMESPACE, SLA_MANAGER_SERVICE_NAME);
            String endpointName = SLA_MANAGER_ENDPOINT_NAME;
            SLACheckingService slaCheckingService = slaManager.createSLACheckingService(serviceName);
            SLACheckingProviderEndpoint slaCheckingProviderEndpoint = slaCheckingService.createSLACheckingEndpoint(SLA_MANAGER_ENDPOINT_NAME);
        }
        catch (SLAException e) {
            throw new ESBException((Throwable)e);
        }
    }

    public Configuration getDefaultConfiguration() throws ESBException {
        return this.parentFactory.getDefaultConfiguration();
    }

    public void addSpecificElements(QName arg0, Node arg1, Configuration arg2) throws ESBException {
    }

    public AdminEndpoint<?> getAdminEndpoint() {
        return this.parentFactory.getAdminEndpoint();
    }
}

