/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easyesb.technical.service.admin.impl.endpoint.behaviour;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;
import org.w3c.dom.Document;

import com.ebmwebsourcing.easierbsm.contant.EasierBSMFramework;
import com.ebmwebsourcing.easierbsm.datacollector.DataCollectorComponentCreationFactory;
import com.ebmwebsourcing.easierbsm.datacollector.api.DataCollectorEngine;
import com.ebmwebsourcing.easierbsm.datacollector.api.DataCollectorEngineBehaviour;
import com.ebmwebsourcing.easierbsm.sla.manager.AgreementManagerComponentCreationFactory;
import com.ebmwebsourcing.easierbsm.sla.manager.api.AgreementManagerComponent;
import com.ebmwebsourcing.easierbsm.sla.manager.api.AgreementManagerComponentBehaviour;
import com.ebmwebsourcing.easierbsm.sla.manager.impl.AgreementManagerComponentBehaviourImpl;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.WSDMComponentCreationFactory;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMMonitoringEngine;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMMonitoringEngineBehaviour;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.impl.WSDMMonitoringEngineBehaviourImpl;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPHandler;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.AbstractEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.soa10.api.type.ProviderEndpointType;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.endpoint.AdminEndpoint;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.endpoint.behaviour.BSMAdminEndpointBehaviour;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.endpoint.behaviour.BaseAdminEndpointBehaviour;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;

import easierbsm.petalslink.com.data.bsmadmin._1.ActivateBusinessMonitoring;
import easierbsm.petalslink.com.data.bsmadmin._1.ActivateBusinessMonitoringResponse;
import easierbsm.petalslink.com.data.bsmadmin._1.ActivateBusinessMonitoringType;
import easierbsm.petalslink.com.data.bsmadmin._1.AgreementResponse;
import easierbsm.petalslink.com.data.bsmadmin._1.ConnectToEsb;
import easierbsm.petalslink.com.data.bsmadmin._1.ConnectToEsbResponse;
import easierbsm.petalslink.com.data.bsmadmin._1.GetAllMonitoringEndpoints;
import easierbsm.petalslink.com.data.bsmadmin._1.GetAllMonitoringEndpointsResponse;
import easierbsm.petalslink.com.data.bsmadmin._1.GetConnectedEsbs;
import easierbsm.petalslink.com.data.bsmadmin._1.GetConnectedEsbsResponse;
import easierbsm.petalslink.com.data.bsmadmin._1.GetNodeInformations;
import easierbsm.petalslink.com.data.bsmadmin._1.GetNodeInformationsResponse;
import easierbsm.petalslink.com.data.bsmadmin._1.LoadAgreementFromUrlRequest;
import easierbsm.petalslink.com.data.bsmadmin._1.LoadAgreementRequest;
import easierbsm.petalslink.com.data.bsmadmin._1.LoadAgreementResponse;
import easierbsm.petalslink.com.data.bsmadmin._1.MonitoringEndpointType;
import easierbsm.petalslink.com.data.bsmadmin._1.ObjectFactory;
import easierbsm.petalslink.com.data.bsmadmin._1.OperationListType;
import easierbsm.petalslink.com.data.bsmadmin._1.UnActivateBusinessMonitoring;
import easierbsm.petalslink.com.data.bsmadmin._1.UnActivateBusinessMonitoringResponse;
import easierbsm.petalslink.com.data.bsmadmin._1.UnActivateBusinessMonitoringType;
import easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg;
import easierbsm.petalslink.com.service.datacollector._1_0.ConnectToEsbFault;
import esstar.petalslink.com.service.management._1_0.ManagementException;



public class BSMAdminEndpointBehaviourImpl extends AbstractEndpointBehaviourImpl implements BSMAdminEndpointBehaviour {

	private final Logger log = Logger.getLogger(BSMAdminEndpointBehaviourImpl.class.getName());

	static {
		try {
			SOAJAXBContext.getInstance().addOtherObjectFactory(easierbsm.petalslink.com.data.bsmadmin._1.ObjectFactory.class);
		} catch (SOAException e) {
			// do nothing
			e.printStackTrace();
		}
	}


	private ObjectFactory factory = new ObjectFactory();

	private AgreementManagerComponent slaManager;

	private WSDMMonitoringEngine monitoringEngine;

	private DataCollectorEngine dataCollectorEngine;

	private AdminEndpoint baseAdminEndpoint;


	public BSMAdminEndpointBehaviourImpl(AdminEndpoint<? extends ProviderEndpointType> ep) throws ESBException {
		super(ep);
		try {
			URL url = Thread.currentThread().getContextClassLoader().getResource(WSDM_DESCRIPTION_URL);
			Description desc = (Description) Factory.getInstance().wrap(SOAUtil.getInstance().getReader(EasierBSMFramework.getInstance()).get().readDocument(url, Definitions.class));
			this.setBinding(desc.getBindings().iterator().next());

		} catch (XmlObjectReadException e) {
			e.printStackTrace();
			throw new ESBException(e);
		} 
	}

	public AgreementManagerComponent getSlaManager() throws ESBException {
		if(slaManager == null) {
			URI slaEpr = ESBUtil.generateURI(new EndpointAddress(new QName(this.endpoint.getNode().getQName().getNamespaceURI(), AgreementManagerComponentCreationFactory.SLA_MANAGER_COMPONENT_NAME), null));
			slaManager = (AgreementManagerComponent) ((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).getComponent(slaEpr);
		}
		if(slaManager == null) {
			throw new ESBException("slaManager cannot be null!!!");
		}
		return this.slaManager;
	}



	public DataCollectorEngine getDataCollectorEngine() throws ESBException {
		if(dataCollectorEngine == null) {
			URI dataEpr = ESBUtil.generateURI(new EndpointAddress(new QName(this.endpoint.getNode().getQName().getNamespaceURI(), DataCollectorComponentCreationFactory.DATA_COLLECTOR_COMPONENT_NAME), null));
			dataCollectorEngine = (DataCollectorEngine) ((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).getComponent(dataEpr);
		}
		if(dataCollectorEngine == null) {
			throw new ESBException("dataCollectorEngine cannot be nul!!!");
		}
		return this.dataCollectorEngine;
	}



	public AdminEndpoint getBaseAdminEndpoint() throws ESBException {
		if(baseAdminEndpoint == null) {
			URI epr = ESBUtil.generateURI(new EndpointAddress(new QName(this.getEndpoint().getNode().getQName().getNamespaceURI(), this.getEndpoint().getNode().getQName().getLocalPart() + "_admin"), "adminEndpoint"));
			baseAdminEndpoint = (AdminEndpoint) ((RegistryEndpointBehaviour)this.getEndpoint().getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoint(epr);
		}
		if(baseAdminEndpoint == null) {
			throw new ESBException("baseAdminEndpoint cannot be nul!!!");
		}
		return this.baseAdminEndpoint;
	}



	public WSDMMonitoringEngine getMonitoringEngine() throws ESBException {
		if(monitoringEngine == null) {
			URI wsdmEpr = ESBUtil.generateURI(new EndpointAddress(new QName(this.endpoint.getNode().getQName().getNamespaceURI(), WSDMComponentCreationFactory.WSDM_MONITORING_COMPONENT_NAME), null));
			monitoringEngine = (WSDMMonitoringEngine) ((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).getComponent(wsdmEpr);
		}
		if(monitoringEngine == null) {
			throw new ESBException("monitoringEngine cannot be null!!!");
		}
		return this.monitoringEngine;
	}


	@Override
	public void execute(final Exchange exchange) throws TransportException {
		log.finest("BSM ADMIN BEHAVIOUR FOUND: " + exchange.getOperation());

		try {
			if (QName.valueOf(exchange.getOperation()).getLocalPart()
					.equals("connectToEsb")) {
				this.log.finest("Connect to ESB");


				ConnectToEsb connect = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), ConnectToEsb.class);

				this.connectToEsb(connect.getAddress(), connect.isSynchronize());

				ConnectToEsbResponse connectResponse = new ConnectToEsbResponse();

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(connectResponse);


				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);


			} else if (QName.valueOf(exchange.getOperation()).getLocalPart()
					.equals("getConnectedEsbs")) {
				this.log.finest("getConnectedEsbs");


				GetConnectedEsbs connect = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), GetConnectedEsbs.class);

				List<String> addresses = this.getConnectedEsbs();

				GetConnectedEsbsResponse connectResponse = new GetConnectedEsbsResponse();
				connectResponse.getEsbAddress().addAll(addresses);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(connectResponse);


				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);


			} else if(QName.valueOf(exchange.getOperation()).getLocalPart()
					.equals("getNodeInformations")) {
				log.info("Get Node Informations");

				GetNodeInformations getNodeInformations = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), GetNodeInformations.class);

				GetNodeInformationsResponse getNodeInformationsResponse = this.getNodeInformations(getNodeInformations);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(getNodeInformationsResponse);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);

			} else if (QName.valueOf(exchange.getOperation()).getLocalPart()
					.equals("getAllMonitoringEndpoints")) { 
				this.log.finest("GET ALL MONITORING ENDPOINTS");

				GetAllMonitoringEndpoints getAllMonitoringEndpoints = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), GetAllMonitoringEndpoints.class);


				List<MonitoringEndpointType> res = this.getAllMonitoringEndpoints();

				GetAllMonitoringEndpointsResponse getAllMonitoringEndpointsResponse = factory.createGetAllMonitoringEndpointsResponse();

				for(MonitoringEndpointType mep: res) {
					getAllMonitoringEndpointsResponse.getEndpoint().add(mep);
				}


				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(getAllMonitoringEndpointsResponse);


				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);

			} else if(QName.valueOf(exchange.getOperation()).getLocalPart()
					.equals("activateBusinessMonitoring")) { 


				this.log.finest("Activate Business Monitoring");

				Document activateDom = exchange.getMessageIn().getBody().getPayload();
				ActivateBusinessMonitoring activateIn = SOAJAXBContext.getInstance().marshallAnyType(activateDom, ActivateBusinessMonitoring.class);

				ActivateBusinessMonitoringType activateInType = new ActivateBusinessMonitoringType();
				activateInType.setServiceName(activateIn.getActivateBusinessMonitoring().getServiceName());
				activateInType.setEndpointName(activateIn.getActivateBusinessMonitoring().getEndpointName());
				activateInType.setAllOperations(activateIn.getActivateBusinessMonitoring().getAllOperations());
				activateInType.setFrequency(activateIn.getActivateBusinessMonitoring().getFrequency());

				boolean res = this.activateBusinessMonitoring(activateInType);
				ActivateBusinessMonitoringResponse response = new ActivateBusinessMonitoringResponse();
				response.setActivateBunsinessMonitoringResponseModel(res);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(response);


				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);

			} else if(QName.valueOf(exchange.getOperation()).getLocalPart()
					.equals("unActivateBusinessMonitoring")){
				this.log.finest("Activate Business Monitoring");

				Document unactivateDom = exchange.getMessageIn().getBody().getPayload();
				UnActivateBusinessMonitoring unactivateIn = SOAJAXBContext.getInstance().marshallAnyType(unactivateDom, UnActivateBusinessMonitoring.class);

				//easierbsm.petalslink.com.data.bsmadmin._1.UnActivateBusinessMonitoringType activateIn = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), easierbsm.petalslink.com.data.bsmadmin._1.UnActivateBusinessMonitoringType.class);
				UnActivateBusinessMonitoringType unactivateInType = new UnActivateBusinessMonitoringType();
				unactivateInType.setServiceName(unactivateIn.getUnActivateBusinessMonitoring().getServiceName());
				unactivateInType.setEndpointName(unactivateIn.getUnActivateBusinessMonitoring().getEndpointName());
				unactivateInType.setAllOperations(unactivateIn.getUnActivateBusinessMonitoring().getAllOperations());

				boolean res = this.unActivateBusinessMonitoring(unactivateInType);
				UnActivateBusinessMonitoringResponse response = new UnActivateBusinessMonitoringResponse();
				response.setUnActivateBusinessMonitoringResponse(res);

				Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement(response);


				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(docResp);

			} else if (QName.valueOf(exchange.getOperation()).getLocalPart()
					.equals("loadAgreementFromUrl")) {
				log.finest("LOAD AGREEMENT FROM URL");
				LoadAgreementFromUrlRequest lurl = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), LoadAgreementFromUrlRequest.class);
				LoadAgreementResponse res = this.loadAgreementFromUrl(lurl);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(SOAJAXBContext.getInstance().unmarshallAnyElement(res));

			} else if (QName.valueOf(exchange.getOperation()).getLocalPart()
					.equals("loadAgreementFromDocument")) {

				log.finest("LOAD AGREEMENT FROM DOCUMENT");     
				LoadAgreementRequest lag = SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), LoadAgreementRequest.class);
				LoadAgreementResponse res = this.loadAgreementFromDocument(lag);

				MessageUtil.getInstance().createOutMessageStructure(exchange);
				exchange.getMessageOut().getBody().setPayload(SOAJAXBContext.getInstance().unmarshallAnyElement(res));

			}


			else {
				super.execute(exchange);
			}
		} catch (AdminExceptionMsg e) {
			try {
				Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement(e.getFaultInfo());
				Document fault = SOAPHandler.createSoapFault(docEx);
				exchange.getMessageError().getBody().setPayload(fault);
				log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint(exchange.getMessageError().getBody().getPayload()));
			} catch (SOAException ex) {
				log.severe("ERROR EX: " + ex.getMessage());
				throw new TransportException(ex);
			} catch (SOAPException ex) {
				log.severe("ERROR EX: " + ex.getMessage());
				throw new TransportException(ex);
			}
		} catch (SOAException e) {
			log.severe("ERROR EX: " + e.getMessage());
			throw new TransportException(e);
		} 
	}



	@Override
	public void connectToEsb(String address, Boolean synchronize)
			throws easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg {
		try {
			if(synchronize == null || synchronize == true) {
				((WSDMMonitoringEngineBehaviour)this.getMonitoringEngine().findBehaviour(WSDMMonitoringEngineBehaviour.class)).synchronize(address);
			}
			((DataCollectorEngineBehaviour)this.getDataCollectorEngine().findBehaviour(DataCollectorEngineBehaviour.class)).connectToEsb(address);
			((DataCollectorEngineBehaviour)this.getDataCollectorEngine().findBehaviour(DataCollectorEngineBehaviour.class)).addEsbNode(address);

		} catch (ConnectToEsbFault e) {
			throw new easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg(e.getMessage(), e);
		} catch (easierbsm.petalslink.com.service.datacollector._1_0.AdminExceptionMsg e) {
			throw new easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg(e.getMessage(), e);
		} catch (ESBException e) {
			throw new easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg(e.getMessage(), e);
		} catch (easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg e) {
			throw new easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg(e.getMessage(), e);
		}
	}


	@Override
	public void unconnectToEsb(String address)
			throws easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg {
		throw new easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg("Not Implemented!!!");

	}


	@Override
	public boolean activateBusinessMonitoring(
			easierbsm.petalslink.com.data.bsmadmin._1.ActivateBusinessMonitoringType activateBusinessMonitoring)
					throws easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg {
		try {
			return this.getMonitoringEngine().activateBusinessMonitoring(activateBusinessMonitoring.getServiceName(), activateBusinessMonitoring.getEndpointName(),activateBusinessMonitoring.getOperation());
		} catch (easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg e) {
			throw new easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg(e.getLocalizedMessage());
		} catch (ESBException e) {
			throw new easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg(e.getLocalizedMessage());
		}
	}


	@Override
	public boolean unActivateBusinessMonitoring(
			easierbsm.petalslink.com.data.bsmadmin._1.UnActivateBusinessMonitoringType unActivateBusinessMonitoring)
					throws easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg {
		try {
			return this.getMonitoringEngine().unActivateBusinessMonitoring(unActivateBusinessMonitoring.getServiceName(), unActivateBusinessMonitoring.getEndpointName(), unActivateBusinessMonitoring.getOperation());
		} catch (easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg e) {
			throw new easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg(e.getLocalizedMessage());
		} catch (ESBException e) {
			throw new easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg(e.getLocalizedMessage());
		}
	}


	@Override
	public List<MonitoringEndpointType> getAllMonitoringEndpoints()
			throws easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg {
		List<MonitoringEndpointType> res = new ArrayList<MonitoringEndpointType>();
		try {
			List<easierbsm.petalslink.com.data.wsdmmanager._1.MonitoringEndpointType> mes;
			mes = this.getMonitoringEngine().findBehaviour(WSDMMonitoringEngineBehaviourImpl.class).getAllMonitoringEndpoints();
			for(easierbsm.petalslink.com.data.wsdmmanager._1.MonitoringEndpointType me: mes) {
				MonitoringEndpointType  m = new MonitoringEndpointType();
				m.setAddress(me.getAddress());
				m.setName(me.getName());
				OperationListType o = new OperationListType();
				o.getOperationName().addAll(me.getOperations().getOperationName());
				m.setOperations(o);
				res.add(m);
			}
		} catch (easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg e) {
			throw new easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg(e.getMessage(), e);
		} catch (ESBException e) {
			throw new easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg(e.getMessage(), e);
		}
		return res;
	}



	@Override
	public LoadAgreementResponse loadAgreementFromDocument(
			LoadAgreementRequest parameters) throws AdminExceptionMsg {
		LoadAgreementResponse res = new LoadAgreementResponse();
		try {
			easierbsm.petalslink.com.data.slamanager._1.LoadAgreementRequest request = new easierbsm.petalslink.com.data.slamanager._1.LoadAgreementRequest();
			request.setAgreement(parameters.getAgreement());
			easierbsm.petalslink.com.data.slamanager._1.LoadAgreementResponse response = ((AgreementManagerComponentBehaviour)this.getSlaManager().findBehaviour(AgreementManagerComponentBehaviourImpl.class)).loadAgreementFromDocument(request);
			AgreementResponse agRes = new AgreementResponse();
			agRes.setAgreementName(response.getOut().getAgreementName());
			agRes.setId(response.getOut().getId());
			res.setOut(agRes);
		} catch (easierbsm.petalslink.com.service.slamanager._1_0.AdminExceptionMsg e) {
			throw new easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg(e.getMessage(), e);
		} catch (ESBException e) {
			throw new easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg(e.getMessage(), e);
		}
		return res;
	}


	@Override
	public LoadAgreementResponse loadAgreementFromUrl(
			LoadAgreementFromUrlRequest parameters) throws AdminExceptionMsg {
		LoadAgreementResponse res = new LoadAgreementResponse();
		try {
			easierbsm.petalslink.com.data.slamanager._1.LoadAgreementFromUrlRequest request = new easierbsm.petalslink.com.data.slamanager._1.LoadAgreementFromUrlRequest();
			request.setUrl(parameters.getUrl());
			easierbsm.petalslink.com.data.slamanager._1.LoadAgreementResponse response = ((AgreementManagerComponentBehaviour)this.getSlaManager().findBehaviour(AgreementManagerComponentBehaviourImpl.class)).loadAgreementFromUrl(request);
			AgreementResponse agRes = new AgreementResponse();
			agRes.setAgreementName(response.getOut().getAgreementName());
			agRes.setId(response.getOut().getId());
			res.setOut(agRes);
		} catch (easierbsm.petalslink.com.service.slamanager._1_0.AdminExceptionMsg e) {
			throw new easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg(e.getMessage(), e);
		} catch (ESBException e) {
			throw new easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg(e.getMessage(), e);
		}
		return res;
	}


	@Override
	public GetNodeInformationsResponse getNodeInformations(
			GetNodeInformations parameters) throws AdminExceptionMsg {
		GetNodeInformationsResponse response = new GetNodeInformationsResponse();
		try {
			easyesb.petalslink.com.data.admin._1.GetNodeInformationsResponse res = ((BaseAdminEndpointBehaviour)this.getBaseAdminEndpoint().findBehaviour(BaseAdminEndpointBehaviour.class)).getNodeInformations(new easyesb.petalslink.com.data.admin._1.GetNodeInformations());
			response.setNode(res.getNode());
		} catch (ManagementException e) {
			throw new easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg(e.getMessage(), e);
		} catch (ESBException e) {
			throw new easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg(e.getMessage(), e);
		}

		return response;
	}


	@Override
	public List<String> getConnectedEsbs() throws AdminExceptionMsg {
		try {
			return ((DataCollectorEngineBehaviour)this.getDataCollectorEngine().findBehaviour(DataCollectorEngineBehaviour.class)).getEsbNodeAddresses();
		} catch (ESBException e) {
			throw new easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg(e.getMessage(), e);
		}
	}


	@Override
	public void monitorEndpoints(String notificationAddress,
			List<MonitoringEndpointType> endpoint) throws AdminExceptionMsg {
		try {
			List<easierbsm.petalslink.com.data.wsdmmanager._1.MonitoringEndpointType> endpoints = new ArrayList<easierbsm.petalslink.com.data.wsdmmanager._1.MonitoringEndpointType>();
			for(MonitoringEndpointType ep: endpoint) {
				easierbsm.petalslink.com.data.wsdmmanager._1.MonitoringEndpointType e = new easierbsm.petalslink.com.data.wsdmmanager._1.MonitoringEndpointType();
				e.setAddress(ep.getAddress());
				e.setName(e.getName());
				endpoints.add(e);
			}

			((WSDMMonitoringEngineBehaviour)this.getMonitoringEngine().findBehaviour(WSDMMonitoringEngineBehaviour.class)).monitorEndpoints(notificationAddress, endpoints);
		} catch (easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg e) {
			throw new easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg(e.getMessage(), e);
		} catch (ESBException e) {
			throw new easierbsm.petalslink.com.service.bsmadmin._1_0.AdminExceptionMsg(e.getMessage(), e);
		}

	}


}
