/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easierbsm.wsdm.monitoring.client;

import java.util.List;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easycommons.research.util.cxf.CXFHelper;

import easierbsm.petalslink.com.data.wsdmmanager._1.ActivateBusinessMonitoringType;
import easierbsm.petalslink.com.data.wsdmmanager._1.MonitoringEndpointType;
import easierbsm.petalslink.com.data.wsdmmanager._1.UnActivateBusinessMonitoringType;
import easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg;
import easierbsm.petalslink.com.service.wsdmmanager._1_0.WSDMManagerItf;

public class WSDMMonitoringClient implements WSDMManagerItf {


	private String address;
	private WSDMManagerItf clientProxy;
	
    public WSDMMonitoringClient(String address) {
        this.address = address;
    }
    
    /**
     * @return the clientProxy
     */
    private synchronized WSDMManagerItf getBSMClientProxy() {
        if (clientProxy != null) {
            return clientProxy;
        }
        this.clientProxy = CXFHelper.getClient(address, WSDMManagerItf.class);
        return clientProxy;
    }

	@Override
	public List<MonitoringEndpointType> getAllMonitoringEndpoints()
			throws AdminExceptionMsg {
		return this.getBSMClientProxy().getAllMonitoringEndpoints();
	}

	@Override
	public String createMonitoringEndpoint(QName wsdmServiceName,
			String wsdmProviderEndpointName, boolean exposeInSoap)
			throws AdminExceptionMsg {
		return this.getBSMClientProxy().createMonitoringEndpoint(wsdmServiceName, wsdmProviderEndpointName, exposeInSoap);
	}

	@Override
	public boolean unActivateBusinessMonitoring(
			UnActivateBusinessMonitoringType unActivateBusinessMonitoring)
			throws AdminExceptionMsg {
		return this.getBSMClientProxy().unActivateBusinessMonitoring(unActivateBusinessMonitoring);
	}

	@Override
	public boolean activateBusinessMonitoring(
			ActivateBusinessMonitoringType activateBusinessMonitoring)
			throws AdminExceptionMsg {
		return this.getBSMClientProxy().activateBusinessMonitoring(activateBusinessMonitoring);
	}

	@Override
	public void connectToDataCollector() throws AdminExceptionMsg {
		this.getBSMClientProxy().connectToDataCollector();
	}

	@Override
	public void synchronize(String esbAddress) throws AdminExceptionMsg {
		this.getBSMClientProxy().synchronize(esbAddress);
	}

}
