/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
package com.ebmwebsourcing.easierbsm.wsdm.monitoring.core;

import java.util.logging.Logger;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easierbsm.datacollector.ESBDataCollectorFactoryImpl;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMMonitoringEngine;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.impl.WSDMMonitoringEngineImpl;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.impl.WSDMMonitoringEngineBehaviourImpl;
import com.ebmwebsourcing.easyesb.esb.api.ESBFactory;
import com.ebmwebsourcing.easyesb.esb.impl.ESBFactoryImpl;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.config.Configuration;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.node.Node;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.endpoint.AdminEndpoint;

public class ESBWSDMFactoryImpl implements ESBFactory {

	private static Logger log = Logger.getLogger(ESBWSDMFactoryImpl.class.getName());

	public static QName WSDM_MONITORING_COMPONENT_NAME = new QName("http://petals.ow2.org", "WSDMMonitoring");

	private ESBFactoryImpl parentFactory = new ESBFactoryImpl();
	
	
	@Override
	public Node createNode(QName name,
			Configuration conf) throws ESBException {
		
		final Node node = parentFactory.createDefaultNode(name, conf);

		Endpoint<?> dispatcher = ((RegistryEndpointBehaviour)node.getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoint(new QName(ESBDataCollectorFactoryImpl.DATA_COLLECTOR_NAMESPACE, ESBDataCollectorFactoryImpl.DISPATCHER_PROVIDER_ENDPOINT_NAME));
		if(dispatcher == null) {
			ESBDataCollectorFactoryImpl.createDataCollector(node, this, conf);
		}

		createWSDMMonitoring(node, this, conf);

		return node;
	}

	public static void createWSDMMonitoring(final Node node, final ESBFactory factory, final Configuration conf) throws ESBException {
		// add wsdm support
		final WSDMMonitoringEngine wsdmMonitoringEngine = ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).createComponent(
				WSDM_MONITORING_COMPONENT_NAME,
				WSDMMonitoringEngineImpl.class);
		wsdmMonitoringEngine.addBehaviourClass(WSDMMonitoringEngineBehaviourImpl.class);

		final AdminEndpoint<?> adminEndpoint = factory.getAdminEndpoint();		
		wsdmMonitoringEngine.setAdminEndpoint(adminEndpoint);

		SoapServer soapServer = (SoapServer) ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).getExternalServer("soap-server");
		if(soapServer == null) {
			throw new ESBException("Soap server cannot be null");
		}

	}


	public static WSDMMonitoringEngine getWSDMMonitoring(final Node node) throws ESBException {
		return  (WSDMMonitoringEngine) ((NodeBehaviour)node.findBehaviour(NodeBehaviour.class)).getComponent(
				WSDM_MONITORING_COMPONENT_NAME);
	}

	@Override
	public Configuration getDefaultConfiguration() throws ESBException {
		return parentFactory.getDefaultConfiguration();
	}

	@Override
	public void addSpecificElements(QName arg0, Node arg1, Configuration arg2)
			throws ESBException {
		// do nothing
	}

	@Override
	public AdminEndpoint<?> getAdminEndpoint() {
		return parentFactory.getAdminEndpoint();
	}

}
