/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.impl;

import com.ebmwebsourcing.easierbsm.contant.EasierBSMFramework;
import com.ebmwebsourcing.easierbsm.datacollector.api.DataCollectorEngine;
import com.ebmwebsourcing.easierbsm.datacollector.api.DataCollectorEngineBehaviour;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.MonitoringException;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMMonitoringEngine;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMMonitoringEngineBehaviour;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMProviderEndpoint;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMService;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.impl.WSDMCreationEndpointManager;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPException;
import com.ebmwebsourcing.easycommons.soap.handler.SOAPHandler;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.exchange10.api.ExchangeException;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.exchange10.api.type.PatternType;
import com.ebmwebsourcing.easyesb.external.protocol.soap.impl.server.SoapServer;
import com.ebmwebsourcing.easyesb.rawreport10.api.element.ReportList;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.component.Component;
import com.ebmwebsourcing.easyesb.soa.api.component.ComponentBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.AbstractEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.NotificationProducerEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.node.NodeBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.registry.RegistryEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.service.Service;
import com.ebmwebsourcing.easyesb.soa.api.service.ServiceBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.soa.impl.component.ComponentBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.service.ServiceBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa10.api.type.ComponentType;
import com.ebmwebsourcing.easyesb.soa10.api.type.NodeType;
import com.ebmwebsourcing.easyesb.technical.service.admin.api.endpoint.behaviour.BaseAdminEndpointBehaviour;
import com.ebmwebsourcing.easyesb.technical.service.admin.impl.endpoint.behaviour.BaseAdminEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.esstar.management.AdminManagementClientSOAP;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Subscribe;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.SubscribeResponse;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.WSNHelper;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import com.ebmwebsourcing.wsstar.wsrfbf.services.faults.AbsWSStarFault;
import com.petalslink.esstar.essynchronizer.impl.ResourceException;
import com.petalslink.esstar.execution_environment_synchronizer_impl._1.ObjectFactory;
import easierbsm.petalslink.com.data.wsdmmanager._1.ActivateBusinessMonitoring;
import easierbsm.petalslink.com.data.wsdmmanager._1.ActivateBusinessMonitoringResponse;
import easierbsm.petalslink.com.data.wsdmmanager._1.ActivateBusinessMonitoringType;
import easierbsm.petalslink.com.data.wsdmmanager._1.ConnectToDataCollector;
import easierbsm.petalslink.com.data.wsdmmanager._1.ConnectToDataCollectorResponse;
import easierbsm.petalslink.com.data.wsdmmanager._1.CreateMonitoringEndpoint;
import easierbsm.petalslink.com.data.wsdmmanager._1.CreateMonitoringEndpointResponse;
import easierbsm.petalslink.com.data.wsdmmanager._1.GetAllMonitoringEndpoints;
import easierbsm.petalslink.com.data.wsdmmanager._1.GetAllMonitoringEndpointsResponse;
import easierbsm.petalslink.com.data.wsdmmanager._1.MonitorEndpoints;
import easierbsm.petalslink.com.data.wsdmmanager._1.MonitorEndpointsResponse;
import easierbsm.petalslink.com.data.wsdmmanager._1.MonitoringEndpointType;
import easierbsm.petalslink.com.data.wsdmmanager._1.OperationListType;
import easierbsm.petalslink.com.data.wsdmmanager._1.UnActivateBusinessMonitoring;
import easierbsm.petalslink.com.data.wsdmmanager._1.UnActivateBusinessMonitoringResponse;
import easierbsm.petalslink.com.data.wsdmmanager._1.UnActivateBusinessMonitoringType;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbResourceIdentifier;
import easybox.petalslink.com.esrawreport._1.EJaxbReportListType;
import easybox.petalslink.com.esrawreport._1.EJaxbReportType;
import easyesb.petalslink.com.service.admin._1_0.AdminExceptionMsg;
import esstar.petalslink.com.data.management.admin._1.GetResourceIdentifiers;
import esstar.petalslink.com.data.management.admin._1.GetResourceIdentifiersResponse;
import esstar.petalslink.com.service.management.admin._1_0.AdminManagementException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.oasis_open.docs.wsn.bw_2.InvalidFilterFault;
import org.oasis_open.docs.wsn.bw_2.InvalidMessageContentExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidProducerPropertiesExpressionFault;
import org.oasis_open.docs.wsn.bw_2.InvalidTopicExpressionFault;
import org.oasis_open.docs.wsn.bw_2.NotifyMessageNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.SubscribeCreationFailedFault;
import org.oasis_open.docs.wsn.bw_2.TopicExpressionDialectUnknownFault;
import org.oasis_open.docs.wsn.bw_2.TopicNotSupportedFault;
import org.oasis_open.docs.wsn.bw_2.UnacceptableInitialTerminationTimeFault;
import org.oasis_open.docs.wsn.bw_2.UnrecognizedPolicyRequestFault;
import org.oasis_open.docs.wsn.bw_2.UnsupportedPolicyRequestFault;
import org.oasis_open.docs.wsrf.rw_2.ResourceUnknownFault;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Binding;
import org.petalslink.abslayer.service.api.Description;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WSDMMonitoringEngineBehaviourImpl
extends AbstractEndpointBehaviourImpl
implements WSDMMonitoringEngineBehaviour {
    private final Logger log = Logger.getLogger(WSDMMonitoringEngineBehaviourImpl.class.getName());
    private easierbsm.petalslink.com.data.wsdmmanager._1.ObjectFactory factory = new easierbsm.petalslink.com.data.wsdmmanager._1.ObjectFactory();
    private WSDMMonitoringEngine wsdmMonitoringEngine;
    private WSDMCreationEndpointManager wsdmCreationEndpointManager;

    static {
        try {
            SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{easierbsm.petalslink.com.data.wsdmmanager._1.ObjectFactory.class, ObjectFactory.class});
        }
        catch (SOAException sOAException) {
            // empty catch block
        }
    }

    public WSDMMonitoringEngineBehaviourImpl(Component<? extends ComponentType> ep) throws ESBException {
        super(ep);
        try {
            URL url = Thread.currentThread().getContextClassLoader().getResource("wsdl/wsdmmanager10.wsdl");
            Description desc = (Description)Factory.getInstance().wrap(((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasierBSMFramework.getInstance()).get()).readDocument(url, Definitions.class));
            this.setBinding((Binding)desc.getBindings().iterator().next());
            this.wsdmMonitoringEngine = (WSDMMonitoringEngine)ep;
            this.wsdmCreationEndpointManager = new WSDMCreationEndpointManager(this);
        }
        catch (XmlObjectReadException e) {
            throw new ESBException((Throwable)e);
        }
    }

    public void execute(Exchange exchange) throws TransportException {
        this.log.finest("WSDM MONITORING BEHAVIOUR FOUND: " + exchange.getOperation());
        try {
            if (QName.valueOf(exchange.getOperation()).getLocalPart().equals("createMonitoringEndpoint") && QName.valueOf(exchange.getOperation()).getNamespaceURI().equals("http://com.petalslink.easyesb/service/wsdmadmin/1.0")) {
                this.log.finest("CREATE MONITORING ENDPOINT METHOD");
                CreateMonitoringEndpoint createMonitoringEndpoint = (CreateMonitoringEndpoint)SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), CreateMonitoringEndpoint.class);
                String res = this.createMonitoringEndpoint(createMonitoringEndpoint.getWsdmServiceName(), createMonitoringEndpoint.getWsdmProviderEndpointName(), createMonitoringEndpoint.isExposeInSoap());
                CreateMonitoringEndpointResponse createMonitoringEndpointResponse = this.factory.createCreateMonitoringEndpointResponse();
                createMonitoringEndpointResponse.setWsdmEndpointName(res);
                Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)createMonitoringEndpointResponse);
                MessageUtil.getInstance().createOutMessageStructure(exchange);
                exchange.getMessageOut().getBody().setPayload(docResp);
            } else if (QName.valueOf(exchange.getOperation()).getLocalPart().equals("getAllMonitoringEndpoints") && QName.valueOf(exchange.getOperation()).getNamespaceURI().equals("http://com.petalslink.easyesb/service/wsdmadmin/1.0")) {
                this.log.finest("GET ALL MONITORING ENDPOINTS");
                GetAllMonitoringEndpoints getAllMonitoringEndpoints = (GetAllMonitoringEndpoints)SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), GetAllMonitoringEndpoints.class);
                List<MonitoringEndpointType> res = this.getAllMonitoringEndpoints();
                GetAllMonitoringEndpointsResponse getAllMonitoringEndpointsResponse = this.factory.createGetAllMonitoringEndpointsResponse();
                for (MonitoringEndpointType mep : res) {
                    getAllMonitoringEndpointsResponse.getEndpoint().add(mep);
                }
                Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)getAllMonitoringEndpointsResponse);
                MessageUtil.getInstance().createOutMessageStructure(exchange);
                exchange.getMessageOut().getBody().setPayload(docResp);
            } else if (QName.valueOf(exchange.getOperation()).getLocalPart().equals("activateBusinessMonitoring") && QName.valueOf(exchange.getOperation()).getNamespaceURI().equals("http://com.petalslink.easyesb/service/wsdmadmin/1.0")) {
                this.log.finest("Activate Business Monitoring");
                ActivateBusinessMonitoring activateIn = (ActivateBusinessMonitoring)SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), ActivateBusinessMonitoring.class);
                boolean res = this.activateBusinessMonitoring(activateIn.getActivateBusinessMonitoring());
                ActivateBusinessMonitoringResponse response = new ActivateBusinessMonitoringResponse();
                response.setActivateBunsinessMonitoringResponseModel(res);
                Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)response);
                MessageUtil.getInstance().createOutMessageStructure(exchange);
                exchange.getMessageOut().getBody().setPayload(docResp);
            } else if (QName.valueOf(exchange.getOperation()).getLocalPart().equals("unActivateBusinessMonitoring") && QName.valueOf(exchange.getOperation()).getNamespaceURI().equals("http://com.petalslink.easyesb/service/wsdmadmin/1.0")) {
                this.log.finest("Activate Business Monitoring");
                UnActivateBusinessMonitoring activateIn = (UnActivateBusinessMonitoring)SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), UnActivateBusinessMonitoring.class);
                boolean res = this.unActivateBusinessMonitoring(activateIn.getUnActivateBusinessMonitoring());
                UnActivateBusinessMonitoringResponse response = new UnActivateBusinessMonitoringResponse();
                response.setUnActivateBusinessMonitoringResponse(res);
                Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)response);
                MessageUtil.getInstance().createOutMessageStructure(exchange);
                exchange.getMessageOut().getBody().setPayload(docResp);
            } else if (QName.valueOf(exchange.getOperation()).getLocalPart().equals("connectToDataCollector") && QName.valueOf(exchange.getOperation()).getNamespaceURI().equals("http://com.petalslink.easyesb/service/wsdmadmin/1.0")) {
                this.log.finest("connectToDataCollector");
                ConnectToDataCollector connect = (ConnectToDataCollector)SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), ConnectToDataCollector.class);
                this.connectToDataCollector();
                ConnectToDataCollectorResponse response = new ConnectToDataCollectorResponse();
                Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)response);
                MessageUtil.getInstance().createOutMessageStructure(exchange);
                exchange.getMessageOut().getBody().setPayload(docResp);
            } else if (QName.valueOf(exchange.getOperation()).getLocalPart().equals("monitorEndpoints") && QName.valueOf(exchange.getOperation()).getNamespaceURI().equals("http://com.petalslink.easyesb/service/wsdmadmin/1.0")) {
                this.log.finest("monitorEndpoints");
                MonitorEndpoints monitor = (MonitorEndpoints)SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), MonitorEndpoints.class);
                this.monitorEndpoints(monitor.getNotificationAddress(), monitor.getEndpoint());
                MonitorEndpointsResponse response = new MonitorEndpointsResponse();
                Document docResp = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)response);
                MessageUtil.getInstance().createOutMessageStructure(exchange);
                exchange.getMessageOut().getBody().setPayload(docResp);
            } else if (QName.valueOf(exchange.getOperation()).getLocalPart().equals("Notify")) {
                this.log.info("NOTIFY");
                System.out.println("NOTIFY IN BASE ADMIN:" + XMLPrettyPrinter.prettyPrint((Document)exchange.getMessageIn().getBody().getPayload()));
                Notify notify = Wsnb4ServUtils.getWsnbReader().readNotify(exchange.getMessageIn().getBody().getPayload());
                this.notify(notify);
            } else {
                super.execute(exchange);
            }
        }
        catch (easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg e) {
            try {
                Document docEx = SOAJAXBContext.getInstance().unmarshallAnyElement((Object)e.getFaultInfo());
                Document fault = SOAPHandler.createSoapFault((Document)docEx);
                exchange.getMessageError().getBody().setPayload(fault);
                this.log.severe("ERROR EX: " + XMLPrettyPrinter.prettyPrint((Document)exchange.getMessageError().getBody().getPayload()));
            }
            catch (SOAException ex) {
                this.log.severe("ERROR EX: " + ex.getMessage());
                throw new TransportException((Throwable)ex);
            }
            catch (SOAPException ex) {
                this.log.severe("ERROR EX: " + ex.getMessage());
                throw new TransportException((Throwable)ex);
            }
        }
        catch (SOAException e) {
            this.log.severe("ERROR EX: " + e.getMessage());
            throw new TransportException((Throwable)e);
        }
        catch (WsnbException e) {
            this.log.severe("ERROR EX: " + e.getMessage());
        }
    }

    public String createMonitoringEndpoint(QName wsdmServiceName, String wsdmProviderEndpointName, boolean exposeInSoap) throws easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg {
        String res = null;
        try {
            WSDMService wsdmService = this.wsdmMonitoringEngine.createMonitoringService(wsdmServiceName);
            WSDMProviderEndpoint wsdmEndpoint = wsdmService.createMonitoringEndpoint(wsdmProviderEndpointName);
            if (exposeInSoap) {
                BaseAdminEndpointBehaviour adminBehaviour = (BaseAdminEndpointBehaviour)this.wsdmMonitoringEngine.getAdminEndpoint().findBehaviour(BaseAdminEndpointBehaviourImpl.class);
                if (adminBehaviour == null) {
                    throw new ESBException("Internal error wsdm admin behaviour must be coupled with admin behaviour");
                }
                res = adminBehaviour.exposeServiceEndpointInSoap(wsdmServiceName, wsdmProviderEndpointName);
            } else {
                res = wsdmEndpoint.getQName().toString();
            }
        }
        catch (ESBException e) {
            this.log.severe(e.getMessage());
            e.printStackTrace();
        }
        catch (MonitoringException e) {
            this.log.severe(e.getMessage());
            e.printStackTrace();
        }
        catch (AdminExceptionMsg e) {
            this.log.severe(e.getMessage());
            e.printStackTrace();
        }
        return res;
    }

    public List<MonitoringEndpointType> getAllMonitoringEndpoints() throws easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg {
        ArrayList<MonitoringEndpointType> res = new ArrayList<MonitoringEndpointType>();
        List services = null;
        ComponentBehaviour cb = (ComponentBehaviour)this.getMonitoringEngine().findBehaviour(ComponentBehaviourImpl.class);
        services = cb.getServices();
        for (Service s : services) {
            if (((ServiceBehaviour)s.findBehaviour(ServiceBehaviourImpl.class)).getProviderEndpoints() == null) continue;
            for (ProviderEndpoint ep : ((ServiceBehaviour)s.findBehaviour(ServiceBehaviourImpl.class)).getProviderEndpoints()) {
                SoapServer soapServer = (SoapServer)((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).getExternalServer("soap-server");
                int soapPort = 8085;
                if (soapServer != null) {
                    soapPort = soapServer.getConfig().getPort();
                }
                String address = "http://" + ((NodeType)this.getEndpoint().getNode().getModel()).getBasicNodeInformations().getHost() + ":" + soapPort + "/services/" + ep.getQName().getLocalPart() + "ClientProxyEndpoint";
                WSDMProviderEndpoint mep = (WSDMProviderEndpoint)ep;
                MonitoringEndpointType wsdmEndpoint = new MonitoringEndpointType();
                wsdmEndpoint.setAddress(address);
                wsdmEndpoint.setName(ep.getQName());
                if (wsdmEndpoint.getOperations() == null) {
                    wsdmEndpoint.setOperations(new OperationListType());
                }
                for (QName opName : mep.getOperationMetricsMap().keySet()) {
                    wsdmEndpoint.getOperations().getOperationName().add(opName.getLocalPart());
                }
                res.add(wsdmEndpoint);
            }
        }
        return res;
    }

    public WSDMMonitoringEngine getMonitoringEngine() {
        return this.wsdmMonitoringEngine;
    }

    public void setMonitoringEngine(WSDMMonitoringEngine me) {
        this.wsdmMonitoringEngine = me;
    }

    public boolean activateBusinessMonitoring(ActivateBusinessMonitoringType activateBusinessMonitoring) throws easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg {
        return this.wsdmMonitoringEngine.activateBusinessMonitoring(activateBusinessMonitoring.getEndpoint(), activateBusinessMonitoring.getOperation());
    }

    public boolean unActivateBusinessMonitoring(UnActivateBusinessMonitoringType unActivateBusinessMonitoring) throws easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg {
        return this.wsdmMonitoringEngine.unActivateBusinessMonitoring(unActivateBusinessMonitoring.getEndpoint(), unActivateBusinessMonitoring.getOperation());
    }

    public void connectToDataCollector() throws easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg {
        try {
            DataCollectorEngine dataCollectorEngine = (DataCollectorEngine)((NodeBehaviour)this.getEndpoint().getNode().findBehaviour(NodeBehaviour.class)).getComponent(new QName("http://petals.ow2.org", "DataCollector"));
            if (dataCollectorEngine == null) {
                throw new easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg("dataCollectorEngine cannot be nul!!!");
            }
            EndpointAddress epr = new EndpointAddress(this.getEndpoint().getQName().getNamespaceURI(), null, this.getEndpoint().getQName().getLocalPart());
            URI address = ESBUtil.generateURI((EndpointAddress)epr);
            QName topicUsedCreationRsc = new QName("http://www.petalslink.org/resources/event/1.0", "CreationResourcesTopic", "bsm");
            Subscribe subscribeCreationRsc = WSNHelper.createSubscription((String)address.toString(), (QName)topicUsedCreationRsc);
            SubscribeResponse responseCreationRsc = ((DataCollectorEngineBehaviour)dataCollectorEngine.findBehaviour(DataCollectorEngineBehaviour.class)).subscribe(WSNHelper.convert2JaxbElement((Subscribe)subscribeCreationRsc));
            QName topicUsedRawReport = new QName("http://www.petalslink.org/rawreport/1.0", "RawReportTopic", "bsm");
            Subscribe subscribeRawReport = WSNHelper.createSubscription((String)address.toString(), (QName)topicUsedRawReport);
            SubscribeResponse responseRawReport = ((DataCollectorEngineBehaviour)dataCollectorEngine.findBehaviour(DataCollectorEngineBehaviour.class)).subscribe(WSNHelper.convert2JaxbElement((Subscribe)subscribeRawReport));
        }
        catch (WsnbException e) {
            throw new easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        catch (SOAException e) {
            throw new easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        catch (TopicNotSupportedFault e) {
            throw new easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        catch (ResourceUnknownFault e) {
            throw new easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        catch (UnsupportedPolicyRequestFault e) {
            throw new easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        catch (UnrecognizedPolicyRequestFault e) {
            throw new easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        catch (SubscribeCreationFailedFault e) {
            throw new easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        catch (UnacceptableInitialTerminationTimeFault e) {
            throw new easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        catch (InvalidFilterFault e) {
            throw new easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        catch (InvalidProducerPropertiesExpressionFault e) {
            throw new easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        catch (InvalidTopicExpressionFault e) {
            throw new easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        catch (NotifyMessageNotSupportedFault e) {
            throw new easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        catch (InvalidMessageContentExpressionFault e) {
            throw new easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        catch (TopicExpressionDialectUnknownFault e) {
            throw new easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
    }

    public void notify(Notify notify) throws WsnbException {
        try {
            System.out.println("WSDM Monitoring Engine Notify: \n" + XMLPrettyPrinter.prettyPrint((Document)Wsnb4ServUtils.getWsnbWriter().writeNotifyAsDOM(notify)));
            for (NotificationMessageHolderType nmht : notify.getNotificationMessage()) {
                ReportList request;
                EJaxbReportListType requestModel;
                Element msg = nmht.getMessage().getAny();
                Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                doc.appendChild(doc.adoptNode(msg));
                System.out.println("msg = " + msg.getLocalName());
                if (msg.getLocalName().equals("resourceIdentifier")) {
                    EJaxbResourceIdentifier rsc = (EJaxbResourceIdentifier)SOAJAXBContext.getInstance().marshallAnyType(doc, EJaxbResourceIdentifier.class);
                    this.wsdmCreationEndpointManager.analyzeResource(rsc);
                    continue;
                }
                if (!msg.getLocalName().equals("reportList") || (requestModel = (EJaxbReportListType)(request = (ReportList)((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasierBSMFramework.getInstance()).get()).readDocument(doc, ReportList.class)).getModelObject()).getReport().size() <= 0) continue;
                EJaxbReportType report = (EJaxbReportType)requestModel.getReport().get(0);
                String endpointName = "{" + report.getServiceQName().getNamespaceURI() + "}" + report.getEndpointName() + "_WSDMMonitoring";
                ProviderEndpoint wsdmEp = (ProviderEndpoint)((RegistryEndpointBehaviour)this.getEndpoint().getNode().getRegistryEndpoint().findBehaviour(RegistryEndpointBehaviour.class)).getLocalEndpoint(QName.valueOf(endpointName));
                if (wsdmEp != null) {
                    Exchange ex = ((ClientEndpoint)this.endpoint).createExchange();
                    ex.setDestination(wsdmEp.getQName());
                    ex.setInterfaceName(new QName("http://docs.oasis-open.org/wsn/bw-2", "NotificationConsumer"));
                    ex.setOperation("Notify");
                    ex.setServiceName(wsdmEp.getServiceProvider().getQName());
                    ex.setPattern(PatternType.IN_ONLY);
                    MessageUtil.getInstance().createInMessageStructure(ex);
                    ex.getMessageIn().getBody().setPayload(Wsnb4ServUtils.getWsnbWriter().writeNotifyAsDOM(notify));
                    ((ClientEndpoint)this.getEndpoint()).send(ex);
                    this.log.finest("WSDM Endpoint service found: " + endpointName);
                    continue;
                }
                this.log.warning("WSDM Endpoint not found: " + endpointName);
            }
        }
        catch (ParserConfigurationException e) {
            throw new WsnbException((Throwable)e);
        }
        catch (SOAException e) {
            throw new WsnbException((Throwable)e);
        }
        catch (ResourceException e) {
            throw new WsnbException((Throwable)e);
        }
        catch (XmlObjectReadException e) {
            throw new WsnbException((Throwable)e);
        }
        catch (TransportException e) {
            throw new WsnbException((Throwable)e);
        }
        catch (ExchangeException e) {
            throw new WsnbException((Throwable)e);
        }
        catch (ESBException e) {
            throw new WsnbException((Throwable)e);
        }
    }

    public void synchronize(String esbAddress) throws easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg {
        AdminManagementClientSOAP client = new AdminManagementClientSOAP(esbAddress);
        try {
            GetResourceIdentifiersResponse response = client.getResourceIdentifiers(new GetResourceIdentifiers());
            for (EJaxbResourceIdentifier rsc : response.getResourceIdentifier()) {
                this.wsdmCreationEndpointManager.analyzeResource(rsc);
            }
        }
        catch (AdminManagementException e) {
            throw new easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        catch (ResourceException e) {
            throw new easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
    }

    public void monitorEndpoints(String notificationAddress, List<MonitoringEndpointType> endpoint) throws easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg {
        try {
            List services = null;
            ComponentBehaviour cb = (ComponentBehaviour)this.getMonitoringEngine().findBehaviour(ComponentBehaviourImpl.class);
            services = cb.getServices();
            for (Service s : services) {
                if (((ServiceBehaviour)s.findBehaviour(ServiceBehaviourImpl.class)).getProviderEndpoints() == null) continue;
                for (ProviderEndpoint ep : ((ServiceBehaviour)s.findBehaviour(ServiceBehaviourImpl.class)).getProviderEndpoints()) {
                    if (!(ep instanceof WSDMProviderEndpoint)) continue;
                    NotificationProducerEndpointBehaviour behaviour = (NotificationProducerEndpointBehaviour)((WSDMProviderEndpoint)ep).findBehaviour(NotificationProducerEndpointBehaviour.class);
                    QName topicUsed = new QName("http://docs.oasis-open.org/wsdm/2004/12/mows/wsdm-mows-events.xml", "MetricsCapability", "res");
                    Subscribe payload = WSNHelper.createSubscription((String)notificationAddress, (QName)topicUsed);
                    behaviour.subscribe(payload);
                }
            }
        }
        catch (WsnbException e) {
            throw new easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        catch (SOAException e) {
            throw new easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
        catch (AbsWSStarFault e) {
            throw new easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg(e.getMessage(), (Throwable)e);
        }
    }
}

