/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
/**
 * MonitoringEngine-Core - SOA Tools Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $id.java
 * -------------------------------------------------------------------------
 */
package com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Scope;
import org.oasisopen.sca.annotation.Service;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

import com.ebmwebsourcing.easierbsm.contant.EasierBSMFramework;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.Constants;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.MonitoringException;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMProviderEndpoint;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMService;
import com.ebmwebsourcing.easycommons.research.util.easybox.DefaultFramework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.NotificationProducerEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.SubscriptionManagerEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.service.ServiceBehaviour;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.NotificationProducerEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.SubscriptionManagerEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.service.TechnicalServiceImpl;
import com.ebmwebsourcing.easyesb.soa10.api.element.EndpointInitialContext;
import com.ebmwebsourcing.esstar.management.AdminManagementClient;
import com.ebmwebsourcing.wsaddressing10.api.element.Address;
import com.ebmwebsourcing.wsaddressing10.api.type.EndpointReferenceType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.refinedabstraction.RefinedWsnbFactory;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl.SubscribeImpl;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.impl.impl.WsnbModelFactoryImpl;
import com.ebmwebsourcing.wsstar.jaxb.notification.base.SubscribeResponse;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.abstraction.TopicSetType;
import com.ebmwebsourcing.wsstar.topics.datatypes.api.refinedabstraction.RefinedWstopFactory;
import com.ebmwebsourcing.wsstar.topics.datatypes.impl.impl.WstopModelFactoryImpl;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.engines.NotificationProducerEngine;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.engines.SubscriptionManagerEngine;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.topic.TopicsManagerEngine;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;

/**
 * @author Nicolas Salatge - eBM WebSourcing
 */
@Scope("COMPOSITE")
@Service(value=WSDMService.class, names="service")
@PolicySets("frascati:scaEasyCompositeWithContent")
public class WSDMServiceImpl extends TechnicalServiceImpl<com.ebmwebsourcing.easyesb.soa10.api.type.TechnicalServiceType> implements WSDMService {


	/**
	 *
	 */
	private static final long serialVersionUID = 1L;

	private static Logger log = Logger.getLogger(WSDMServiceImpl.class
			.getName());

	
	public static final String DISPATCHER_PROVIDER_ENDPOINT_NAME = "DispatcherProviderEndpoint";
    public static final String DISPATCHER_SERVICE_NAME = "DispacherService";
    public static final String DATA_COLLECTOR_NAMESPACE = "http://petals.ow2.org";

    
	public WSDMServiceImpl() throws ESBException {
		super();
	}
	
	public WSDMProviderEndpoint createMonitoringEndpoint(
			final String endpointName)
	throws MonitoringException {
		WSDMProviderEndpoint monitoringProviderEndpoint = null;
		try {
			EndpointInitialContext context = SOAUtil.getInstance().getXmlContext(EasierBSMFramework.getInstance()).getXmlObjectFactory().create(EndpointInitialContext.class);
			context.setNumberOfThreads(Constants.NUMBER_OF_THREAD_BY_WSDM_ENDPOINT);
			monitoringProviderEndpoint = ((ServiceBehaviour)this.findBehaviour(ServiceBehaviour.class)).createProviderEndpoint(
					endpointName, 
					WSDMProviderEndpointImpl.class,
					WSDMProviderEndpointBehaviourImpl.class,
					context);
			monitoringProviderEndpoint
			.addBehaviourClass(SubscriptionManagerEndpointBehaviourImpl.class);
			monitoringProviderEndpoint
			.addBehaviourClass(NotificationProducerEndpointBehaviourImpl.class);
					    
			String topicDef = "" +
					"<wstop:TopicSet xmlns:wstop=\"http://docs.oasis-open.org/wsn/t-1\" xmlns:tns1=\"http://docs.oasis-open.org/wsdm/2004/12/mows/wsdm-mows-events.xml\" >\n" + 
					"    <tns1:MetricsCapability wstop:topic=\"true\" />\n" + 
					"</wstop:TopicSet>\n";
			InputStream is = new ByteArrayInputStream(topicDef.getBytes());
			TopicSetType topicSet = RefinedWstopFactory.getInstance(new WstopModelFactoryImpl()).getWstopReader().readTopicSetType(new InputSource(is));
			is.close();
			
			SubscriptionManagerEndpointBehaviour subscriptionManagerEndpointBehaviour = monitoringProviderEndpoint.findBehaviour(SubscriptionManagerEndpointBehaviourImpl.class);
			subscriptionManagerEndpointBehaviour.setEvenTopicNamespaceDefinitionUrl(Thread.currentThread().getContextClassLoader().getResource("topicNamespace/wsdm10/wsdm-mows-events.xml"));
			subscriptionManagerEndpointBehaviour.setTopicSet(topicSet);

			final TopicsManagerEngine wstopTopicsMgr = new TopicsManagerEngine();
			final SubscriptionManagerEngine subscriptionManager = new SubscriptionManagerEngine(
					WSDMServiceImpl.log);
			subscriptionManager.setSubscriptionsManagerService(this.getQName());    
			
			final NotificationProducerEngine producer = new NotificationProducerEngine(
					WSDMServiceImpl.log, wstopTopicsMgr, subscriptionManager, true,
					subscriptionManagerEndpointBehaviour.getTopicSet(), subscriptionManagerEndpointBehaviour.getTopicNs(), "wsn", null /*this.notifSender*/);
			
			subscriptionManagerEndpointBehaviour.setSubscriptionManager(subscriptionManager);
			NotificationProducerEndpointBehaviour notificationProducerEndpointBehaviour = monitoringProviderEndpoint.findBehaviour(NotificationProducerEndpointBehaviourImpl.class);
			notificationProducerEndpointBehaviour.setNotificationProducer(producer);

			assert monitoringProviderEndpoint.getDescription() != null;
            
			
		} catch (final Exception e) {
			throw new MonitoringException(e);
		}
		
		return monitoringProviderEndpoint;
	}

}
