/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.impl;

import com.ebmwebsourcing.easierbsm.contant.EasierBSMFramework;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMProviderEndpoint;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectWriter;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easyesb.rawreport10.api.element.Report;
import com.ebmwebsourcing.easyesb.rawreport10.api.type.ReportListType;
import com.ebmwebsourcing.easyesb.rawreport10.api.type.TimeStampType;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.NotificationProducerEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.specific.SubscriptionManagerEndpointBehaviour;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.NotificationProducerEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.behaviour.specific.SubscriptionManagerEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.impl.endpoint.thread.NotificationProducerThreadImpl;
import com.ebmwebsourcing.wsdm10.api.element.LastRequestSize;
import com.ebmwebsourcing.wsdm10.api.element.LastResponseSize;
import com.ebmwebsourcing.wsdm10.api.element.LastResponseTime;
import com.ebmwebsourcing.wsdm10.api.element.MaxRequestSize;
import com.ebmwebsourcing.wsdm10.api.element.MaxResponseSize;
import com.ebmwebsourcing.wsdm10.api.element.MaxResponseTime;
import com.ebmwebsourcing.wsdm10.api.element.NumberOfFailedRequests;
import com.ebmwebsourcing.wsdm10.api.element.NumberOfRequests;
import com.ebmwebsourcing.wsdm10.api.element.NumberOfSuccessfulRequests;
import com.ebmwebsourcing.wsdm10.api.element.OperationMetrics;
import com.ebmwebsourcing.wsdm10.api.element.ServiceTime;
import easybox.petalslink.com.esrawreport._1.EJaxbReportListType;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class MetricsBuilder {
    private Logger log = Logger.getLogger(this.getClass().getCanonicalName());
    private ProviderEndpoint endpoint;
    private Map<String, ReportListType> existingMetrics = new ConcurrentHashMap<String, ReportListType>();

    public MetricsBuilder(ProviderEndpoint endpoint) {
        this.endpoint = endpoint;
    }

    private OperationMetrics createQosMetrics(String operationName, QName itfName) {
        OperationMetrics metrics = (OperationMetrics)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().create(OperationMetrics.class);
        ServiceTime serviceTime = (ServiceTime)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().create(ServiceTime.class);
        MaxResponseTime maxResponseTime = (MaxResponseTime)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().create(MaxResponseTime.class);
        LastResponseTime lastResponseTime = (LastResponseTime)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().create(LastResponseTime.class);
        NumberOfSuccessfulRequests numberOfSuccessfulRequests = (NumberOfSuccessfulRequests)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().create(NumberOfSuccessfulRequests.class);
        NumberOfRequests numberOfRequests = (NumberOfRequests)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().create(NumberOfRequests.class);
        NumberOfFailedRequests numberOfFailedRequests = (NumberOfFailedRequests)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().create(NumberOfFailedRequests.class);
        MaxRequestSize maxRequestSize = (MaxRequestSize)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().create(MaxRequestSize.class);
        MaxResponseSize maxResponseSize = (MaxResponseSize)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().create(MaxResponseSize.class);
        LastRequestSize lastRequestSize = (LastRequestSize)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().create(LastRequestSize.class);
        LastResponseSize lastResponseSize = (LastResponseSize)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().create(LastResponseSize.class);
        metrics.setOperationName(operationName);
        metrics.setPortType(itfName);
        metrics.setServiceTime(serviceTime);
        metrics.setMaxResponseTime(maxResponseTime);
        metrics.setLastResponseTime(lastResponseTime);
        metrics.setNumberOfSuccessfulRequests(numberOfSuccessfulRequests);
        metrics.setNumberOfRequests(numberOfRequests);
        metrics.setNumberOfFailedRequests(numberOfFailedRequests);
        metrics.setMaxRequestSize(maxRequestSize);
        metrics.setMaxResponseSize(maxResponseSize);
        metrics.setLastRequestSize(lastRequestSize);
        metrics.setLastResponseSize(lastResponseSize);
        return metrics;
    }

    private void updateMetric(OperationMetrics metric, long intLastRequestSize, long intLastResponseSize, Date startDate, Date endDate, boolean responseTypeSuccess, boolean responseTypeFail, boolean incrementNumberOfRequests) throws ESBException {
        this.log.finest("UPDATE METRICS !!!!");
        try {
            LastRequestSize lastRequestSize = metric.getLastRequestSize();
            lastRequestSize.setValue(Long.valueOf(intLastRequestSize));
            lastRequestSize.setLastUpdated(Calendar.getInstance().getTime());
            if (lastRequestSize.getResetAt() == null) {
                lastRequestSize.setResetAt(Calendar.getInstance().getTime());
            }
            metric.setLastRequestSize(lastRequestSize);
            LastResponseSize lastResponseSize = metric.getLastResponseSize();
            lastResponseSize.setValue(Long.valueOf(intLastResponseSize));
            lastResponseSize.setLastUpdated(Calendar.getInstance().getTime());
            if (lastResponseSize.getResetAt() == null) {
                lastResponseSize.setResetAt(Calendar.getInstance().getTime());
            }
            metric.setLastResponseSize(lastResponseSize);
            MaxRequestSize maxRequestSize = metric.getMaxRequestSize();
            if (maxRequestSize.getValue() == null) {
                maxRequestSize.setValue(Long.valueOf(metric.getLastRequestSize().getValue()));
                maxRequestSize.setLastUpdated(Calendar.getInstance().getTime());
                if (maxRequestSize.getResetAt() == null) {
                    maxRequestSize.setResetAt(Calendar.getInstance().getTime());
                }
            } else if (maxRequestSize.getValue() != null && maxRequestSize.getValue().intValue() < metric.getLastRequestSize().getValue().intValue()) {
                maxRequestSize.setValue(Long.valueOf(metric.getLastRequestSize().getValue()));
                maxRequestSize.setLastUpdated(Calendar.getInstance().getTime());
                if (maxRequestSize.getResetAt() == null) {
                    maxRequestSize.setResetAt(Calendar.getInstance().getTime());
                }
            }
            metric.setMaxRequestSize(maxRequestSize);
            MaxResponseSize maxResponseSize = metric.getMaxResponseSize();
            if (maxResponseSize.getValue() == null) {
                maxResponseSize.setValue(Long.valueOf(metric.getLastResponseSize().getValue()));
                maxResponseSize.setLastUpdated(Calendar.getInstance().getTime());
                if (maxResponseSize.getResetAt() == null) {
                    maxResponseSize.setResetAt(Calendar.getInstance().getTime());
                }
            } else if (maxResponseSize.getValue() != null && maxResponseSize.getValue().intValue() < metric.getLastResponseSize().getValue().intValue()) {
                maxResponseSize.setValue(Long.valueOf(metric.getLastResponseSize().getValue()));
                maxResponseSize.setLastUpdated(Calendar.getInstance().getTime());
                if (maxResponseSize.getResetAt() == null) {
                    maxResponseSize.setResetAt(Calendar.getInstance().getTime());
                }
            }
            metric.setMaxResponseSize(maxResponseSize);
            LastResponseTime lastResponseTime = metric.getLastResponseTime();
            if (startDate != null && endDate != null) {
                long time = endDate.getTime() - startDate.getTime();
                lastResponseTime.setValue(DatatypeFactory.newInstance().newDuration(time));
                lastResponseTime.setLastUpdated(Calendar.getInstance().getTime());
                if (lastResponseTime.getResetAt() == null) {
                    lastResponseTime.setResetAt(Calendar.getInstance().getTime());
                }
            }
            metric.setLastResponseTime(lastResponseTime);
            MaxResponseTime maxResponseTime = metric.getMaxResponseTime();
            if (maxResponseTime.getValue() == null) {
                maxResponseTime.setValue(metric.getLastResponseTime().getValue());
                maxResponseTime.setLastUpdated(Calendar.getInstance().getTime());
                if (maxResponseTime.getResetAt() == null) {
                    maxResponseTime.setResetAt(Calendar.getInstance().getTime());
                }
            } else if (maxResponseTime.getValue() != null && maxResponseTime.getValue().compare(metric.getLastResponseTime().getValue()) < -1) {
                maxResponseTime.setValue(metric.getLastResponseTime().getValue());
                maxResponseTime.setLastUpdated(Calendar.getInstance().getTime());
                if (maxResponseTime.getResetAt() == null) {
                    maxResponseTime.setResetAt(Calendar.getInstance().getTime());
                }
            }
            metric.setMaxResponseTime(maxResponseTime);
            ServiceTime serviceTime = metric.getServiceTime();
            if (serviceTime.getValue() == null) {
                serviceTime.setValue(lastResponseTime.getValue());
            } else {
                serviceTime.setValue(serviceTime.getValue().add(lastResponseTime.getValue()));
                serviceTime.setValue(serviceTime.getValue().multiply(new BigDecimal(0.5)));
            }
            if (serviceTime.getResetAt() == null) {
                serviceTime.setResetAt(Calendar.getInstance().getTime());
            }
            serviceTime.setLastUpdated(Calendar.getInstance().getTime());
            metric.setServiceTime(serviceTime);
            NumberOfRequests numberOfRequests = metric.getNumberOfRequests();
            if (numberOfRequests.getValue() == null) {
                numberOfRequests.setValue(Long.valueOf(0L));
            }
            if (incrementNumberOfRequests) {
                numberOfRequests.setValue(Long.valueOf(numberOfRequests.getValue() + 1L));
            }
            if (numberOfRequests.getResetAt() == null) {
                numberOfRequests.setResetAt(Calendar.getInstance().getTime());
            }
            numberOfRequests.setLastUpdated(Calendar.getInstance().getTime());
            metric.setNumberOfRequests(numberOfRequests);
            NumberOfSuccessfulRequests numberOfSuccessfulRequests = metric.getNumberOfSuccessfulRequests();
            if (numberOfSuccessfulRequests.getValue() == null) {
                numberOfSuccessfulRequests.setValue(Long.valueOf(0L));
            }
            if (responseTypeSuccess && incrementNumberOfRequests) {
                numberOfSuccessfulRequests.setValue(Long.valueOf(numberOfSuccessfulRequests.getValue() + 1L));
            }
            if (numberOfSuccessfulRequests.getResetAt() == null) {
                numberOfSuccessfulRequests.setResetAt(Calendar.getInstance().getTime());
            }
            numberOfSuccessfulRequests.setLastUpdated(Calendar.getInstance().getTime());
            metric.setNumberOfSuccessfulRequests(numberOfSuccessfulRequests);
            NumberOfFailedRequests numberOfFailedRequests = metric.getNumberOfFailedRequests();
            if (numberOfFailedRequests.getValue() == null) {
                numberOfFailedRequests.setValue(Long.valueOf(0L));
            }
            if (responseTypeFail && incrementNumberOfRequests) {
                numberOfFailedRequests.setValue(Long.valueOf(numberOfFailedRequests.getValue() + 1L));
            }
            if (numberOfFailedRequests.getResetAt() == null) {
                numberOfFailedRequests.setResetAt(Calendar.getInstance().getTime());
            }
            numberOfFailedRequests.setLastUpdated(GregorianCalendar.getInstance().getTime());
            metric.setNumberOfFailedRequests(numberOfFailedRequests);
        }
        catch (DatatypeConfigurationException e) {
            throw new ESBException((Throwable)e);
        }
    }

    public void addNewReportList(EJaxbReportListType addNewReportListRequest) {
        block15: {
            ReportListType reports = (ReportListType)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().wrap((Object)addNewReportListRequest, ReportListType.class);
            if (reports.getReports().length == 2) {
                Report reportProviderIn = reports.getReports()[0];
                Report reportProviderOut = reports.getReports()[1];
                if (reports.getReports()[0].getTimeStamp() != null && reports.getReports()[0].getTimeStamp().equals((Object)TimeStampType.t1)) {
                    try {
                        this.log.finest("addNewReport - retrieve metrics ... " + this.endpoint.getName());
                        OperationMetrics metric = ((WSDMProviderEndpoint)this.endpoint).getOperationMetricsMap().get(QName.valueOf(reportProviderIn.getOperationName().trim()));
                        this.log.finest("addNewReport - is there metric : " + metric + " for operation " + QName.valueOf(reportProviderIn.getOperationName()));
                        if (metric == null) {
                            QName itfName = null;
                            if (reportProviderIn.getInterfaceQName() != null) {
                                itfName = reportProviderIn.getInterfaceQName();
                            }
                            metric = this.createQosMetrics(reportProviderIn.getOperationName(), itfName);
                            ((WSDMProviderEndpoint)this.endpoint).getOperationMetricsMap().put(QName.valueOf(reportProviderIn.getOperationName().trim()), metric);
                            this.log.info("metric created for operation: " + reportProviderIn.getOperationName());
                        }
                        int requestLength = new Long(reportProviderIn.getContentLength()).intValue();
                        int responseLength = new Long(reportProviderOut.getContentLength()).intValue();
                        this.existingMetrics.put(reportProviderIn.getExchangeId(), reports);
                    }
                    catch (Exception e) {
                        this.log.severe(e.getMessage());
                        e.printStackTrace();
                    }
                } else if (reports.getReports()[0].getTimeStamp() != null && reports.getReports()[0].getTimeStamp().equals((Object)TimeStampType.t3)) {
                    try {
                        ReportListType contained = this.existingMetrics.get(reports.getReports()[0].getExchangeId());
                        long start = System.currentTimeMillis();
                        long timeout = 60000L;
                        while (contained == null && System.currentTimeMillis() - start < timeout) {
                            Thread.sleep(500L);
                            contained = this.existingMetrics.get(reports.getReports()[0].getExchangeId());
                        }
                        if (contained != null) {
                            OperationMetrics metricToUpdate = ((WSDMProviderEndpoint)this.endpoint).getOperationMetricsMap().get(QName.valueOf(reportProviderIn.getOperationName().trim()));
                            long lastRequestSize = contained.getReports()[0].getContentLength();
                            long lastResponseSize = reports.getReports()[0].getContentLength();
                            Date startDate = contained.getReports()[1].getDateInGMT();
                            Date endDate = reports.getReports()[0].getDateInGMT();
                            boolean isException = reports.getReports()[1].isDoesThisResponseIsAnException();
                            this.updateMetric(metricToUpdate, lastRequestSize, lastResponseSize, startDate, endDate, !isException, isException, true);
                            Document notifPayload = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
                            ((XmlObjectWriter)SOAUtil.getInstance().getWriter((Framework)EasierBSMFramework.getInstance()).get()).writeDocument((XmlObject)metricToUpdate, (Node)notifPayload);
                            QName topicUsed = new QName("http://docs.oasis-open.org/wsdm/2004/12/mows/wsdm-mows-events.xml", "MetricsCapability", "tns");
                            String dialect = "http://docs.oasis-open.org/wsn/t-1/TopicExpression/Concrete";
                            NotificationProducerEndpointBehaviour producerBehaviour = (NotificationProducerEndpointBehaviour)this.endpoint.findBehaviour(NotificationProducerEndpointBehaviourImpl.class);
                            if (producerBehaviour == null) {
                                throw new ESBException("Internal Error: This endpoint " + this.endpoint.getName() + " has no producer behaviour to send notification");
                            }
                            SubscriptionManagerEndpointBehaviour subscriptionManagerBehaviour = (SubscriptionManagerEndpointBehaviour)this.endpoint.findBehaviour(SubscriptionManagerEndpointBehaviourImpl.class);
                            if (subscriptionManagerBehaviour == null) {
                                throw new ESBException("Internal Error: This endpoint " + this.endpoint.getName() + " has no producer behaviour to send notification");
                            }
                            NotificationProducerThreadImpl notifier = new NotificationProducerThreadImpl(producerBehaviour, subscriptionManagerBehaviour, notifPayload, topicUsed, dialect);
                            notifier.start();
                            break block15;
                        }
                        this.log.severe("No T1/T2 reports found for this T3/T4 report ... " + reportProviderIn.getExchangeId() + "..." + reportProviderIn.getOperationName());
                    }
                    catch (Exception e) {
                        this.log.severe(e.getMessage());
                        e.printStackTrace();
                    }
                }
            } else {
                this.log.severe("Incorrect number of report");
            }
        }
    }
}

