

package com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMMonitoringEngineBehaviour;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMProviderEndpoint;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.petalslink.esstar.essynchronizer.impl.ResourceException;

import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbResourceIdentifier;

public class WSDMCreationEndpointManager  {

	private static Logger LOG = Logger.getLogger(WSDMCreationEndpointManager.class.getName());

	private List<com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.impl.Endpoint> functionnalEndpoints = new ArrayList<com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.impl.Endpoint>();

	private final WSDMMonitoringEngineBehaviour adminBehaviour;


	public WSDMCreationEndpointManager(WSDMMonitoringEngineBehaviour wsdmAdminBehaviour) {
		super();
		this.adminBehaviour = wsdmAdminBehaviour;
	}


	@SuppressWarnings("unused")
	public void analyzeResource(EJaxbResourceIdentifier rid) throws ResourceException {

		try {
			EndpointAddress endpoint = ESBUtil.analyzeURI(URI.create(rid.getId()));

			com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.impl.Endpoint ep = null;
			if(endpoint != null) {
				ep = this.createEndpoint(endpoint);
			} 

			// add endpoint in WSDM framework
			if(ep != null && !this.contains(this.functionnalEndpoints, ep)) {
				this.addMonitoringEndpointFromThisFunctionalEndpoint(ep);
				this.functionnalEndpoints.add(ep);
			}

		} catch (Throwable e) {
			// do nothing
			LOG.finest("This Resource \'" + rid + "\' cannot be analysed by " + this.getClass().getSimpleName());
		}


	}

	private com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.impl.Endpoint createEndpoint(EndpointAddress epr) throws ESBException {
		com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.impl.Endpoint ep = null;
		ep = new com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.impl.Endpoint();
		ep.setName(epr.getEndpointname());
		ep.setService(new QName(epr.getNamespace(), epr.getServicename()));
		return ep;
	}

	private boolean contains(List<com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.impl.Endpoint> functionnalEndpoints, com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.impl.Endpoint ep) {
		boolean res = false;
		for(com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.impl.Endpoint e: functionnalEndpoints) {
			if(e.getName().equals(ep.getName()) && e.getService().equals(ep.getService())) {
				res = true;
				break;
			}
		}
		return res;
	}

	private void addMonitoringEndpointFromThisFunctionalEndpoint(
			final com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.impl.Endpoint ep) throws ESBException {
		try {
			System.out.println("ddddddddddddddddddddddddddddddddddddddddddddddddddddddd ep serv = " + ep.getService());
			System.out.println("ddddddddddddddddddddddddddddddddddddddddddddddddddddddd ep = " + ep.getName());
			this.adminBehaviour.createMonitoringEndpoint(ep.getService(), ep
					.getName()
					+ WSDMProviderEndpoint.WSDM_MONITORING_SUFFIXE, true);
			
		} catch (easierbsm.petalslink.com.service.wsdmmanager._1_0.AdminExceptionMsg e) {
			e.printStackTrace();
			throw new ESBException(e);
		}
	}
}
