/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.impl;

import com.ebmwebsourcing.easierbsm.contant.EasierBSMFramework;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMProviderEndpoint;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMProviderEndpointBehaviour;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.impl.MetricsBuilder;
import com.ebmwebsourcing.easybox.api.XmlObjectReadException;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.rawreport10.api.element.ReportList;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ProviderEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.behaviour.AbstractEndpointBehaviourImpl;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.wsdm10.api.element.OperationMetrics;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.NotificationMessageHolderType;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.abstraction.Notify;
import com.ebmwebsourcing.wsstar.basenotification.datatypes.api.utils.WsnbException;
import com.ebmwebsourcing.wsstar.wsnb.services.impl.util.Wsnb4ServUtils;
import easierbsm.petalslink.com.data.wsdm._1.GetOperationMetrics;
import easierbsm.petalslink.com.data.wsdm._1.GetOperationMetricsResponse;
import easierbsm.petalslink.com.data.wsdm._1.ObjectFactory;
import easierbsm.petalslink.com.data.wsdm._1.SetOperationMetrics;
import easierbsm.petalslink.com.data.wsdm._1.SetOperationMetricsResponse;
import easybox.org.oasis_open.docs.wsdm.mows_2.EJaxbOperationMetricType;
import easybox.petalslink.com.esrawreport._1.EJaxbReportListType;
import java.net.URL;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Binding;
import org.petalslink.abslayer.service.api.Description;
import org.w3c.dom.Document;

public class WSDMProviderEndpointBehaviourImpl
extends AbstractEndpointBehaviourImpl
implements WSDMProviderEndpointBehaviour {
    private static Logger log = Logger.getLogger(WSDMProviderEndpointBehaviourImpl.class.getName());
    private MetricsBuilder metricsBuilder;

    public WSDMProviderEndpointBehaviourImpl(ProviderEndpoint<?> ep) {
        super(ep);
        try {
            URL url = Thread.currentThread().getContextClassLoader().getResource("wsdl/wsdm10.wsdl");
            Description desc = (Description)Factory.getInstance().wrap(((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasierBSMFramework.getInstance()).get()).readDocument(url, Definitions.class));
            this.setBinding((Binding)desc.getBindings().iterator().next());
            try {
                SOAJAXBContext.getInstance().addOtherObjectFactory(new Class[]{ObjectFactory.class});
            }
            catch (SOAException e) {
                e.printStackTrace();
                throw new RuntimeException();
            }
            this.metricsBuilder = new MetricsBuilder(ep);
        }
        catch (XmlObjectReadException e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    public void execute(Exchange exchange) throws TransportException {
        try {
            log.finest("WSDMHandlerEndpointBehaviour FOUND: " + exchange.getOperation());
            if (QName.valueOf(exchange.getOperation()).getLocalPart().equals("setOperationMetrics") && QName.valueOf(exchange.getOperation()).getNamespaceURI().equals("http://com.petalslink.easierbsm/service/wsdm/1.0")) {
                log.finest("setOperationMetrics");
                SetOperationMetrics request = (SetOperationMetrics)SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), SetOperationMetrics.class);
                SetOperationMetricsResponse response = this.setOperationMetrics(request);
                MessageUtil.getInstance().createOutMessageStructure(exchange);
                exchange.getMessageOut().getBody().setPayload(SOAJAXBContext.getInstance().unmarshallAnyElement((Object)response));
            } else if (QName.valueOf(exchange.getOperation()).getLocalPart().equals("getOperationMetrics") && QName.valueOf(exchange.getOperation()).getNamespaceURI().equals("http://com.petalslink.easierbsm/service/wsdm/1.0")) {
                log.finest("getOperationMetrics");
                GetOperationMetrics request = (GetOperationMetrics)SOAJAXBContext.getInstance().marshallAnyType(exchange.getMessageIn().getBody().getPayload(), GetOperationMetrics.class);
                GetOperationMetricsResponse response = this.getOperationMetrics(request);
                MessageUtil.getInstance().createOutMessageStructure(exchange);
                exchange.getMessageOut().getBody().setPayload(SOAJAXBContext.getInstance().unmarshallAnyElement((Object)response));
            } else if (QName.valueOf(exchange.getOperation()).getLocalPart().equals("Notify")) {
                log.info("NOTIFY");
                Notify notify = Wsnb4ServUtils.getWsnbReader().readNotify(exchange.getMessageIn().getBody().getPayload());
                this.notify(notify);
            }
        }
        catch (SOAException e) {
            log.severe("ERROR IN WSDMHandlerEndpointBehaviour BEHAVIOUR: " + e.getMessage());
            throw new TransportException((Throwable)e);
        }
        catch (WsnbException e) {
            log.severe("ERROR IN WSDMHandlerEndpointBehaviour BEHAVIOUR: " + e.getMessage());
            throw new TransportException((Throwable)e);
        }
    }

    public GetOperationMetricsResponse getOperationMetrics(GetOperationMetrics parameters) {
        GetOperationMetricsResponse res = new GetOperationMetricsResponse();
        OperationMetrics metrics = ((WSDMProviderEndpoint)this.endpoint).getOperationMetricsMap().get(parameters.getOperationQName());
        if (metrics != null) {
            res.setOperationMetrics((EJaxbOperationMetricType)metrics.getModelObject());
        }
        return res;
    }

    public SetOperationMetricsResponse setOperationMetrics(SetOperationMetrics parameters) {
        SetOperationMetricsResponse res = new SetOperationMetricsResponse();
        OperationMetrics metrics = (OperationMetrics)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().wrap((Object)parameters.getOperationMetrics(), OperationMetrics.class);
        ((WSDMProviderEndpoint)this.endpoint).getOperationMetricsMap().put(new QName(metrics.getPortType().getNamespaceURI(), metrics.getOperationName()), metrics);
        return res;
    }

    public void notify(Notify notify) throws WsnbException {
        try {
            Document notifPayload = DOMUtil.getInstance().createDocumentFromElement(((NotificationMessageHolderType)notify.getNotificationMessage().get(0)).getMessage().getAny());
            ReportList reportList = (ReportList)((XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasierBSMFramework.getInstance()).get()).readDocument(notifPayload, ReportList.class);
            this.metricsBuilder.addNewReportList((EJaxbReportListType)reportList.getModelObject());
        }
        catch (ParserConfigurationException e) {
            throw new WsnbException((Throwable)e);
        }
        catch (XmlObjectReadException e) {
            throw new WsnbException((Throwable)e);
        }
    }
}

