/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.thread;

import com.ebmwebsourcing.easierbsm.contant.EasierBSMFramework;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMMonitoringEngine;
import com.ebmwebsourcing.easierbsm.wsdm.monitoring.core.api.WSDMProviderEndpoint;
import com.ebmwebsourcing.easybox.api.XmlObject;
import com.ebmwebsourcing.easybox.api.XmlObjectNode;
import com.ebmwebsourcing.easybox.api.XmlObjectWriteException;
import com.ebmwebsourcing.easybox.api.XmlObjectWriter;
import com.ebmwebsourcing.easybox.api.XmlObjectXPathEvaluator;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easycommons.research.util.esb.QueryParam;
import com.ebmwebsourcing.easycommons.xml.DocumentBuilders;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easyesb.exchange10.api.ExchangeException;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Body;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Exchange;
import com.ebmwebsourcing.easyesb.exchange10.api.element.Header;
import com.ebmwebsourcing.easyesb.exchange10.api.element.MessageError;
import com.ebmwebsourcing.easyesb.exchange10.api.type.PatternType;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.ClientEndpoint;
import com.ebmwebsourcing.easyesb.soa.api.endpoint.Endpoint;
import com.ebmwebsourcing.easyesb.soa.api.util.MessageUtil;
import com.ebmwebsourcing.easyesb.transporter.api.transport.TransportException;
import com.ebmwebsourcing.easyschema10.api.type.Type;
import com.ebmwebsourcing.wsdm10.api.element.LastRequestSize;
import com.ebmwebsourcing.wsdm10.api.element.LastResponseSize;
import com.ebmwebsourcing.wsdm10.api.element.LastResponseTime;
import com.ebmwebsourcing.wsdm10.api.element.MaxRequestSize;
import com.ebmwebsourcing.wsdm10.api.element.MaxResponseSize;
import com.ebmwebsourcing.wsdm10.api.element.MaxResponseTime;
import com.ebmwebsourcing.wsdm10.api.element.NumberOfFailedRequests;
import com.ebmwebsourcing.wsdm10.api.element.NumberOfRequests;
import com.ebmwebsourcing.wsdm10.api.element.NumberOfSuccessfulRequests;
import com.ebmwebsourcing.wsdm10.api.element.OperationMetrics;
import com.ebmwebsourcing.wsdm10.api.element.ServiceTime;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Interface;
import org.petalslink.abslayer.service.api.Operation;
import org.petalslink.abslayer.service.api.Service;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BusinessMonitoringThread
extends Thread {
    private Logger log = Logger.getLogger(this.getClass().getCanonicalName());
    private static long sleep = 30000L;
    private static long timeout = 2000L;
    private Map<String, Document> monitoredOperations = new HashMap<String, Document>();
    private URI functionalEndpoint = null;
    private Endpoint wsdmEndpoint = null;
    private QName sourceNodeQName = null;
    private boolean finished = false;
    private List<QName> monitoredOperationsQName = new ArrayList<QName>();
    private WSDMMonitoringEngine parent;
    private DocumentBuilder documentBuilder;

    protected void finalize() throws Throwable {
        super.finalize();
        DocumentBuilders.releaseDocumentBuilder((DocumentBuilder)this.documentBuilder);
    }

    public BusinessMonitoringThread(URI functionalEndpoint, Endpoint wsdmEndpoint, QName sourceNodeQName, List<QName> operations, WSDMMonitoringEngine parent) {
        this.log.finest("New BusinessMonitoringThread " + this.getId() + " for " + functionalEndpoint + " " + wsdmEndpoint.getName() + " " + sourceNodeQName + " " + operations);
        this.functionalEndpoint = functionalEndpoint;
        this.wsdmEndpoint = wsdmEndpoint;
        this.sourceNodeQName = sourceNodeQName;
        this.monitoredOperationsQName = operations;
        this.parent = parent;
        this.init();
        this.documentBuilder = DocumentBuilders.takeDocumentBuilder();
    }

    @Override
    public void run() {
        if (this.wsdmEndpoint != null) {
            this.log.finest("init finished ... operations to be monitored : " + this.monitoredOperationsQName.toArray(new QName[this.monitoredOperationsQName.size()]));
            while (!this.finished && this.parent != null) {
                this.execute();
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException e) {
                    this.stopExecution();
                    throw new RuntimeException("BusinessMonitoringThread failed to fall asleep ... " + sleep);
                }
            }
        }
    }

    private void init() {
        this.log.finest("Business monitoring init for thread " + this.getId());
        Description d = ((WSDMProviderEndpoint)this.wsdmEndpoint).getFunctionalDescription();
        for (Interface i : d.getInterfaces()) {
            Operation[] operationArray = i.getOperations();
            int n = operationArray.length;
            int n2 = 0;
            while (n2 < n) {
                Operation o = operationArray[n2];
                if (o.getInput().getElement() != null) {
                    Type type = null;
                    try {
                        type = o.getInput().getElement().findType();
                        XmlObjectXPathEvaluator xpathEvaluator = type.getXmlContext().createXPathEvaluator();
                        XmlObjectNode obj = xpathEvaluator.selectSingleXmlObjectNode((XmlObject)o.getInput().getElement(), "//*[@name='" + o.getInput().getElement().getName() + "']/*[local-name()='complexType']/*[local-name()='sequence']/*[local-name()='element']", XmlObjectNode.class);
                        if (obj == null) {
                            this.monitoredOperationsQName.add(new QName(i.getQName().getNamespaceURI(), o.getName()));
                        }
                    }
                    catch (Exception e) {
                        this.monitoredOperationsQName.add(new QName(i.getQName().getNamespaceURI(), o.getName()));
                    }
                } else {
                    this.monitoredOperationsQName.add(new QName(i.getQName().getNamespaceURI(), o.getName()));
                }
                ++n2;
            }
        }
    }

    private void execute() {
        this.log.finest("new Business Monitoring loop ...");
        try {
            for (QName op : this.monitoredOperationsQName) {
                Document doc;
                OperationMetrics metrics;
                this.log.finest("business monitoring of operation " + op);
                Exchange exchange = ((ClientEndpoint)this.wsdmEndpoint).createExchange();
                MessageUtil.getInstance().createInMessageStructure(exchange);
                Header h = (Header)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().create(Header.class);
                exchange.getMessageIn().setHeader(h);
                Description desc = ((WSDMProviderEndpoint)this.wsdmEndpoint).getFunctionalDescription();
                Interface itf = null;
                Operation o = null;
                for (Interface i : desc.getInterfaces()) {
                    Operation[] operations = i.getOperations();
                    boolean found = false;
                    int j = 0;
                    while (j < operations.length) {
                        if (operations[j].inferQName().equals(op)) {
                            found = true;
                            o = operations[j];
                            break;
                        }
                        ++j;
                    }
                    if (!found) continue;
                    itf = i;
                    break;
                }
                if (itf != null && ((WSDMProviderEndpoint)this.wsdmEndpoint).getFunctionalDescription().findServicesImplementingInterface(itf).size() > 0) {
                    exchange.setServiceName(((Service)((WSDMProviderEndpoint)this.wsdmEndpoint).getFunctionalDescription().findServicesImplementingInterface(itf).get(0)).getQName());
                    exchange.setInterfaceName(itf.getQName());
                    exchange.setOperation(op.toString());
                    exchange.setDestinationReference(this.functionalEndpoint);
                    exchange.setPattern(PatternType.IN_OUT);
                    URI epr = ESBUtil.generateURI((EndpointAddress)new EndpointAddress(this.sourceNodeQName, null, new QueryParam[0]));
                    exchange.setSourceReference(epr);
                    Document input = this.documentBuilder.newDocument();
                    Element root = input.createElementNS(o.getInput().getMessageName().getNamespaceURI(), o.getInput().getMessageName().getLocalPart());
                    input.appendChild(root);
                    exchange.getMessageIn().getBody().setPayload(input);
                    this.log.finest("Business monitoring : going to send to op " + op + " with payload\n" + XMLPrettyPrinter.prettyPrint((Document)input));
                    ((ClientEndpoint)this.wsdmEndpoint).sendSync(exchange, 30000L);
                }
                if (exchange.getMessageOut().hasBody() && exchange.getMessageOut().getBody().hasPayload()) {
                    this.log.finest("Business monitoring : soap response\n" + XMLPrettyPrinter.prettyPrint((Document)exchange.getMessageOut().getBody().getPayload()));
                    this.monitoredOperations.put(op.getLocalPart(), exchange.getMessageOut().getBody().getPayload());
                    metrics = ((WSDMProviderEndpoint)this.wsdmEndpoint).getOperationMetricsMap().get(op);
                    this.log.finest("Business monitoring : metrics " + metrics);
                    if (metrics == null) {
                        this.log.warning("Business monitoring : new metrics for " + op);
                        metrics = this.createQosMetrics(op.getLocalPart(), itf.getQName());
                    }
                    metrics.clearAnyXmlObjects();
                    metrics.addAnyXmlObject((XmlObject)exchange.getMessageOut().getBody());
                    try {
                        doc = this.documentBuilder.newDocument();
                        ((XmlObjectWriter)SOAUtil.getInstance().getWriter((Framework)EasierBSMFramework.getInstance()).get()).writeDocument((XmlObject)metrics, (Node)doc);
                        this.log.finest("Business monitoring : Metrics as dom : \n" + XMLPrettyPrinter.prettyPrint((Document)doc));
                    }
                    catch (XmlObjectWriteException e) {
                        e.printStackTrace();
                        this.log.severe("Business Monitoring : " + e.getLocalizedMessage());
                    }
                    ((WSDMProviderEndpoint)this.wsdmEndpoint).getOperationMetricsMap().put(op, metrics);
                    continue;
                }
                this.log.warning("Business monitoring : soap fault\n" + XMLPrettyPrinter.prettyPrint((Document)exchange.getMessageError().getBody().getPayload()));
                if (exchange.getMessageError() == null) {
                    MessageUtil.getInstance().createErrorMessageStructure(exchange);
                    MessageError value = (MessageError)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().create(MessageError.class);
                    Body body = (Body)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().create(Body.class);
                    Document doc2 = this.documentBuilder.newDocument();
                    Element root = doc2.createElement("WSError");
                    root.setNodeValue("NON_RESPONDING_SERVICE");
                    doc2.appendChild(root);
                    body.setPayload(doc2);
                    value.setBody(body);
                    exchange.setMessageError(value);
                }
                this.monitoredOperations.put(op.getLocalPart(), exchange.getMessageError().printMessage());
                metrics = ((WSDMProviderEndpoint)this.wsdmEndpoint).getOperationMetricsMap().get(op);
                if (metrics == null) {
                    metrics = this.createQosMetrics(op.getLocalPart(), itf.getQName());
                }
                metrics.clearAnyXmlObjects();
                metrics.addAnyXmlObject((XmlObject)exchange.getMessageError());
                try {
                    doc = this.documentBuilder.newDocument();
                    ((XmlObjectWriter)SOAUtil.getInstance().getWriter((Framework)EasierBSMFramework.getInstance()).get()).writeDocument((XmlObject)metrics, (Node)doc);
                    this.log.finest("Business monitoring : Metrics FAULT as dom : \n" + XMLPrettyPrinter.prettyPrint((Document)doc));
                }
                catch (XmlObjectWriteException e) {
                    e.printStackTrace();
                    this.log.severe("Business Monitoring : " + e.getLocalizedMessage());
                }
                ((WSDMProviderEndpoint)this.wsdmEndpoint).getOperationMetricsMap().put(op, metrics);
            }
        }
        catch (TransportException e) {
            e.printStackTrace();
        }
        catch (ExchangeException e) {
            e.printStackTrace();
        }
    }

    public void stopExecution() {
        this.finished = true;
    }

    public static long getSleep() {
        return sleep;
    }

    public static void setSleep(long sleep) {
        BusinessMonitoringThread.sleep = sleep;
    }

    private OperationMetrics createQosMetrics(String operationName, QName itfName) {
        OperationMetrics metrics = (OperationMetrics)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().create(OperationMetrics.class);
        ServiceTime serviceTime = (ServiceTime)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().create(ServiceTime.class);
        MaxResponseTime maxResponseTime = (MaxResponseTime)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().create(MaxResponseTime.class);
        LastResponseTime lastResponseTime = (LastResponseTime)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().create(LastResponseTime.class);
        NumberOfSuccessfulRequests numberOfSuccessfulRequests = (NumberOfSuccessfulRequests)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().create(NumberOfSuccessfulRequests.class);
        NumberOfRequests numberOfRequests = (NumberOfRequests)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().create(NumberOfRequests.class);
        NumberOfFailedRequests numberOfFailedRequests = (NumberOfFailedRequests)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().create(NumberOfFailedRequests.class);
        MaxRequestSize maxRequestSize = (MaxRequestSize)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().create(MaxRequestSize.class);
        MaxResponseSize maxResponseSize = (MaxResponseSize)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().create(MaxResponseSize.class);
        LastRequestSize lastRequestSize = (LastRequestSize)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().create(LastRequestSize.class);
        LastResponseSize lastResponseSize = (LastResponseSize)SOAUtil.getInstance().getXmlContext((Framework)EasierBSMFramework.getInstance()).getXmlObjectFactory().create(LastResponseSize.class);
        metrics.setOperationName(operationName);
        metrics.setPortType(itfName);
        metrics.setServiceTime(serviceTime);
        metrics.setMaxResponseTime(maxResponseTime);
        metrics.setLastResponseTime(lastResponseTime);
        metrics.setNumberOfSuccessfulRequests(numberOfSuccessfulRequests);
        metrics.setNumberOfRequests(numberOfRequests);
        metrics.setNumberOfFailedRequests(numberOfFailedRequests);
        metrics.setMaxRequestSize(maxRequestSize);
        metrics.setMaxResponseSize(maxResponseSize);
        metrics.setLastRequestSize(lastRequestSize);
        metrics.setLastResponseSize(lastResponseSize);
        return metrics;
    }
}

