/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiergov.usdl.convertor;

import com.ebmwebsourcing.easywsdl11.api.element.Binding;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.easywsdl11.api.element.Operation;
import com.ebmwebsourcing.easywsdl11.api.element.Port;
import com.ebmwebsourcing.easywsdl11.api.element.PortType;
import com.ebmwebsourcing.easywsdl11.api.element.Service;
import com.petalslink.easiergov.usdl.USDLException;
import com.petalslink.usdl_model._1.ServiceType;
import com.petalslink.usdl_model._1.TechnicalInterfaceType;
import com.petalslink.usdl_model._1.TechnicalOperationType;
import javax.xml.namespace.QName;

public class Wsdl11ToUSDL {
    public static ServiceType getServiceFromWSDL11Service(Service serv11) throws USDLException {
        ServiceType res = new ServiceType();
        res.setId(serv11.inferQName().toString());
        res.setName(serv11.getName());
        Definitions wsdl11def = (Definitions)serv11.getXmlObjectRoot();
        for (Port ep : serv11.getPorts()) {
            Binding b = wsdl11def.getBindingByName(ep.getBinding().getLocalPart());
            if (b == null) {
                throw new USDLException("Impossible to find binding " + ep.getBinding() + " in definitions " + wsdl11def.getName());
            }
            PortType itf = wsdl11def.getPortTypeByName(b.getType().getLocalPart());
            if (itf == null) {
                throw new USDLException("Impossible to find portType " + b.getType() + " in definitions " + wsdl11def.getName());
            }
            TechnicalInterfaceType tit = Wsdl11ToUSDL.getTechnicalInterfaceFromWSDL11PortType(QName.valueOf(res.getId()), itf);
            res.getTechnicalInterface().add(tit);
        }
        return res;
    }

    public static TechnicalInterfaceType getTechnicalInterfaceFromWSDL11PortType(QName idService, PortType itf) throws USDLException {
        TechnicalInterfaceType res = new TechnicalInterfaceType();
        Definitions wsdl11def = (Definitions)itf.getXmlObjectRoot();
        res.setId(new QName(wsdl11def.getTargetNamespace(), itf.getName()).toString());
        res.setName(itf.getName());
        res.setIdService(idService.toString());
        for (Operation op : itf.getOperations()) {
            TechnicalOperationType top = Wsdl11ToUSDL.getTechnicalOperationFromWSDL11Operation(res, op);
        }
        return res;
    }

    public static TechnicalOperationType getTechnicalOperationFromWSDL11Operation(TechnicalInterfaceType usdlItf, Operation op) {
        return null;
    }
}

