/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
/**
 * EasyESB: EasyESB Services Platform Copyright (C) 2009 EBM WebSourcing
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 * 
 * Initial developer(s): EBM WebSourcing
 */
package com.petalslink.easiergov.core.config;

import java.util.Map;



/**
 * @author chamerling - eBM WebSourcing
 * 
 */
public interface Configuration {
    
    public static final String NAME = "name";
    public static final String DEFAULT_NAME = "governace";

    public static final String NAMESPACE = "namespace";
    public static final String DEFAULT_NAMESPACE = "http://com.petalslink.easiergov/";


	public static final String PORT = "port";
	public static final String DEFAULT_PORT = "9600";

	public static final String HOST = "host";
	public static final String DEFAULT_HOST = "localhost";
	
	
	public static final String NOTIFICATION_PORT = "9601";
	public static final String DEFAULT_NOTIFICATION_PORT = "9601";

	
	public static final String EASIERSBS_SYNTACTIC_ACCEPTANCE_THRESHOLD = "easiersbs.syntactic.acceptance.threshold";
	public static final String DEFAULT_EASIERSBS_SYNTACTIC_ACCEPTANCE_THRESHOLD = "0.1";
	
	public static final String EASIERSBS_SYNTACTIC_LEVENSHTEIN_LIMIT = "easiersbs.syntactic.levenshtein.limit";
	public static final String DEFAULT_EASIERSBS_SYNTACTIC_LEVENSHTEIN_LIMIT = "2";
	
	public static final String EASIERSBS_SYNTACTIC_SIMILARITY_TYPE = "easiersbs.syntactic.similarity.type";
	public static final String DEFAULT_EASIERSBS_SYNTACTIC_SIMILARITY_TYPE = "jaccard";

	/**
	 * @return the data
	 */
	Map<String, String> getProperties();

	void addProperty(String key, String value);
	
	String getName();

    void setName(String name);
    
    String getNamespace();

    void setNamespace(String namespace);

	Integer getPort();

	void setPort(int port);

	String getHost();

	void setHost(String host);

	Integer getNotificationPort();
	
	void setNotificationPort(int addr);
	
}
