/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiergov.data;

import com.ebmwebsourcing.easybox.impl.AbstractXmlObjectNodeImpl;
import com.petalslink.data_api._1.Fault;
import com.petalslink.data_api._1.FindComplexTypes;
import com.petalslink.data_api._1.FindComplexTypesResponse;
import com.petalslink.data_api._1.FindElements;
import com.petalslink.data_api._1.FindElementsResponse;
import com.petalslink.data_api._1.FindSimpleTypes;
import com.petalslink.data_api._1.FindSimpleTypesResponse;
import com.petalslink.data_api._1.GetComplexType;
import com.petalslink.data_api._1.GetComplexTypeResponse;
import com.petalslink.data_api._1.GetElement;
import com.petalslink.data_api._1.GetElementResponse;
import com.petalslink.data_api._1.GetSimpleType;
import com.petalslink.data_api._1.GetSimpleTypeResponse;
import com.petalslink.data_api._1.PublishSchema;
import com.petalslink.data_api._1.PublishSchemaResponse;
import com.petalslink.data_api._1_0.DataManager;
import com.petalslink.data_api._1_0.FaultMessage;
import com.petalslink.easiergov.data.ComplexTypeResourceType;
import com.petalslink.easiergov.data.ElementResourceType;
import com.petalslink.easiergov.data.SimpleTypeResourceType;
import com.petalslink.easiergov.resources.ResourcesManagerImpl;
import com.petalslink.easiergov.resources.api.Resource;
import com.petalslink.easiergov.resources.api.ResourceType;
import com.petalslink.resources_api._1.Criteria;
import com.petalslink.resources_api._1.Find;
import com.petalslink.resources_api._1.FindResponse;
import com.petalslink.resources_api._1.Publish;
import com.petalslink.resources_api._1.PublishResponse;
import com.petalslink.resources_api._1.ResourceIdentifier;
import com.petalslink.resources_api._1_0.FindFault;
import com.petalslink.resources_api._1_0.PublishFault;
import com.petalslink.resources_api._1_0.ResourcesManager;
import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbResourceIdentifier;
import easybox.org.w3._2001.xmlschema.EJaxbSchema;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.jws.WebService;

@WebService(serviceName="DataManager", portName="DataManagerPort", targetNamespace="http://www.petalslink.com/data-api/1.0", wsdlLocation="services-ws.wsdl", endpointInterface="com.petalslink.data_api._1_0.DataManager")
public class DataManagerImpl
implements DataManager {
    private static Logger LOG = Logger.getLogger(DataManagerImpl.class.getName());
    private ResourcesManager resourceManager;

    public DataManagerImpl(ResourcesManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public PublishSchemaResponse publishSchema(PublishSchema parameters) throws FaultMessage {
        PublishSchemaResponse res = new PublishSchemaResponse();
        try {
            Publish request = new Publish();
            request.setRessourceUrl(parameters.getXsdUrl());
            PublishResponse response = this.resourceManager.publish(request);
            if (response != null) {
                for (ResourceIdentifier rid : response.getResourceIdentifier()) {
                    EJaxbResourceIdentifier rids = new EJaxbResourceIdentifier();
                    rids.setId(rid.getId());
                    rids.setResourceType(rid.getResourceType());
                    res.getResourceIdentifier().add(rids);
                }
            }
        }
        catch (PublishFault e) {
            FaultMessage businessFault = new FaultMessage();
            FaultMessage faultError = new FaultMessage(e.getMessage(), (Throwable)businessFault);
            if (faultError.getFaultInfo() != null) {
                faultError.getFaultInfo().setMessage(e.getMessage());
            }
            throw faultError;
        }
        return res;
    }

    public GetElementResponse getElement(GetElement parameters) throws FaultMessage {
        EJaxbSchema schema = null;
        LOG.fine("Call getElement method");
        Resource r = ((ResourcesManagerImpl)this.resourceManager).get(parameters.getIdElement(), (ResourceType)ElementResourceType.getInstance());
        if (r == null) {
            String errorMsg = "Impossible to find element corresponding to this id: " + parameters.getIdElement();
            Fault f = new Fault();
            f.setMessage(errorMsg);
            FaultMessage faultError = new FaultMessage(errorMsg, f);
            throw faultError;
        }
        schema = (EJaxbSchema)((AbstractXmlObjectNodeImpl)r.getContent()).getModelObject();
        GetElementResponse response = new GetElementResponse();
        response.setAny((Object)schema);
        return response;
    }

    public GetComplexTypeResponse getComplexType(GetComplexType parameters) throws FaultMessage {
        EJaxbSchema schema = null;
        LOG.fine("Call getComplexType method");
        Resource r = ((ResourcesManagerImpl)this.resourceManager).get(parameters.getIdComplexType(), (ResourceType)ComplexTypeResourceType.getInstance());
        if (r == null) {
            String errorMsg = "Impossible to find complexType corresponding to this id: " + parameters.getIdComplexType();
            Fault f = new Fault();
            f.setMessage(errorMsg);
            FaultMessage faultError = new FaultMessage(errorMsg, f);
            throw faultError;
        }
        schema = (EJaxbSchema)((AbstractXmlObjectNodeImpl)r.getContent()).getModelObject();
        GetComplexTypeResponse response = new GetComplexTypeResponse();
        response.setAny((Object)schema);
        return response;
    }

    public GetSimpleTypeResponse getSimpleType(GetSimpleType parameters) throws FaultMessage {
        EJaxbSchema schema = null;
        LOG.fine("Call getComplexType method");
        Resource r = ((ResourcesManagerImpl)this.resourceManager).get(parameters.getIdSimpleType(), (ResourceType)SimpleTypeResourceType.getInstance());
        if (r == null) {
            String errorMsg = "Impossible to find simpleType corresponding to this id: " + parameters.getIdSimpleType();
            Fault f = new Fault();
            f.setMessage(errorMsg);
            FaultMessage faultError = new FaultMessage(errorMsg, f);
            throw faultError;
        }
        schema = (EJaxbSchema)((AbstractXmlObjectNodeImpl)r.getContent()).getModelObject();
        GetSimpleTypeResponse response = new GetSimpleTypeResponse();
        response.setAny((Object)schema);
        return response;
    }

    public FindElementsResponse findElements(FindElements parameters) throws FaultMessage {
        ArrayList<EJaxbSchema> schemas = new ArrayList<EJaxbSchema>();
        LOG.fine("Call findElements method");
        try {
            Criteria c = new Criteria();
            c.setName("resource-type");
            c.setValue(ElementResourceType.getInstance().getTypeName());
            Find f = new Find();
            f.setQuery(parameters.getQuery());
            f.getCriteria().add(c);
            FindResponse fr = this.resourceManager.find(f);
            for (Object obj : fr.getAny()) {
                schemas.add((EJaxbSchema)((AbstractXmlObjectNodeImpl)obj).getModelObject());
            }
        }
        catch (FindFault e) {
            FaultMessage businessFault = new FaultMessage();
            FaultMessage faultError = new FaultMessage(e.getMessage(), (Throwable)businessFault);
            if (faultError.getFaultInfo() != null) {
                faultError.getFaultInfo().setMessage(e.getMessage());
            }
            throw faultError;
        }
        FindElementsResponse response = new FindElementsResponse();
        response.getAny().addAll(schemas);
        return response;
    }

    public FindComplexTypesResponse findComplexTypes(FindComplexTypes parameters) throws FaultMessage {
        ArrayList<EJaxbSchema> schemas = new ArrayList<EJaxbSchema>();
        LOG.fine("Call findComplexTypes method");
        try {
            Criteria c = new Criteria();
            c.setName("resource-type");
            c.setValue(ComplexTypeResourceType.getInstance().getTypeName());
            Find f = new Find();
            f.setQuery(parameters.getQuery());
            f.getCriteria().add(c);
            FindResponse fr = this.resourceManager.find(f);
            for (Object obj : fr.getAny()) {
                schemas.add((EJaxbSchema)((AbstractXmlObjectNodeImpl)obj).getModelObject());
            }
        }
        catch (FindFault e) {
            FaultMessage businessFault = new FaultMessage();
            FaultMessage faultError = new FaultMessage(e.getMessage(), (Throwable)businessFault);
            if (faultError.getFaultInfo() != null) {
                faultError.getFaultInfo().setMessage(e.getMessage());
            }
            throw faultError;
        }
        FindComplexTypesResponse response = new FindComplexTypesResponse();
        response.getAny().addAll(schemas);
        return response;
    }

    public FindSimpleTypesResponse findSimpleTypes(FindSimpleTypes parameters) throws FaultMessage {
        ArrayList<EJaxbSchema> schemas = new ArrayList<EJaxbSchema>();
        LOG.fine("Call findSimpleTypes method");
        try {
            Criteria c = new Criteria();
            c.setName("resource-type");
            c.setValue(SimpleTypeResourceType.getInstance().getTypeName());
            Find f = new Find();
            f.setQuery(parameters.getQuery());
            f.getCriteria().add(c);
            FindResponse fr = this.resourceManager.find(f);
            for (Object obj : fr.getAny()) {
                schemas.add((EJaxbSchema)((AbstractXmlObjectNodeImpl)obj).getModelObject());
            }
        }
        catch (FindFault e) {
            FaultMessage businessFault = new FaultMessage();
            FaultMessage faultError = new FaultMessage(e.getMessage(), (Throwable)businessFault);
            if (faultError.getFaultInfo() != null) {
                faultError.getFaultInfo().setMessage(e.getMessage());
            }
            throw faultError;
        }
        FindSimpleTypesResponse response = new FindSimpleTypesResponse();
        response.getAny().addAll(schemas);
        return response;
    }
}

