package com.petalslink.easiergov.data;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

import javax.xml.namespace.QName;

import org.petalslink.abslayer.Factory;
import org.petalslink.abslayer.service.api.Description;
import org.petalslink.abslayer.service.api.Endpoint;
import org.w3c.dom.Document;

import com.ebmwebsourcing.easiergov.contant.EasierGOVFramework;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.ESBUtil;
import com.ebmwebsourcing.easycommons.research.util.esb.EndpointAddress;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easycommons.xml.resolver.ClasspathURIResolver;
import com.ebmwebsourcing.easycommons.xml.resolver.DefaultURIResolver;
import com.ebmwebsourcing.easycommons.xml.resolver.URIMultipleResolvers;
import com.ebmwebsourcing.easyschema10.api.element.ComplexType;
import com.ebmwebsourcing.easyschema10.api.element.Element;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import com.ebmwebsourcing.easyschema10.api.element.SimpleType;
import com.ebmwebsourcing.easywsdl11.api.element.Definitions;
import com.ebmwebsourcing.easywsdl11.api.element.Port;
import com.ebmwebsourcing.easywsdl11.api.element.PortType;
import com.ebmwebsourcing.easywsdl11.api.element.Service;
import com.petalslink.easiergov.GovException;
import com.petalslink.easiergov.data.resolver.EasyESBURIResolver;
import com.petalslink.easiergov.resources.ResourceImpl;
import com.petalslink.easiergov.resources.api.AbstractResourceAnalyzerService;
import com.petalslink.easiergov.resources.api.Resource;
import com.petalslink.easiergov.resources.api.ResourceAnalyzerService;

public class SchemaResourceAnalyzerServiceImpl extends AbstractResourceAnalyzerService implements ResourceAnalyzerService {


	private static Logger LOG = Logger.getLogger(SchemaResourceAnalyzerServiceImpl.class.getName());

	private static EasyESBURIResolver resolver = new EasyESBURIResolver();

	public SchemaResourceAnalyzerServiceImpl() {
		super();
		this.types.add(SimpleTypeResourceType.getInstance());
		this.types.add(ComplexTypeResourceType.getInstance());
		this.types.add(ElementResourceType.getInstance());

		SOAUtil.getInstance().getXmlContext(EasierGOVFramework.getInstance()).setURIResolver(new URIMultipleResolvers(new DefaultURIResolver(), new ClasspathURIResolver(), resolver));
	}

	@SuppressWarnings("unchecked")
	@Override
	public List<Resource> analyse(Document doc, Map<String, Object> metadata) throws GovException {
		List<Resource> resources = new ArrayList<Resource>();

		try {
			Schema def = null;
			XmlObjectReader reader = SOAUtil.getInstance().getReader(EasierGOVFramework.getInstance()).get();

			synchronized (resolver) {
				resolver.setAddress((String) metadata.get("address"));
				List<String> esbNodes = (List<String>) metadata.get("esbNodes");
				if(esbNodes != null) {
					for(String node: esbNodes) {
						resolver.addEsbNodeAddress(node);
					}
				}

				String id = (String) metadata.get("resourceId");
				resolver.setEndpoint(id);

				def = reader.readDocument(doc, Schema.class);


				for(Element e: def.getElements()) {
					resources.add(new ResourceImpl(e.inferQName(), ElementResourceType.getInstance(), def));
				}
				for(SimpleType st: def.getSimpleTypes()) {
					resources.add(new ResourceImpl(st.inferQName(), SimpleTypeResourceType.getInstance(), def));
				}
				for(ComplexType ct: def.getComplexTypes()) {
					resources.add(new ResourceImpl(ct.inferQName(), ComplexTypeResourceType.getInstance(), def));
				}

				resolver.setEndpoint(null);
			}
		} catch (Throwable e) {
			// do nothing
			LOG.finest("Resource cannot be analysed by " + this.getClass().getSimpleName() +  ": \n" + XMLPrettyPrinter.prettyPrint(doc) + "\nMetadata = " + metadata);
		}


		return resources;
	}

	@Override
	public List<Resource> postAnalyse(Resource resource) throws GovException {
		return new ArrayList<Resource>();
	}


}
