/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiergov.data;

import com.ebmwebsourcing.easiergov.contant.EasierGOVFramework;
import com.ebmwebsourcing.easybox.api.XmlObjectReader;
import com.ebmwebsourcing.easycommons.research.util.easybox.Framework;
import com.ebmwebsourcing.easycommons.research.util.easybox.SOAUtil;
import com.ebmwebsourcing.easycommons.xml.XMLPrettyPrinter;
import com.ebmwebsourcing.easycommons.xml.resolver.ClasspathURIResolver;
import com.ebmwebsourcing.easycommons.xml.resolver.DefaultURIResolver;
import com.ebmwebsourcing.easycommons.xml.resolver.URIMultipleResolvers;
import com.ebmwebsourcing.easyschema10.api.element.Element;
import com.ebmwebsourcing.easyschema10.api.element.Schema;
import com.petalslink.easiergov.GovException;
import com.petalslink.easiergov.data.ComplexTypeResourceType;
import com.petalslink.easiergov.data.ElementResourceType;
import com.petalslink.easiergov.data.SimpleTypeResourceType;
import com.petalslink.easiergov.data.resolver.EasyESBURIResolver;
import com.petalslink.easiergov.resources.ResourceImpl;
import com.petalslink.easiergov.resources.api.AbstractResourceAnalyzerService;
import com.petalslink.easiergov.resources.api.Resource;
import com.petalslink.easiergov.resources.api.ResourceAnalyzerService;
import com.petalslink.easiergov.resources.api.ResourceType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.transform.URIResolver;
import org.w3c.dom.Document;

public class SchemaResourceAnalyzerServiceImpl
extends AbstractResourceAnalyzerService
implements ResourceAnalyzerService {
    private static Logger LOG = Logger.getLogger(SchemaResourceAnalyzerServiceImpl.class.getName());
    private static EasyESBURIResolver resolver = new EasyESBURIResolver();

    public SchemaResourceAnalyzerServiceImpl() {
        this.types.add(SimpleTypeResourceType.getInstance());
        this.types.add(ComplexTypeResourceType.getInstance());
        this.types.add(ElementResourceType.getInstance());
        SOAUtil.getInstance().getXmlContext((Framework)EasierGOVFramework.getInstance()).setURIResolver((URIResolver)new URIMultipleResolvers(new URIResolver[]{new DefaultURIResolver(), new ClasspathURIResolver(), resolver}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Resource> analyse(Document doc, Map<String, Object> metadata) throws GovException {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        try {
            Schema def = null;
            XmlObjectReader reader = (XmlObjectReader)SOAUtil.getInstance().getReader((Framework)EasierGOVFramework.getInstance()).get();
            EasyESBURIResolver easyESBURIResolver = resolver;
            synchronized (easyESBURIResolver) {
                resolver.setAddress((String)metadata.get("address"));
                List esbNodes = (List)metadata.get("esbNodes");
                if (esbNodes != null) {
                    for (String node : esbNodes) {
                        resolver.addEsbNodeAddress(node);
                    }
                }
                String id = (String)metadata.get("resourceId");
                resolver.setEndpoint(id);
                def = (Schema)reader.readDocument(doc, Schema.class);
                for (Element element : def.getElements()) {
                    resources.add((Resource)new ResourceImpl(element.inferQName(), (ResourceType)ElementResourceType.getInstance(), (Object)def));
                }
                for (Element element : def.getSimpleTypes()) {
                    resources.add((Resource)new ResourceImpl(element.inferQName(), (ResourceType)SimpleTypeResourceType.getInstance(), (Object)def));
                }
                for (Element element : def.getComplexTypes()) {
                    resources.add((Resource)new ResourceImpl(element.inferQName(), (ResourceType)ComplexTypeResourceType.getInstance(), (Object)def));
                }
                resolver.setEndpoint(null);
            }
        }
        catch (Throwable e) {
            LOG.finest("Resource cannot be analysed by " + ((Object)((Object)this)).getClass().getSimpleName() + ": \n" + XMLPrettyPrinter.prettyPrint((Document)doc) + "\nMetadata = " + metadata);
        }
        return resources;
    }

    public List<Resource> postAnalyse(Resource resource) throws GovException {
        return new ArrayList<Resource>();
    }
}

