package com.petalslink.easiergov.data;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

import org.w3c.dom.Document;
import org.w3c.dom.Node;

import com.ebmwebsourcing.easiergov.ServerImplementation;
import com.ebmwebsourcing.easybox.impl.AbstractXmlObjectNodeImpl;
import com.ebmwebsourcing.easycommons.research.util.SOAException;
import com.ebmwebsourcing.easycommons.research.util.dom.DOMUtil;
import com.ebmwebsourcing.easycommons.research.util.jaxb.SOAJAXBContext;
import com.petalslink.data_api._1.Fault;
import com.petalslink.data_api._1.FindComplexTypes;
import com.petalslink.data_api._1.FindComplexTypesResponse;
import com.petalslink.data_api._1.FindElements;
import com.petalslink.data_api._1.FindElementsResponse;
import com.petalslink.data_api._1.FindSimpleTypes;
import com.petalslink.data_api._1.FindSimpleTypesResponse;
import com.petalslink.data_api._1.GetComplexType;
import com.petalslink.data_api._1.GetComplexTypeResponse;
import com.petalslink.data_api._1.GetElement;
import com.petalslink.data_api._1.GetElementResponse;
import com.petalslink.data_api._1.GetSimpleType;
import com.petalslink.data_api._1.GetSimpleTypeResponse;
import com.petalslink.data_api._1.PublishSchemaFromDOM;
import com.petalslink.data_api._1.PublishSchemaFromDOMResponse;
import com.petalslink.data_api._1.PublishSchemaFromURL;
import com.petalslink.data_api._1.PublishSchemaFromURLResponse;
import com.petalslink.data_api._1_0.DataManager;
import com.petalslink.data_api._1_0.FaultMessage;
import com.petalslink.easiergov.resources.ResourcesManagerImpl;
import com.petalslink.easiergov.resources.api.Resource;
import com.petalslink.resources_api._1.Criteria;
import com.petalslink.resources_api._1.Find;
import com.petalslink.resources_api._1.FindResponse;
import com.petalslink.resources_api._1.Publish;
import com.petalslink.resources_api._1.PublishResponse;
import com.petalslink.resources_api._1.ResourceIdentifier;
import com.petalslink.resources_api._1_0.FindFault;
import com.petalslink.resources_api._1_0.PublishFault;
import com.petalslink.resources_api._1_0.ResourcesManager;

import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbResourceIdentifier;
import easybox.org.w3._2001.xmlschema.EJaxbSchema;

@javax.jws.WebService(
		serviceName = "DataManager",
		portName = "DataManagerPort",
		targetNamespace = "http://www.petalslink.com/data-api/1.0",
		wsdlLocation = "data-ws.wsdl",
		endpointInterface = "com.petalslink.data_api._1_0.DataManager")
public class DataManagerImpl implements DataManager, ServerImplementation {

	private static Logger LOG = Logger.getLogger(DataManagerImpl.class.getName());

	static {
		try {
			SOAJAXBContext.getInstance().addOtherObjectFactory(com.petalslink.data_api._1.ObjectFactory.class,
					easybox.org.w3._2001.xmlschema.ObjectFactory.class);
		} catch (SOAException e) {
			// do nothing
			e.printStackTrace();
		}
	}

	private ResourcesManager resourceManager;

	public DataManagerImpl(ResourcesManager resourceManager) {
		this.resourceManager = resourceManager;
	}

	@Override
	public PublishSchemaFromURLResponse publishSchemaFromURL(PublishSchemaFromURL parameters)
			throws com.petalslink.data_api._1_0.FaultMessage {
		LOG.info("publishSchemaFromURL: " + parameters.getXsdUrl());
		PublishSchemaFromURLResponse res = new PublishSchemaFromURLResponse();
		try {
			Publish request = new Publish();
			request.setRessourceUrl(parameters.getXsdUrl());
			PublishResponse response = resourceManager.publish(request);
			if(response != null) {
				for(ResourceIdentifier rid: response.getResourceIdentifier()) {
					EJaxbResourceIdentifier rids = new EJaxbResourceIdentifier();
					rids.setId(rid.getId());
					rids.setResourceType(rid.getResourceType());
					res.getResourceIdentifier().add(rids);
				}
			}
		} catch (PublishFault e) {
			FaultMessage businessFault = new FaultMessage();
			FaultMessage faultError = new FaultMessage(e.getMessage(), businessFault);
			if (faultError.getFaultInfo()!= null){
				faultError.getFaultInfo().setMessage(e.getMessage());
			}
			throw faultError;
		}
		return res;
	}
	
	@Override
	public PublishSchemaFromDOMResponse publishSchemaFromDOM(
			PublishSchemaFromDOM parameters) throws FaultMessage {
		LOG.info("publishSchemaFromDOM ");
		PublishSchemaFromDOMResponse res = new PublishSchemaFromDOMResponse();
		try {
			Document doc = DOMUtil.getInstance().getDocumentBuilderFactory().newDocumentBuilder().newDocument();
			doc.appendChild(doc.adoptNode((Node) parameters.getAny()));
			PublishResponse response = ((ResourcesManagerImpl)this.resourceManager).publish(doc, null);
			if(response != null) {
				for(ResourceIdentifier rid: response.getResourceIdentifier()) {
					EJaxbResourceIdentifier rids = new EJaxbResourceIdentifier();
					rids.setId(rid.getId());
					rids.setResourceType(rid.getResourceType());
					res.getResourceIdentifier().add(rids);
				}
			}
		} catch (Exception e) {
			FaultMessage businessFault = new FaultMessage();
			FaultMessage faultError = new FaultMessage(e.getMessage(), businessFault);
			if (faultError.getFaultInfo()!= null){
				faultError.getFaultInfo().setMessage(e.getMessage());
			}
			throw faultError;
		}
		return res;
	}

	@Override
	public GetElementResponse getElement(GetElement parameters)
			throws com.petalslink.data_api._1_0.FaultMessage {
		GetElementResponse response = null;
		EJaxbSchema schema = null;
		try {
			LOG.info("Call getElement method: " + parameters.getIdElement());
			System.out.println("resourceManager = " + ((ResourcesManagerImpl)resourceManager).getAllByResourceType(ElementResourceType.getInstance()));
			Resource r = ((ResourcesManagerImpl)resourceManager).get(parameters.getIdElement(), ElementResourceType.getInstance());
			if(r != null) {
				schema = (EJaxbSchema) ((AbstractXmlObjectNodeImpl)r.getContent()).getModelObject();
			} else {
				String errorMsg = "Impossible to find element corresponding to this id: " + parameters.getIdElement();
				Fault f = new Fault();
				f.setMessage(errorMsg);
				FaultMessage faultError = new FaultMessage(errorMsg, f);
				throw faultError;
			}
			response = new GetElementResponse();
			response.setAny(SOAJAXBContext.getInstance().unmarshallAnyElement(schema).getDocumentElement());
		} catch (SOAException e) {
			throw new FaultMessage(e.getMessage(), e);
		}
		return response;
	}

	@Override
	public GetComplexTypeResponse getComplexType(GetComplexType parameters)
			throws com.petalslink.data_api._1_0.FaultMessage {
		EJaxbSchema schema = null;
		LOG.fine("Call getComplexType method");
		Resource r = ((ResourcesManagerImpl)resourceManager).get(parameters.getIdComplexType(), ComplexTypeResourceType.getInstance());
		if(r != null) {
			schema = (EJaxbSchema) ((AbstractXmlObjectNodeImpl)r.getContent()).getModelObject();
		} else {
			String errorMsg = "Impossible to find complexType corresponding to this id: " + parameters.getIdComplexType();
			Fault f = new Fault();
			f.setMessage(errorMsg);
			FaultMessage faultError = new FaultMessage(errorMsg, f);
			throw faultError;
		}
		GetComplexTypeResponse response = new GetComplexTypeResponse();
		response.setAny(schema);
		return response;
	}

	@Override
	public GetSimpleTypeResponse getSimpleType(GetSimpleType parameters)
			throws com.petalslink.data_api._1_0.FaultMessage {
		EJaxbSchema schema = null;
		LOG.fine("Call getComplexType method");
		Resource r = ((ResourcesManagerImpl)resourceManager).get(parameters.getIdSimpleType(), SimpleTypeResourceType.getInstance());
		if(r != null) {
			schema = (EJaxbSchema) ((AbstractXmlObjectNodeImpl)r.getContent()).getModelObject();
		} else {
			String errorMsg = "Impossible to find simpleType corresponding to this id: " + parameters.getIdSimpleType();
			Fault f = new Fault();
			f.setMessage(errorMsg);
			FaultMessage faultError = new FaultMessage(errorMsg, f);
			throw faultError;
		}
		GetSimpleTypeResponse response = new GetSimpleTypeResponse();
		response.setAny(schema);
		return response;
	}

	@Override
	public FindElementsResponse findElements(FindElements parameters)
			throws com.petalslink.data_api._1_0.FaultMessage {
		List<EJaxbSchema> schemas = new ArrayList<EJaxbSchema>();
		LOG.info("Call findElements method");
		try {
			Criteria c = new Criteria();
			c.setName("resource-type");
			c.setValue(ElementResourceType.getInstance().getTypeName());
			Find f = new Find();
			f.setQuery(parameters.getQuery());
			f.getCriteria().add(c);
			FindResponse fr = resourceManager.find(f);
			for(Object obj: fr.getAny()) {
				schemas.add((EJaxbSchema)((AbstractXmlObjectNodeImpl)obj).getModelObject());
			}
		} catch (FindFault e) {
			FaultMessage businessFault = new FaultMessage();
			FaultMessage faultError = new FaultMessage(e.getMessage(), businessFault);
			if (faultError.getFaultInfo()!= null){
				faultError.getFaultInfo().setMessage(e.getMessage());
			}
			throw faultError;
		}
		FindElementsResponse response = new FindElementsResponse();
		response.getAny().addAll(schemas);
		return response;
	}

	@Override
	public FindComplexTypesResponse findComplexTypes(FindComplexTypes parameters)
			throws com.petalslink.data_api._1_0.FaultMessage {
		List<EJaxbSchema> schemas = new ArrayList<EJaxbSchema>();
		LOG.fine("Call findComplexTypes method");
		try {
			Criteria c = new Criteria();
			c.setName("resource-type");
			c.setValue(ComplexTypeResourceType.getInstance().getTypeName());
			Find f = new Find();
			f.setQuery(parameters.getQuery());
			f.getCriteria().add(c);
			FindResponse fr = resourceManager.find(f);
			for(Object obj: fr.getAny()) {
				schemas.add((EJaxbSchema)((AbstractXmlObjectNodeImpl)obj).getModelObject());
			}
		} catch (FindFault e) {
			FaultMessage businessFault = new FaultMessage();
			FaultMessage faultError = new FaultMessage(e.getMessage(), businessFault);
			if (faultError.getFaultInfo()!= null){
				faultError.getFaultInfo().setMessage(e.getMessage());
			}
			throw faultError;
		}
		FindComplexTypesResponse response = new FindComplexTypesResponse();
		response.getAny().addAll(schemas);
		return response;
	}

	@Override
	public FindSimpleTypesResponse findSimpleTypes(FindSimpleTypes parameters)
			throws com.petalslink.data_api._1_0.FaultMessage {
		List<EJaxbSchema> schemas = new ArrayList<EJaxbSchema>();
		LOG.fine("Call findSimpleTypes method");
		try {
			Criteria c = new Criteria();
			c.setName("resource-type");
			c.setValue(SimpleTypeResourceType.getInstance().getTypeName());
			Find f = new Find();
			f.setQuery(parameters.getQuery());
			f.getCriteria().add(c);
			FindResponse fr = resourceManager.find(f);
			for(Object obj: fr.getAny()) {
				schemas.add((EJaxbSchema)((AbstractXmlObjectNodeImpl)obj).getModelObject());
			}
		} catch (FindFault e) {
			FaultMessage businessFault = new FaultMessage();
			FaultMessage faultError = new FaultMessage(e.getMessage(), businessFault);
			if (faultError.getFaultInfo()!= null){
				faultError.getFaultInfo().setMessage(e.getMessage());
			}
			throw faultError;
		}
		FindSimpleTypesResponse response = new FindSimpleTypesResponse();
		response.getAny().addAll(schemas);
		return response;
	}

	@Override
	public void getInfo() {
		// TODO Auto-generated method stub
		
	}


}
