/*******************************************************************************
 * Copyright (c) 2011 EBM Websourcing.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v2.1
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * 
 * Contributors:
 *     EBM Websourcing - initial API and implementation
 ******************************************************************************/
/**
 * PETALS - PETALS Services Platform.
 * Copyright (c) 2008 EBM Websourcing, http://www.ebmwebsourcing.com/
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -------------------------------------------------------------------------
 * $Id$
 * -------------------------------------------------------------------------
 */

package com.ebmwebsourcing.easiergov.launcher.tasks;

import java.util.List;

import com.petalslink.easiergov.core.container.Container;
import com.petalslink.easiergov.core.container.Server;
import com.petalslink.easiergov.resources.api.GovException;

/**
 * 
 * Created on 13 févr. 08
 * 
 * @author Christophe HAMERLING - eBM WebSourcing
 * @since
 * 
 */
public class InfoTask extends Task {


	private Container node = null;
	

	/**
     * 
     * @param node 
	 * @param petalsServer
     */
    public InfoTask(Container node) {
    	this.node = node;
        this.setShortcut("i");
        this.setName("info");
        this.setDescription("Display the local container information");

    }

    @Override
    public int doProcess(List<String> args) {
        try {
            System.out.println("Infos:\n");
            if(node != null) {
            	System.out.println("\tList of services deployed:");
            	for(Server s: this.node.getServers()) {
            		System.out.println("\t\t" + s.getName() + " at " + s.getAddress());
            	}
            	System.out.println("\n\n");
            } else {
            	throw new GovException("node cannot be null");
            }
        } catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return OK_CODE;
    }
    
}
