/*
 * Decompiled with CFR 0.152.
 */
package com.ebmwebsourcing.easiergov.launcher;

import com.ebmwebsourcing.easiergov.launcher.Launcher;
import com.ebmwebsourcing.easiergov.launcher.tasks.InfoTask;
import com.ebmwebsourcing.easiergov.launcher.util.CommandReader;
import com.ebmwebsourcing.easiergov.launcher.util.Locker;
import com.ebmwebsourcing.easiergov.launcher.util.SystemExitHook;
import com.petalslink.easiergov.core.container.Container;
import com.petalslink.easiergov.resources.api.GovException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.LogManager;

public abstract class AbstractContainerLauncher
implements Launcher {
    private static final String START_COMMAND = "start";
    private static final String SHUTDOWN_COMMAND = "shutdown";
    private static final String VERSION_COMMAND = "version";
    private static final String LOGGER_FILE = "logger.properties";
    private Container container;
    private SystemExitHook systemExitHook;
    private final Locker locker = new Locker(new File("."));

    static {
        try {
            InputStream inputStream = null;
            File logger = new File(LOGGER_FILE);
            inputStream = logger.exists() ? new FileInputStream(logger) : AbstractContainerLauncher.class.getClass().getResourceAsStream("/logger.properties");
            if (inputStream != null) {
                LogManager.getLogManager().readConfiguration(inputStream);
                inputStream.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("couldn't initialize logging properly", e);
        }
    }

    public AbstractContainerLauncher(Container c) {
        this.showBanner();
        this.container = c;
    }

    protected void showBanner() {
        System.out.println();
        System.out.println(" -----------------------------------------------------------");
        System.out.println("|                                                           |");
        System.out.println("|                        EasierGOV                          |");
        System.out.println("|             EBM Research Service Governance               |");
        System.out.println("|             http://research.petalslink.org                |");
        System.out.println("|                                                           |");
        System.out.println(" -----------------------------------------------------------");
        System.out.println();
    }

    public void launch(String[] args) {
        ArrayList<String> command = new ArrayList<String>();
        boolean console = true;
        if (args == null || args.length == 0) {
            command.add(START_COMMAND);
        }
        if (args != null) {
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                command.add(arg);
                ++n2;
            }
        }
        try {
            if (command.contains(SHUTDOWN_COMMAND)) {
                System.out.println("Container is stopping...");
                this.shutdown();
            } else if (command.contains(VERSION_COMMAND)) {
                this.version();
            } else if (command.contains(START_COMMAND)) {
                System.out.println("Container is starting...");
                this.start();
                if (console) {
                    this.commandLineMode(this.container);
                }
                if (this.systemExitHook != null) {
                    Runtime.getRuntime().removeShutdownHook(this.systemExitHook);
                }
                this.systemExitHook.run();
                System.exit(0);
            } else {
                System.out.println("Command '" + command + "' is unknown");
                this.printUsage();
                System.exit(-1);
            }
        }
        catch (Throwable e) {
            System.out.println("Command processing error : " + command);
            e.printStackTrace(System.err);
            if (this.systemExitHook != null) {
                Runtime.getRuntime().removeShutdownHook(this.systemExitHook);
            }
            System.exit(-1);
        }
    }

    @Override
    public void start() throws Exception {
        if (this.locker.isLocked()) {
            throw new GovException("Can not start the Container server, remove lock file from Container root path or stop server");
        }
        this.locker.lock();
        this.container.start();
        new InfoTask(this.container).doProcess(null);
        this.systemExitHook = new SystemExitHook(this.locker);
        Runtime.getRuntime().addShutdownHook(this.systemExitHook);
    }

    @Override
    public void shutdown() throws Exception {
        if (this.systemExitHook == null) {
            this.systemExitHook = new SystemExitHook(this.locker);
        }
        this.systemExitHook.start();
    }

    @Override
    public void version() throws Exception {
        System.out.println("No version");
    }

    protected void printUsage() {
        System.out.println("usage:");
        System.out.println(" -start                  start the container");
        System.out.println(" -shutdowm               shutdown the container");
        System.out.println(" -version                get the container version");
    }

    private void printStartedMessage() {
        this.printSpecificStartMessage();
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat sdf = new SimpleDateFormat();
        System.out.println();
        System.out.println("Container " + this.getDistributionName() + " distribution successfully started - " + sdf.format(date));
    }

    protected void printSpecificStartMessage() {
    }

    protected void commandLineMode(Container node) throws Exception {
        CommandReader console = new CommandReader(node);
        console.read();
    }

    protected abstract String getDistributionName();
}

