package com.ebmwebsourcing.easiergov;

import com.petalslink.easiergov.admin.AdminManagerImpl;
import com.petalslink.easiergov.core.config.Configuration;
import com.petalslink.easiergov.core.impl.AbstractContainer;
import com.petalslink.easiergov.core.impl.CoreManagerImpl;
import com.petalslink.easiergov.core.impl.ServerImpl;
import com.petalslink.easiergov.events.EventsManagerImpl;
import com.petalslink.easiergov.events.EventsProducerAndTopicNameSpaceAnalyzerServiceImpl;
import com.petalslink.easiergov.resources.ResourcesManagerImpl;
import com.petalslink.easiergov.resources.api.GovException;
import com.petalslink.easiergov.services.DefinitionsResourceAnalyzerServiceImpl;
import com.petalslink.easiergov.services.ServicesManagerImpl;

public class WSContainer extends AbstractContainer {

    public WSContainer(Configuration conf) throws GovException {
        super(conf);
        CoreManagerImpl.getInstance().setConfiguration(conf);

        ResourcesManagerImpl.getInstance().addResourceAnalyzerService(new DefinitionsResourceAnalyzerServiceImpl());
        ResourcesManagerImpl.getInstance().addResourceAnalyzerService(new EventsProducerAndTopicNameSpaceAnalyzerServiceImpl());


        this.addServers(
                new ServerImpl("Admin API"       , "http://" + conf.getHost() + ":" + conf.getPort() + "/services/adminManager", new AdminManagerImpl(this)),
                new ServerImpl("Connexion API"   , "http://" + conf.getHost() + ":" + conf.getPort() + "/services/connexionManager", CoreManagerImpl.getInstance().getConnexionManager()),
                new ServerImpl("Resources API"   , "http://" + conf.getHost() + ":" + conf.getPort() + "/services/resourcesManager", ResourcesManagerImpl.getInstance()),
                new ServerImpl("USDL Service API", "http://" + conf.getHost() + ":" + conf.getPort() + "/services/usdlServiceManager", ServicesManagerImpl.getInstance()),
                new ServerImpl("Event API"       , "http://" + conf.getHost() + ":" + conf.getPort() + "/services/eventManager", EventsManagerImpl.getInstance()));
    }

}
