package com.petalslink.easiergov.core.container;

import java.util.List;

import javax.xml.namespace.QName;

import com.petalslink.easiergov.GovException;
import com.petalslink.easiergov.config.Configuration;

public interface Container {

    QName getQName();
    
    void setQName(QName name);
	
	Configuration getConfiguration();
	
	void addServers(Server... s);
	
	List<Server> getServers();
	
	void start() throws GovException;
	
	void stop() throws GovException;

	<C> C getServerImplementation(Class<C> clazz);
}
