package com.petalslink.easiergov.core.impl;

import java.util.ArrayList;
import java.util.List;

import javax.xml.namespace.QName;

import com.petalslink.easiergov.GovException;
import com.petalslink.easiergov.config.Configuration;
import com.petalslink.easiergov.core.container.Container;
import com.petalslink.easiergov.core.container.Server;

public abstract class AbstractContainer implements Container {

	private Configuration configuration = null;

	private List<Server> servers = new ArrayList<Server>();

	private QName name = null;
	
	public AbstractContainer(Configuration configuration) {
		this.configuration = configuration;
		this.name = new QName(configuration.getNamespace(), configuration.getName());
	}

	@Override
	public Configuration getConfiguration() {
		return this.configuration;
	}

	@Override
	public void addServers(Server... servers) {
		for(Server s: servers) {
			this.servers.add(s);
		}
	}

	@Override
	public List<Server> getServers() {
		return this.servers;
	}
	
	@SuppressWarnings("unchecked")
    @Override
	public <C> C getServerImplementation(Class<C> clazz) {
	    C res = null;
	    for(Server s: this.servers) {
	        if(s.getImplementation().getClass().getName().equals(clazz.getName())) {
	            res = (C)s.getImplementation();
	            break;
	        }
	    }
	    return res;
	}

	@Override
	public void start() throws GovException {
		for(Server s: this.servers) {
			System.out.println("start " + s.getName());
			s.start();
		}
	}

	@Override
	public void stop() throws GovException {
		for(Server s: this.servers) {
			s.stop();
		}
	}

    @Override
    public QName getQName() {
        return this.name;
    }

    @Override
    public void setQName(QName name) {
        this.name = name;
    }
	
	

}
