/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiergov.core.impl;

import com.petalslink.easiergov.GovException;
import com.petalslink.easiergov.config.Configuration;
import com.petalslink.easiergov.core.container.Container;
import com.petalslink.easiergov.core.container.Server;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;

public abstract class AbstractContainer
implements Container {
    private Configuration configuration = null;
    private List<Server> servers = new ArrayList<Server>();
    private QName name = null;

    public AbstractContainer(Configuration configuration) {
        this.configuration = configuration;
        this.name = new QName(configuration.getNamespace(), configuration.getName());
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void addServers(Server ... servers) {
        for (Server s : servers) {
            this.servers.add(s);
        }
    }

    public List<Server> getServers() {
        return this.servers;
    }

    public <C> C getServerImplementation(Class<C> clazz) {
        Object res = null;
        for (Server s : this.servers) {
            if (!s.getImplementation().getClass().getName().equals(clazz.getName())) continue;
            res = s.getImplementation();
            break;
        }
        return (C)res;
    }

    public void start() throws GovException {
        for (Server s : this.servers) {
            System.out.println("start " + s.getName());
            s.start();
        }
    }

    public void stop() throws GovException {
        for (Server s : this.servers) {
            s.stop();
        }
    }

    public QName getQName() {
        return this.name;
    }

    public void setQName(QName name) {
        this.name = name;
    }
}

