

package com.petalslink.easiergov.core.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.w3c.dom.Document;

import com.petalslink.easiergov.resources.ResourcesManagerImpl;
import com.petalslink.esstar.essynchronizer.impl.AbstractResourcesManager;
import com.petalslink.esstar.essynchronizer.impl.ConnexionManagerImpl;
import com.petalslink.esstar.essynchronizer.impl.ResourceException;
import com.petalslink.resources_api._1.PublishResponse;
import com.petalslink.resources_api._1_0.PublishFault;

import easybox.esstar.petalslink.com.management.model.datatype._1.EJaxbResourceIdentifier;

public class ResourcesManager extends AbstractResourcesManager {

	private ConnexionManagerImpl connexionManager;
	private ResourcesManagerImpl resourcesManager = null;

	public ResourcesManager(ConnexionManagerImpl connexionManager, ResourcesManagerImpl resourcesManager) {
		super();
		this.connexionManager = connexionManager;
		this.resourcesManager = resourcesManager;
	}


	@SuppressWarnings("unused")
	@Override
	public synchronized void analyzeResourceContent(EJaxbResourceIdentifier rid, Document doc, Map<String, Object> metadata) throws ResourceException {
		try {
			synchronized(doc) {
				List<String> esbNodes = new ArrayList<String>();
				for(String add: this.connexionManager.getExecutionEnvironment().keySet()) {
					esbNodes.add(add);
				}
				if(metadata == null) {
					metadata = new HashMap<String, Object>();
				}
				metadata.put("esbNodes", esbNodes);

				PublishResponse publishResponse = this.resourcesManager.publish(doc, metadata);
			}
		} catch (PublishFault e) {
			throw new ResourceException(e);
		}
	}

}
