package com.petalslink.easiergov.resources;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.w3c.dom.Document;

import com.petalslink.easiergov.resources.api.AbstractResourceAnalyzerService;
import com.petalslink.easiergov.resources.api.GovException;
import com.petalslink.easiergov.resources.api.Resource;
import com.petalslink.easiergov.resources.api.ResourceAnalyzerManager;
import com.petalslink.easiergov.resources.api.ResourceAnalyzerService;
import com.petalslink.easiergov.resources.api.ResourceType;

public class ResourceAnalyzerManagerImpl implements ResourceAnalyzerManager {

    private List<ResourceAnalyzerService> services = new ArrayList<ResourceAnalyzerService>();

    public ResourceAnalyzerManagerImpl() {

    }

    @Override
    public List<ResourceType> getAllResourceType() {
        List<ResourceType> types = new ArrayList<ResourceType>();
        for(ResourceAnalyzerService ras: this.services) {
            types.addAll(ras.getResourceTypes());
        }
        return types;
    }

    @Override
    public void addResourceAnalyzerService(AbstractResourceAnalyzerService ras) throws GovException {
        if(this.services.contains(ras)) {
            throw new GovException("This analyzer is already installed: " + ras);
        }
        this.services.add(ras);
    }

    @Override
    public List<Resource> analyse(Document doc, Map<String, Object> metadata) throws GovException {
        List<Resource> response = new ArrayList<Resource>();
        
        // analyse
        List<Resource> responseFirst = new ArrayList<Resource>();
        for(ResourceAnalyzerService ras: this.services) {
            responseFirst.addAll(ras.analyse(doc, metadata));
        }

        // post analyse
        List<Resource> responseSecond = new ArrayList<Resource>();
        for(Resource r: responseFirst) {
            for(ResourceAnalyzerService ras2: this.services) {
                responseSecond.addAll(ras2.postAnalyse(r));
            }
        }

        response.addAll(responseFirst);
        response.addAll(responseSecond);
        return response;
    }

    @Override
    public ResourceType findResourceType(String name) {
        ResourceType res = null;
        for(ResourceType r: this.getAllResourceType()) {
            if(r.getTypeName().equals(name)) {
                res = r;
                break;
            }
        }
        return res;
    }

    @Override
    public void clear() {
        this.services.clear();
    }

}
