/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiergov.resources;

import com.petalslink.easiergov.GovException;
import com.petalslink.easiergov.resources.api.AbstractResourceAnalyzerService;
import com.petalslink.easiergov.resources.api.Resource;
import com.petalslink.easiergov.resources.api.ResourceAnalyzerManager;
import com.petalslink.easiergov.resources.api.ResourceAnalyzerService;
import com.petalslink.easiergov.resources.api.ResourceType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;

public class ResourceAnalyzerManagerImpl
implements ResourceAnalyzerManager {
    private List<ResourceAnalyzerService> services = new ArrayList<ResourceAnalyzerService>();

    public List<ResourceType> getAllResourceType() {
        ArrayList<ResourceType> types = new ArrayList<ResourceType>();
        for (ResourceAnalyzerService ras : this.services) {
            types.addAll(ras.getResourceTypes());
        }
        return types;
    }

    public void addResourceAnalyzerService(AbstractResourceAnalyzerService ras) throws GovException {
        if (this.services.contains(ras)) {
            throw new GovException("This analyzer is already installed: " + ras);
        }
        this.services.add((ResourceAnalyzerService)ras);
    }

    public List<Resource> analyse(Document doc, Map<String, Object> metadata) throws GovException {
        ArrayList<Resource> response = new ArrayList<Resource>();
        ArrayList responseFirst = new ArrayList();
        for (ResourceAnalyzerService ras : this.services) {
            responseFirst.addAll(ras.analyse(doc, metadata));
        }
        ArrayList responseSecond = new ArrayList();
        for (Resource r : responseFirst) {
            for (ResourceAnalyzerService ras2 : this.services) {
                responseSecond.addAll(ras2.postAnalyse(r));
            }
        }
        response.addAll(responseFirst);
        response.addAll(responseSecond);
        return response;
    }

    public ResourceType findResourceType(String name) {
        ResourceType res = null;
        for (ResourceType r : this.getAllResourceType()) {
            if (!r.getTypeName().equals(name)) continue;
            res = r;
            break;
        }
        return res;
    }

    public void clear() {
        this.services.clear();
    }
}

