package com.petalslink.easiergov.resources;

import javax.xml.namespace.QName;

import com.petalslink.easiergov.resources.api.Resource;
import com.petalslink.easiergov.resources.api.ResourceType;

public class ResourceImpl implements Resource {

	private QName id = null;
	
	private ResourceType type = null;
	
	private Object content = null;
	
	
	public ResourceImpl(QName id, ResourceType type, Object content) {
		this.id = id;
		this.type = type;
		this.content = content;
	}
	
	@Override
	public ResourceType getResourceType() {
		return this.type;
	}

	@Override
	public Object getContent() {
		return this.content;
	}

	@Override
	public <C> C getContent(Class<C> clazz) {
			throw new UnsupportedOperationException();
		//return null;
	}

	@Override
	public QName getId() {
		return this.id;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((id == null) ? 0 : id.hashCode());
		result = prime * result + ((type == null) ? 0 : type.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		ResourceImpl other = (ResourceImpl) obj;
		if (id == null) {
			if (other.id != null)
				return false;
		} else if (!id.equals(other.id))
			return false;
		if (type == null) {
			if (other.type != null)
				return false;
		} else if (!type.equals(other.type))
			return false;
		return true;
	}


}
