/*
 * Decompiled with CFR 0.152.
 */
package com.petalslink.easiergov.resources;

import com.petalslink.easiergov.GovException;
import com.petalslink.easiergov.config.Configuration;
import com.petalslink.easiergov.config.ConfigurationImpl;
import com.petalslink.easiergov.resources.ResourcesManagerImpl;
import com.petalslink.easiergov.resources.api.AbstractResourceAnalyzerService;
import com.petalslink.easiergov.resources.test.util.DefinitionsResourceAnalyzerServiceImpl;
import com.petalslink.resources_api._1.Find;
import com.petalslink.resources_api._1.FindResponse;
import com.petalslink.resources_api._1.Get;
import com.petalslink.resources_api._1.GetResponse;
import com.petalslink.resources_api._1.Publish;
import com.petalslink.resources_api._1.PublishResponse;
import com.petalslink.resources_api._1.Remove;
import com.petalslink.resources_api._1.RemoveResponse;
import com.petalslink.resources_api._1.ResourceIdentifier;
import com.petalslink.resources_api._1_0.FindFault;
import com.petalslink.resources_api._1_0.GetFault;
import com.petalslink.resources_api._1_0.PublishFault;
import com.petalslink.resources_api._1_0.RemoveFault;
import java.net.URL;
import java.util.List;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ResourcesImplTest {
    private ResourcesManagerImpl resourcesManager = null;

    @Before
    public void setup() throws GovException {
        this.resourcesManager = new ResourcesManagerImpl((Configuration)new ConfigurationImpl());
    }

    public List<ResourceIdentifier> publish(URL url) throws PublishFault {
        Publish request = new Publish();
        request.setRessourceUrl(url.toString());
        PublishResponse response = this.resourcesManager.publish(request);
        return response.getResourceIdentifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPublishResource() throws PublishFault, GovException {
        try {
            this.resourcesManager.addResourceAnalyzerService((AbstractResourceAnalyzerService)new DefinitionsResourceAnalyzerServiceImpl());
            List<ResourceIdentifier> id = this.publish(Thread.currentThread().getContextClassLoader().getResource("firemen.wsdl"));
            System.out.println("id = " + id);
            Assert.assertNotNull(id);
            Assert.assertEquals((long)1L, (long)id.size());
        }
        finally {
            this.resourcesManager.clear();
            System.out.println("=============== CLEAR: " + this.resourcesManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetResource() throws PublishFault, GovException, GetFault {
        try {
            this.resourcesManager.addResourceAnalyzerService((AbstractResourceAnalyzerService)new DefinitionsResourceAnalyzerServiceImpl());
            List<ResourceIdentifier> id = this.publish(Thread.currentThread().getContextClassLoader().getResource("firemen.wsdl"));
            System.out.println("id = " + id);
            Assert.assertNotNull(id);
            Assert.assertEquals((long)1L, (long)id.size());
            Get request = new Get();
            request.setId(QName.valueOf(id.get(0).getId()));
            request.setResourceType(id.get(0).getResourceType());
            GetResponse response = this.resourcesManager.get(request);
            Assert.assertNotNull((Object)response.getAny());
        }
        finally {
            this.resourcesManager.clear();
            System.out.println("=============== CLEAR: " + this.resourcesManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFindResource() throws PublishFault, GovException, GetFault, FindFault {
        try {
            this.resourcesManager.addResourceAnalyzerService((AbstractResourceAnalyzerService)new DefinitionsResourceAnalyzerServiceImpl());
            List<ResourceIdentifier> id = this.publish(Thread.currentThread().getContextClassLoader().getResource("firemen.wsdl"));
            System.out.println("id = " + id);
            Assert.assertNotNull(id);
            Assert.assertEquals((long)1L, (long)id.size());
            Find request = new Find();
            request.setQuery(id.get(0).getId());
            FindResponse response = this.resourcesManager.find(request);
            Assert.assertNotNull((Object)response.getAny());
        }
        finally {
            this.resourcesManager.clear();
            System.out.println("=============== CLEAR: " + this.resourcesManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoveResource() throws PublishFault, GovException, RemoveFault {
        try {
            this.resourcesManager.addResourceAnalyzerService((AbstractResourceAnalyzerService)new DefinitionsResourceAnalyzerServiceImpl());
            List<ResourceIdentifier> id = this.publish(Thread.currentThread().getContextClassLoader().getResource("firemen.wsdl"));
            System.out.println("id = " + id);
            Assert.assertNotNull(id);
            Assert.assertEquals((long)1L, (long)id.size());
            Remove request = new Remove();
            request.setResourceIdentifier(new ResourceIdentifier());
            request.getResourceIdentifier().setId(id.get(0).getId());
            request.getResourceIdentifier().setResourceType(id.get(0).getResourceType());
            RemoveResponse response = this.resourcesManager.remove(request);
            Assert.assertNotNull((Object)response.getAny());
        }
        finally {
            this.resourcesManager.clear();
            System.out.println("=============== CLEAR: " + this.resourcesManager);
        }
    }
}

