package com.ebmwebsourcing.easiergov.cli.impl;

import com.ebmwebsourcing.easiergov.cli.impl.command.ConnectToEnvironmentCommand;
import com.ebmwebsourcing.easiergov.cli.impl.command.GOVConnectCommand;
import com.ebmwebsourcing.easiergov.cli.impl.command.GOVScriptCommand;
import com.ebmwebsourcing.easiergov.cli.impl.command.PublishTopicNamespaceFromUrlCommand;
import com.ebmwebsourcing.easiergov.client.impl.soap.ConnexionManagerClientImplSOAP;
import com.ebmwebsourcing.easyesb.cli.impl.AbstractCommandManager;
import com.ebmwebsourcing.easyesb.cli.impl.command.ExitCommand;
import com.ebmwebsourcing.easyesb.cli.impl.command.HelpCommand;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.ebmwebsourcing.easyevent.impl.client.soap.EventManagerClientImplSOAP;



public class GOVCommandManager extends AbstractCommandManager {



	/**
	 * 
	 * @param node 
	 * @param petalsService
	 * @param petalsServer
	 * @throws ESBException 
	 * @throws ConnectionErrorException
	 * @throws PetalsAdminServiceErrorException
	 * @throws PetalsAdminDoesNotExistException
	 */
	public GOVCommandManager() throws ESBException {
		super();
	}

	@Override
	public void init(String host) throws ESBException {

		this.connectionAddress = host;

		ConnexionManagerClientImplSOAP userClient = new ConnexionManagerClientImplSOAP(this.connectionAddress);
		EventManagerClientImplSOAP eventClient = new EventManagerClientImplSOAP(this.connectionAddress);

		// create the commands
		this.map.clear();
		addCommand(new GOVConnectCommand(this));
		addCommand(new HelpCommand(this));
		addCommand(new ExitCommand(this));

		if(this.connectionAddress != null) {
			addCommand(new GOVScriptCommand(userClient, this));
			addCommand(new GOVConnectCommand(this));
			addCommand(new ConnectToEnvironmentCommand(userClient));
			addCommand(new PublishTopicNamespaceFromUrlCommand(eventClient));
		} else {
			
		}
	}

}
