package com.ebmwebsourcing.easiergov.cli.impl.command;

import java.util.List;

import com.ebmwebsourcing.easiergov.client.impl.soap.ConnexionManagerClientImplSOAP;
import com.ebmwebsourcing.easyesb.cli.impl.AbstractCommand;
import com.ebmwebsourcing.easyesb.soa.api.ESBException;
import com.petalslink.esstar.execution_environment_synchronizer_impl._1.ConnectToEnvironment;
import com.petalslink.esstar.execution_environment_synchronizer_impl._1.ConnectToEnvironmentResponse;


public class ConnectToEnvironmentCommand extends AbstractCommand<ConnexionManagerClientImplSOAP> {

	private String url;
	
	
	public ConnectToEnvironmentCommand(ConnexionManagerClientImplSOAP client) throws ESBException {
		super(client);
		this.setName("ConnectToEnvironment");
		this.setDescription("Connect to environment");
		this.setShortcut("co");
	}
	
	@Override
	public void execute() {
		try {
			ConnectToEnvironment request = new ConnectToEnvironment();
			request.setEndpointAddress(this.url);
			ConnectToEnvironmentResponse res = this.getClient().connectToEnvironment(request);
			setResult("Connect to " + res.getExecutionEnvironmentInformation().getName());
			this.resultCode = AbstractCommand.OK_CODE;
			
		} catch (Throwable e) {
			setResult(e.getLocalizedMessage());
			this.resultCode = AbstractCommand.ERROR_CODE;
			
		}
		
	}

	@Override
	protected int doProcess(List<String> args) {
		this.url = args.get(0);
		execute();
		return this.resultCode;
		
	}

	@Override
	protected boolean validateArgs(List<String> args) {
		if(args.size() == 1){
			return true;
		}
		return false;
	}

	@Override
	public String toString() {
		return "co <url> \t\t\t\t\t\t{Connect to ESB}";
	}
	
}
